/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils.validation;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.validation.ValidationMessage;

@MarkedToMoveToAdjunctPackage
public class ValidationContextCarrier {
    private List<ValidationContextResourceProxy> resources = new ArrayList<ValidationContextResourceProxy>();

    public List<ValidationContextResourceProxy> getResources() {
        return this.resources;
    }

    public static class ValidationContextResourceProxy {
        private Resource resource;
        private Element element;
        private IValidationContextResourceLoader loader;
        private List<ValidationMessage> errors;
        private String path;

        public ValidationContextResourceProxy(Resource resource) {
            this.resource = resource;
        }

        public ValidationContextResourceProxy(List<ValidationMessage> errors, String path, Element element, IValidationContextResourceLoader loader) {
            this.errors = errors;
            this.path = path;
            this.element = element;
            this.loader = loader;
        }

        public Resource loadContainedResource(String id, Class<? extends Resource> class1) throws FHIRException {
            if (this.resource == null) {
                Resource res = this.loader.loadContainedResource(this.errors, this.path, this.element, id, class1);
                return res;
            }
            if (this.resource instanceof DomainResource) {
                for (Resource r : ((DomainResource)this.resource).getContained()) {
                    if (!r.getId().equals(id) || !class1.isInstance(r)) continue;
                    return r;
                }
            }
            return null;
        }
    }

    public static interface IValidationContextResourceLoader {
        public Resource loadContainedResource(List<ValidationMessage> var1, String var2, Element var3, String var4, Class<? extends Resource> var5) throws FHIRException;
    }
}

