/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.cache;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.json.JSONUtil;

public class PackageClient {
    private String address;
    private String cacheFolder;

    public PackageClient(String address) {
        this.address = address;
        try {
            this.cacheFolder = Utilities.path(System.getProperty("user.home"), ".fhir", "package-client");
            Utilities.createDirectory(this.cacheFolder);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean exists(String id, String ver) throws IOException {
        List<PackageInfo> vl = this.getVersions(id);
        for (PackageInfo pi : vl) {
            if (!ver.equals(pi.getVersion())) continue;
            return true;
        }
        return false;
    }

    public InputStream fetch(String id, String ver) throws IOException {
        return this.fetchCached(Utilities.pathURL(this.address, id, ver));
    }

    public InputStream fetch(PackageInfo info) throws IOException {
        return this.fetchCached(Utilities.pathURL(this.address, info.getId(), info.getVersion()));
    }

    public InputStream fetchNpm(String id, String ver) throws IOException {
        return this.fetchCached(Utilities.pathURL(this.address, id, "-", id + "-" + ver + ".tgz"));
    }

    public InputStream fetchCached(String url) throws IOException, FileNotFoundException {
        return this.fetchUrl(url, null);
    }

    protected String fn(String url) {
        String[] p = url.split("\\/");
        return p[2] + "-" + p[p.length - 2] + "-" + p[p.length - 1] + ".tgz";
    }

    public List<PackageInfo> getVersions(String id) throws IOException {
        ArrayList<PackageInfo> res = new ArrayList<PackageInfo>();
        try {
            JsonObject json = this.fetchJson(Utilities.pathURL(this.address, id));
            JsonObject versions = json.getAsJsonObject("versions");
            if (versions != null) {
                for (String v : this.sorted(versions.keySet())) {
                    JsonObject obj = versions.getAsJsonObject(v);
                    res.add(new PackageInfo(JSONUtil.str(obj, "name"), JSONUtil.str(obj, "version"), JSONUtil.str(obj, "FhirVersion"), JSONUtil.str(obj, "description"), JSONUtil.str(obj, "url"), JSONUtil.str(obj, "canonical")));
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return res;
    }

    private List<String> sorted(Set<String> keys) {
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(keys);
        Collections.sort(res);
        return res;
    }

    public List<PackageInfo> search(String name, String canonical, String fhirVersion, boolean preRelease) throws IOException {
        CommaSeparatedStringBuilder params = new CommaSeparatedStringBuilder("&");
        if (!Utilities.noString(name)) {
            params.append("name=" + name);
        }
        if (!Utilities.noString(canonical)) {
            params.append("canonical=" + canonical);
        }
        if (!Utilities.noString(fhirVersion)) {
            params.append("fhirversion=" + fhirVersion);
        }
        if (preRelease) {
            params.append("prerelease=" + preRelease);
        }
        ArrayList<PackageInfo> res = new ArrayList<PackageInfo>();
        try {
            JsonArray json = this.fetchJsonArray(Utilities.pathURL(this.address, "catalog?") + params.toString());
            for (JsonElement e : json) {
                JsonObject obj = (JsonObject)e;
                res.add(new PackageInfo(JSONUtil.str(obj, "Name", "name"), JSONUtil.str(obj, "Version", "version"), JSONUtil.str(obj, "FhirVersion", "fhirVersion"), JSONUtil.str(obj, "Description", "description"), JSONUtil.str(obj, "url"), JSONUtil.str(obj, "canonical")));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res;
    }

    public Date getNewPackages(Date lastCalled, List<PackageInfo> updates) {
        return null;
    }

    private InputStream fetchUrl(String source, String accept) throws IOException {
        URL url = new URL(source);
        URLConnection c = url.openConnection();
        if (accept != null) {
            c.setRequestProperty("accept", accept);
        }
        return c.getInputStream();
    }

    private JsonObject fetchJson(String source) throws IOException {
        String src = TextFile.streamToString(this.fetchUrl(source, "application/json"));
        return (JsonObject)new JsonParser().parse(src);
    }

    private JsonArray fetchJsonArray(String source) throws IOException {
        String src = TextFile.streamToString(this.fetchUrl(source, "application/json"));
        return (JsonArray)new JsonParser().parse(src);
    }

    public String url(String id, String v) {
        return Utilities.pathURL(this.address, id, v);
    }

    public String getLatestVersion(String id) throws IOException {
        List<PackageInfo> list = this.getVersions(id);
        if (list.isEmpty()) {
            throw new IOException("Package not found: " + id);
        }
        String v = list.get(0).version;
        for (PackageInfo p : list) {
            if (!VersionUtilities.isThisOrLater(v, p.version)) continue;
            v = p.version;
        }
        return v;
    }

    public class PackageInfo {
        private String id;
        private String version;
        private String fhirVersion;
        private String description;
        private String url;
        private String canonical;

        public PackageInfo(String id, String version, String fhirVersion, String description, String url, String canonical) {
            this.id = id;
            this.version = version;
            this.fhirVersion = fhirVersion;
            this.description = description;
            this.url = url;
            if (url == null && id != null && version != null) {
                url = Utilities.pathURL(PackageClient.this.address, id, version);
            }
            this.canonical = canonical;
        }

        public String getId() {
            return this.id;
        }

        public String getVersion() {
            return this.version;
        }

        public String getFhirVersion() {
            return this.fhirVersion;
        }

        public String getDescription() {
            return this.description;
        }

        public String getUrl() {
            return this.url;
        }

        public String getCanonical() {
            return this.canonical;
        }

        public String toString() {
            return this.id + "#" + (this.version == null ? "?pc-pi?" : this.version) + (this.fhirVersion == null ? "" : " (" + this.canonical + ") for FHIR " + this.fhirVersion) + (this.url == null ? "" : " @" + this.url) + (this.description == null ? "" : " '" + this.description + "'");
        }
    }
}

