/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.cache;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;

public class PackageGenerator {
    private OutputStream stream;
    private JsonObject object;

    public PackageGenerator() {
        this.object = new JsonObject();
    }

    public PackageGenerator(OutputStream stream) {
        this.stream = stream;
        this.object = new JsonObject();
    }

    public PackageGenerator(OutputStream stream, InputStream template) throws JsonSyntaxException, IOException {
        this.stream = stream;
        JsonParser parser = new JsonParser();
        this.object = parser.parse(TextFile.streamToString(template)).getAsJsonObject();
    }

    public JsonObject getRootJsonObject() {
        return this.object;
    }

    public void commit() throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((JsonElement)this.object);
        OutputStreamWriter sw = new OutputStreamWriter(this.stream, "UTF-8");
        sw.write(65279);
        sw.write(json);
        sw.flush();
        sw.close();
    }

    public PackageGenerator name(String value) {
        this.object.addProperty("name", value);
        return this;
    }

    public PackageGenerator version(String value) {
        this.object.addProperty("version", value);
        return this;
    }

    public PackageGenerator toolsVersion(int value) {
        this.object.addProperty("tools-version", (Number)value);
        return this;
    }

    public PackageGenerator description(String value) {
        this.object.addProperty("description", value);
        return this;
    }

    public PackageGenerator license(String value) {
        this.object.addProperty("license", value);
        return this;
    }

    public PackageGenerator homepage(String value) {
        this.object.addProperty("homepage", value);
        return this;
    }

    public PackageGenerator bugs(String value) {
        this.object.addProperty("bugs", value);
        return this;
    }

    public PackageGenerator author(String name, String email, String url) {
        JsonObject person = new JsonObject();
        person.addProperty("name", name);
        if (!Utilities.noString(email)) {
            person.addProperty("email", email);
        }
        if (!Utilities.noString(url)) {
            person.addProperty("url", url);
        }
        this.object.add("author", (JsonElement)person);
        return this;
    }

    public PackageGenerator contributor(String name, String email, String url) {
        JsonArray c;
        JsonObject person = new JsonObject();
        person.addProperty("name", name);
        if (!Utilities.noString(email)) {
            person.addProperty("email", email);
        }
        if (!Utilities.noString(url)) {
            person.addProperty("url", url);
        }
        if ((c = this.object.getAsJsonArray("contributors")) == null) {
            c = new JsonArray();
            this.object.add("contributors", (JsonElement)c);
        }
        c.add((JsonElement)person);
        return this;
    }

    public PackageGenerator dependency(String name, String version) {
        JsonObject dep = this.object.getAsJsonObject("dependencies");
        if (dep == null) {
            dep = new JsonObject();
            this.object.add("dependencies", (JsonElement)dep);
        }
        dep.addProperty(name, version);
        return this;
    }

    public PackageGenerator file(String name) {
        JsonArray files = this.object.getAsJsonArray("files");
        if (files == null) {
            files = new JsonArray();
            this.object.add("files", (JsonElement)files);
        }
        files.add((JsonElement)new JsonPrimitive(name));
        return this;
    }

    public PackageGenerator kind(PackageType kind) {
        this.object.addProperty("type", kind.getCode());
        return this;
    }

    public static enum PackageType {
        CORE,
        IG,
        TOOL,
        TEMPLATE,
        SUBSET;


        public String getCode() {
            switch (this) {
                case CORE: {
                    return "fhir.core";
                }
                case IG: {
                    return "fhir.ig";
                }
                case TOOL: {
                    return "fhir.tool";
                }
                case TEMPLATE: {
                    return "fhir.template";
                }
                case SUBSET: {
                    return "fhir.subset";
                }
            }
            throw new Error("Unknown Type");
        }
    }
}

