/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xhtml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlDocument;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XhtmlParser {
    public static final String XHTML_NS = "http://www.w3.org/1999/xhtml";
    private static final char END_OF_CHARS = '\uffff';
    private Set<String> elements = new HashSet<String>();
    private Set<String> attributes = new HashSet<String>();
    private Map<String, String> entities = new HashMap<String, String>();
    private ParserSecurityPolicy policy = ParserSecurityPolicy.Accept;
    private boolean trimWhitespace;
    private boolean mustBeWellFormed = true;
    private boolean validatorMode;
    private Reader rdr;
    private String cache = "";
    private XhtmlNode unwindPoint;
    private String lastText = "";
    private int line = 1;
    private int col = 0;
    private char lastChar;
    private XhtmlNode.Location lastLoc;

    public XhtmlParser() {
        this.elements.add("p");
        this.elements.add("br");
        this.elements.add("div");
        this.elements.add("h1");
        this.elements.add("h2");
        this.elements.add("h3");
        this.elements.add("h4");
        this.elements.add("h5");
        this.elements.add("h6");
        this.elements.add("a");
        this.elements.add("span");
        this.elements.add("b");
        this.elements.add("em");
        this.elements.add("i");
        this.elements.add("strong");
        this.elements.add("small");
        this.elements.add("big");
        this.elements.add("tt");
        this.elements.add("small");
        this.elements.add("dfn");
        this.elements.add("q");
        this.elements.add("var");
        this.elements.add("abbr");
        this.elements.add("acronym");
        this.elements.add("cite");
        this.elements.add("blockquote");
        this.elements.add("hr");
        this.elements.add("address");
        this.elements.add("bdo");
        this.elements.add("kbd");
        this.elements.add("q");
        this.elements.add("sub");
        this.elements.add("sup");
        this.elements.add("ul");
        this.elements.add("ol");
        this.elements.add("li");
        this.elements.add("dl");
        this.elements.add("dt");
        this.elements.add("dd");
        this.elements.add("pre");
        this.elements.add("table");
        this.elements.add("caption");
        this.elements.add("colgroup");
        this.elements.add("col");
        this.elements.add("thead");
        this.elements.add("tr");
        this.elements.add("tfoot");
        this.elements.add("tbody");
        this.elements.add("th");
        this.elements.add("td");
        this.elements.add("code");
        this.elements.add("samp");
        this.elements.add("img");
        this.elements.add("map");
        this.elements.add("area");
        this.attributes.add("title");
        this.attributes.add("style");
        this.attributes.add("class");
        this.attributes.add("id");
        this.attributes.add("lang");
        this.attributes.add("xml:lang");
        this.attributes.add("dir");
        this.attributes.add("accesskey");
        this.attributes.add("tabindex");
        this.attributes.add("span");
        this.attributes.add("width");
        this.attributes.add("align");
        this.attributes.add("valign");
        this.attributes.add("char");
        this.attributes.add("charoff");
        this.attributes.add("abbr");
        this.attributes.add("axis");
        this.attributes.add("headers");
        this.attributes.add("scope");
        this.attributes.add("rowspan");
        this.attributes.add("colspan");
        this.attributes.add("a.href");
        this.attributes.add("a.name");
        this.attributes.add("img.src");
        this.attributes.add("img.border");
        this.attributes.add("div.xmlns");
        this.attributes.add("blockquote.cite");
        this.attributes.add("q.cite");
        this.attributes.add("a.charset");
        this.attributes.add("a.type");
        this.attributes.add("a.name");
        this.attributes.add("a.href");
        this.attributes.add("a.hreflang");
        this.attributes.add("a.rel");
        this.attributes.add("a.rev");
        this.attributes.add("a.shape");
        this.attributes.add("a.coords");
        this.attributes.add("img.src");
        this.attributes.add("img.alt");
        this.attributes.add("img.longdesc");
        this.attributes.add("img.height");
        this.attributes.add("img.width");
        this.attributes.add("img.usemap");
        this.attributes.add("img.ismap");
        this.attributes.add("map.name");
        this.attributes.add("area.shape");
        this.attributes.add("area.coords");
        this.attributes.add("area.href");
        this.attributes.add("area.nohref");
        this.attributes.add("area.alt");
        this.attributes.add("table.summary");
        this.attributes.add("table.width");
        this.attributes.add("table.border");
        this.attributes.add("table.frame");
        this.attributes.add("table.rules");
        this.attributes.add("table.cellspacing");
        this.attributes.add("table.cellpadding");
    }

    public boolean isTrimWhitespace() {
        return this.trimWhitespace;
    }

    public void setTrimWhitespace(boolean trimWhitespace) {
        this.trimWhitespace = trimWhitespace;
    }

    public boolean isMustBeWellFormed() {
        return this.mustBeWellFormed;
    }

    public XhtmlParser setMustBeWellFormed(boolean mustBeWellFormed) {
        this.mustBeWellFormed = mustBeWellFormed;
        return this;
    }

    public boolean isValidatorMode() {
        return this.validatorMode;
    }

    public XhtmlParser setValidatorMode(boolean validatorMode) {
        this.validatorMode = validatorMode;
        return this;
    }

    public ParserSecurityPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(ParserSecurityPolicy policy) {
        this.policy = policy;
    }

    public XhtmlNode parseHtmlNode(Element node) throws FHIRFormatError {
        return this.parseHtmlNode(node, null);
    }

    public XhtmlNode parseHtmlNode(Element node, String defaultNS) throws FHIRFormatError {
        XhtmlNode res = this.parseNode(node, defaultNS);
        if (res.getNsDecl() == null) {
            res.getAttributes().put("xmlns", XHTML_NS);
        }
        return res;
    }

    private XhtmlNode parseNode(Element node, String defaultNS) throws FHIRFormatError {
        XhtmlNode res = new XhtmlNode(NodeType.Element);
        res.setName(node.getLocalName());
        defaultNS = this.checkNS(res, node, defaultNS);
        for (int i = 0; i < node.getAttributes().getLength(); ++i) {
            Attr attr = (Attr)node.getAttributes().item(i);
            if (!this.attributeIsOk(res.getName(), attr.getName(), attr.getValue()) || attr.getLocalName().startsWith("xmlns")) continue;
            res.getAttributes().put(attr.getName(), attr.getValue());
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() == 3) {
                res.addText(child.getTextContent());
                continue;
            }
            if (child.getNodeType() == 8) {
                res.addComment(child.getTextContent());
                continue;
            }
            if (child.getNodeType() == 1) {
                if (!this.elementIsOk(child.getLocalName())) continue;
                res.getChildNodes().add(this.parseNode((Element)child, defaultNS));
                continue;
            }
            throw new FHIRFormatError("Unhandled XHTML feature: " + Integer.toString(child.getNodeType()) + this.descLoc());
        }
        return res;
    }

    private String checkNS(XhtmlNode res, Element node, String defaultNS) {
        if (!this.validatorMode) {
            return null;
        }
        String ns = node.getNamespaceURI();
        if (ns == null) {
            return null;
        }
        if (!ns.equals(defaultNS)) {
            res.getAttributes().put("xmlns", ns);
            return ns;
        }
        return defaultNS;
    }

    public XhtmlNode parseHtmlNode(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        XhtmlNode res = this.parseNode(xpp);
        if (res.getNsDecl() == null) {
            res.getAttributes().put("xmlns", XHTML_NS);
        }
        return res;
    }

    private XhtmlNode parseNode(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        XhtmlNode res = new XhtmlNode(NodeType.Element);
        res.setName(xpp.getName());
        for (int i = 0; i < xpp.getAttributeCount(); ++i) {
            String an = "xml".equals(xpp.getAttributePrefix(i)) ? "xml:" + xpp.getAttributeName(i) : xpp.getAttributeName(i);
            String av = xpp.getAttributeValue(i);
            if (!this.attributeIsOk(xpp.getName(), an, av)) continue;
            res.getAttributes().put(an, av);
        }
        int eventType = xpp.next();
        while (eventType != 3) {
            if (eventType == 4) {
                res.addText(xpp.getText());
                xpp.next();
            } else if (eventType == 9) {
                res.addComment(xpp.getText());
                xpp.next();
            } else if (eventType == 2) {
                if (this.elementIsOk(xpp.getName())) {
                    res.getChildNodes().add(this.parseNode(xpp));
                }
            } else {
                throw new FHIRFormatError("Unhandled XHTML feature: " + Integer.toString(eventType) + this.descLoc());
            }
            eventType = xpp.getEventType();
        }
        xpp.next();
        return res;
    }

    private boolean attributeIsOk(String elem, String attr, String value) throws FHIRFormatError {
        boolean ok;
        if (this.validatorMode) {
            return true;
        }
        boolean bl = ok = this.attributes.contains(attr) || this.attributes.contains(elem + "." + attr);
        if (ok) {
            return true;
        }
        switch (this.policy) {
            case Accept: {
                return true;
            }
            case Drop: {
                return false;
            }
            case Reject: {
                throw new FHIRFormatError("Illegal HTML attribute " + elem + "." + attr);
            }
        }
        if ((elem + "." + attr).equals("img.src") && !value.startsWith("#") && !value.startsWith("http:") && !value.startsWith("https:")) {
            switch (this.policy) {
                case Accept: {
                    return true;
                }
                case Drop: {
                    return false;
                }
                case Reject: {
                    throw new FHIRFormatError("Illegal Image Reference " + value);
                }
            }
        }
        return false;
    }

    private boolean elementIsOk(String name) throws FHIRFormatError {
        if (this.validatorMode) {
            return true;
        }
        boolean ok = this.elements.contains(name);
        if (ok) {
            return true;
        }
        switch (this.policy) {
            case Accept: {
                return true;
            }
            case Drop: {
                return false;
            }
            case Reject: {
                throw new FHIRFormatError("Illegal HTML element " + name);
            }
        }
        return false;
    }

    private String descLoc() {
        return " at line " + Integer.toString(this.line) + " column " + Integer.toString(this.col);
    }

    public XhtmlDocument parse(String source, String entryName) throws FHIRFormatError, IOException {
        this.rdr = new StringReader(source);
        return this.parse(entryName);
    }

    public XhtmlDocument parse(InputStream input, String entryName) throws FHIRFormatError, IOException {
        this.rdr = new InputStreamReader(input, StandardCharsets.UTF_8);
        return this.parse(entryName);
    }

    private XhtmlDocument parse(String entryName) throws FHIRFormatError, IOException {
        XhtmlDocument result = new XhtmlDocument();
        this.skipWhiteSpaceAndComments(result);
        if (this.peekChar() != '<') {
            throw new FHIRFormatError("Unable to Parse HTML - does not start with tag. Found " + this.peekChar() + this.descLoc());
        }
        this.readChar();
        this.markLocation();
        QName n = new QName(this.readName().toLowerCase());
        if (entryName != null && !n.getName().equals(entryName)) {
            throw new FHIRFormatError("Unable to Parse HTML - starts with '" + n + "' not '" + entryName + "'" + this.descLoc());
        }
        XhtmlNode root = result.addTag(n.getName());
        root.setLocation(this.markLocation());
        this.parseAttributes(root);
        this.markLocation();
        NSMap nsm = this.checkNamespaces(n, root, null, true);
        if (this.readChar() == '/') {
            if (this.peekChar() != '>') {
                throw new FHIRFormatError("unexpected non-end of element " + n + " " + this.descLoc());
            }
            this.readChar();
        } else {
            this.unwindPoint = null;
            ArrayList<XhtmlNode> p = new ArrayList<XhtmlNode>();
            this.parseElementInner(root, p, nsm, true);
        }
        return result;
    }

    private XhtmlNode.Location markLocation() {
        XhtmlNode.Location res = this.lastLoc;
        this.lastLoc = new XhtmlNode.Location(this.line, this.col);
        return res;
    }

    private NSMap checkNamespaces(QName n, XhtmlNode node, NSMap nsm, boolean root) {
        NSMap result = new NSMap(nsm);
        ArrayList<String> nsattrs = new ArrayList<String>();
        for (String an : node.getAttributes().keySet()) {
            if (an.equals("xmlns")) {
                result.def(node.getAttribute(an));
                nsattrs.add(an);
            }
            if (!an.startsWith("xmlns:")) continue;
            result.ns(an.substring(6), node.getAttribute(an));
            nsattrs.add(an);
        }
        for (String s : nsattrs) {
            node.getAttributes().remove(s);
        }
        if (n.hasNs()) {
            String nns = result.get(n.getNs());
            if (!nns.equals(result.def())) {
                node.getAttributes().put("xmlns", nns);
                result.def(nns);
            }
        } else if (root && result.hasDef()) {
            node.getAttributes().put("xmlns", result.def());
        }
        return result;
    }

    private void addTextNode(XhtmlNode node, StringBuilder s) {
        String t;
        String string = t = this.isTrimWhitespace() ? s.toString().trim() : s.toString();
        if (t.length() > 0) {
            this.lastText = t;
            node.addText(t).setLocation(this.markLocation());
            s.setLength(0);
        }
    }

    private void parseElementInner(XhtmlNode node, List<XhtmlNode> parents, NSMap nsm, boolean escaping) throws FHIRFormatError, IOException {
        StringBuilder s = new StringBuilder();
        while (this.peekChar() != '\uffff' && !parents.contains(this.unwindPoint) && node != this.unwindPoint) {
            if (this.peekChar() == '<') {
                this.addTextNode(node, s);
                this.readChar();
                if (this.peekChar() == '!') {
                    String sc = this.readToCommentEnd();
                    node.addComment(sc).setLocation(this.markLocation());
                    continue;
                }
                if (this.peekChar() == '?') {
                    node.addComment(this.readToTagEnd()).setLocation(this.markLocation());
                    continue;
                }
                if (this.peekChar() == '/') {
                    int i;
                    this.readChar();
                    QName n = new QName(this.readToTagEnd());
                    if (node.getName().equals(n.getName())) {
                        return;
                    }
                    if (this.mustBeWellFormed) {
                        throw new FHIRFormatError("Malformed XHTML: Found \"</" + n.getName() + ">\" expecting \"</" + node.getName() + ">\"" + this.descLoc());
                    }
                    for (i = parents.size() - 1; i >= 0; --i) {
                        if (!parents.get(i).getName().equals(n)) continue;
                        this.unwindPoint = parents.get(i);
                    }
                    if (this.unwindPoint == null) continue;
                    for (i = parents.size(); i > 0; --i) {
                        if (i < parents.size() && parents.get(i) == this.unwindPoint) {
                            return;
                        }
                        if (i == parents.size()) {
                            parents.get(i - 1).getChildNodes().addAll(node.getChildNodes());
                            node.getChildNodes().clear();
                            continue;
                        }
                        parents.get(i - 1).getChildNodes().addAll(parents.get(i).getChildNodes());
                        parents.get(i).getChildNodes().clear();
                    }
                    continue;
                }
                if (Character.isLetterOrDigit(this.peekChar())) {
                    this.parseElement(node, parents, nsm);
                    continue;
                }
                throw new FHIRFormatError("Unable to Parse HTML - node '" + node.getName() + "' has unexpected content '" + this.peekChar() + "' (last text = '" + this.lastText + "'" + this.descLoc());
            }
            if (this.peekChar() == '&') {
                this.parseLiteral(s);
                continue;
            }
            s.append(this.readChar());
        }
        this.addTextNode(node, s);
    }

    private void parseElement(XhtmlNode parent, List<XhtmlNode> parents, NSMap nsm) throws IOException, FHIRFormatError {
        this.markLocation();
        QName name = new QName(this.readName());
        XhtmlNode node = parent.addTag(name.getName());
        node.setLocation(this.markLocation());
        ArrayList<XhtmlNode> newParents = new ArrayList<XhtmlNode>();
        newParents.addAll(parents);
        newParents.add(parent);
        this.parseAttributes(node);
        this.markLocation();
        nsm = this.checkNamespaces(name, node, nsm, false);
        if (this.readChar() == '/') {
            if (this.peekChar() != '>') {
                throw new FHIRFormatError("unexpected non-end of element " + name + " " + this.descLoc());
            }
            this.readChar();
        } else {
            this.parseElementInner(node, newParents, nsm, "script".equals(name.getName()));
        }
    }

    private void parseAttributes(XhtmlNode node) throws FHIRFormatError, IOException {
        while (Character.isWhitespace(this.peekChar())) {
            this.readChar();
        }
        while (this.peekChar() != '>' && this.peekChar() != '/' && this.peekChar() != '\uffff') {
            String name = this.readName();
            if (name.length() == 0) {
                throw new FHIRFormatError("Unable to read attribute on <" + node.getName() + ">" + this.descLoc());
            }
            while (Character.isWhitespace(this.peekChar())) {
                this.readChar();
            }
            if (this.isNameChar(this.peekChar()) || this.peekChar() == '>' || this.peekChar() == '/') {
                node.getAttributes().put(name, null);
            } else {
                if (this.peekChar() != '=') {
                    throw new FHIRFormatError("Unable to read attribute '" + name + "' value on <" + node.getName() + ">" + this.descLoc());
                }
                this.readChar();
                while (Character.isWhitespace(this.peekChar())) {
                    this.readChar();
                }
                if (this.peekChar() == '\"' || this.peekChar() == '\'') {
                    node.getAttributes().put(name, this.parseAttributeValue(this.readChar()));
                } else {
                    node.getAttributes().put(name, this.parseAttributeValue('\uffff'));
                }
            }
            while (Character.isWhitespace(this.peekChar())) {
                this.readChar();
            }
        }
    }

    private String parseAttributeValue(char term) throws IOException, FHIRFormatError {
        StringBuilder b = new StringBuilder();
        while (this.peekChar() != '\uffff' && this.peekChar() != '>' && (term != '\uffff' || this.peekChar() != '/') && this.peekChar() != term) {
            if (this.peekChar() == '&') {
                this.parseLiteral(b);
                continue;
            }
            b.append(this.readChar());
        }
        if (this.peekChar() == term) {
            this.readChar();
        }
        return b.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void skipWhiteSpaceAndComments(XhtmlNode focus) throws IOException, FHIRFormatError {
        while (Character.isWhitespace(this.peekChar()) || this.peekChar() == '\ufeff') {
            this.readChar();
        }
        if (this.peekChar() != '<') return;
        char ch = this.readChar();
        if (this.peekChar() == '!') {
            this.readChar();
            if (this.peekChar() == '-') {
                this.readChar();
                if (this.peekChar() != '-') throw new FHIRFormatError("unrecognised element type <!" + this.peekChar() + this.descLoc());
                this.readChar();
                if (this.peekChar() == ' ') {
                    this.readChar();
                }
                focus.addComment(this.readToCommentEnd());
            } else {
                focus.addDocType(this.readToDocTypeEnd());
            }
            this.skipWhiteSpaceAndComments(focus);
            return;
        } else if (this.peekChar() == '?') {
            String r = this.readToTagEnd();
            focus.addInstruction(r.substring(1, r.length() - 1));
            this.skipWhiteSpaceAndComments(focus);
            return;
        } else {
            this.pushChar(ch);
        }
    }

    private void skipWhiteSpace() throws IOException {
        if (this.trimWhitespace) {
            while (Character.isWhitespace(this.peekChar()) || this.peekChar() == '\ufeff') {
                this.readChar();
            }
        }
    }

    private void skipWhiteSpaceInternal() throws IOException {
        while (Character.isWhitespace(this.peekChar()) || this.peekChar() == '\ufeff') {
            this.readChar();
        }
    }

    private void pushChar(char ch) {
        this.cache = Character.toString(ch) + this.cache;
    }

    private char peekChar() throws IOException {
        if (this.cache.length() > 0) {
            return this.cache.charAt(0);
        }
        if (!this.rdr.ready()) {
            return '\uffff';
        }
        int i = this.rdr.read();
        if (i == -1) {
            this.cache = "";
            return '\uffff';
        }
        char c = (char)i;
        this.cache = Character.toString(c);
        return c;
    }

    private char readChar() throws IOException {
        char c;
        if (this.cache.length() > 0) {
            c = this.cache.charAt(0);
            this.cache = this.cache.length() == 1 ? "" : this.cache.substring(1);
        } else {
            c = !this.rdr.ready() ? (char)'\uffff' : (char)((char)this.rdr.read());
        }
        if (c == '\r' || c == '\n') {
            if (c == '\r' || this.lastChar != '\r') {
                ++this.line;
                this.col = 0;
            }
            this.lastChar = c;
        }
        ++this.col;
        return c;
    }

    private String readToTagEnd() throws IOException, FHIRFormatError {
        StringBuilder s = new StringBuilder();
        while (this.peekChar() != '>' && this.peekChar() != '\uffff') {
            s.append(this.readChar());
        }
        if (this.peekChar() != '\uffff') {
            this.readChar();
            this.skipWhiteSpace();
        } else if (this.mustBeWellFormed) {
            throw new FHIRFormatError("Unexpected termination of html source" + this.descLoc());
        }
        return s.toString();
    }

    private String readToDocTypeEnd() throws IOException, FHIRFormatError {
        StringBuilder s = new StringBuilder();
        boolean done = false;
        while (!done) {
            char c = this.peekChar();
            if (c == '>') {
                done = true;
                this.readChar();
                continue;
            }
            if (c != '\uffff') {
                s.append(this.readChar());
                continue;
            }
            if (!this.mustBeWellFormed) continue;
            throw new FHIRFormatError("Unexpected termination of html source" + this.descLoc());
        }
        return s.toString();
    }

    private String readToCommentEnd() throws IOException, FHIRFormatError {
        if (this.peekChar() == '!') {
            this.readChar();
        }
        StringBuilder s = new StringBuilder();
        boolean simple = true;
        if (this.peekChar() == '-') {
            this.readChar();
            boolean bl = simple = this.peekChar() != '-';
            if (simple) {
                s.append('-');
            } else {
                this.readChar();
            }
        }
        boolean doctypeEntities = false;
        boolean done = false;
        while (!done) {
            char c = this.peekChar();
            if (c == '-') {
                this.readChar();
                if (this.peekChar() == '-') {
                    this.readChar();
                    if (this.peekChar() == '>') {
                        done = true;
                        continue;
                    }
                    s.append("--");
                    continue;
                }
                s.append('-');
                continue;
            }
            if (doctypeEntities && c == ']') {
                s.append(this.readChar());
                if (this.peekChar() != '>') continue;
                done = true;
                continue;
            }
            if (simple && this.peekChar() == '>' && !doctypeEntities) {
                done = true;
                continue;
            }
            if (c == '[' && s.toString().startsWith("DOCTYPE ")) {
                doctypeEntities = true;
                s.append(this.readChar());
                continue;
            }
            if (c != '\uffff') {
                s.append(this.readChar());
                continue;
            }
            if (!this.mustBeWellFormed) continue;
            throw new FHIRFormatError("Unexpected termination of html source" + this.descLoc());
        }
        if (this.peekChar() != '\uffff') {
            this.readChar();
            this.skipWhiteSpace();
        }
        if (doctypeEntities) {
            this.parseDoctypeEntities(s.toString());
        }
        return s.toString();
    }

    private void parseDoctypeEntities(String s) {
        while (s.contains("<!ENTITY")) {
            s = s.substring(s.indexOf("<!ENTITY"));
            int e = s.indexOf(">");
            String ed = s.substring(0, e + 1);
            s = s.substring(e + 1);
            ed = ed.substring(8).trim();
            e = ed.indexOf(" ");
            String n = ed.substring(0, e).trim();
            ed = ed.substring(e).trim();
            e = ed.indexOf(" ");
            ed = ed.substring(e).trim();
            String v = ed.substring(0, ed.length() - 1);
            this.entities.put(n, v);
        }
    }

    private boolean isNameChar(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '_' || ch == '-' || ch == ':';
    }

    private String readName() throws IOException {
        StringBuilder s = new StringBuilder();
        while (this.isNameChar(this.peekChar())) {
            s.append(this.readChar());
        }
        return s.toString();
    }

    private String readUntil(char ch) throws IOException {
        StringBuilder s = new StringBuilder();
        while (this.peekChar() != '\u0000' && this.peekChar() != ch) {
            s.append(this.readChar());
        }
        this.readChar();
        return s.toString();
    }

    private String readUntil(String sc) throws IOException {
        StringBuilder s = new StringBuilder();
        while (this.peekChar() != '\u0000' && sc.indexOf(this.peekChar()) == -1) {
            s.append(this.readChar());
        }
        this.readChar();
        return s.toString();
    }

    private void parseLiteral(StringBuilder s) throws IOException, FHIRFormatError {
        this.readChar();
        String c = this.readUntil(";&'\"><");
        if (c.equals("apos")) {
            s.append('\'');
        } else if (c.equals("quot")) {
            s.append('\"');
        } else if (c.equals("nbsp")) {
            s.append(XhtmlNode.NBSP);
        } else if (c.equals("amp")) {
            s.append('&');
        } else if (c.equals("lsquo")) {
            s.append('\u2018');
        } else if (c.equals("rsquo")) {
            s.append('\u2019');
        } else if (c.equals("gt")) {
            s.append('>');
        } else if (c.equals("lt")) {
            s.append('<');
        } else if (c.equals("copy")) {
            s.append('\u00a9');
        } else if (c.equals("reg")) {
            s.append('\u00ae');
        } else if (c.equals("sect")) {
            s.append('\u00a7');
        } else if (c.charAt(0) == '#') {
            if (this.isInteger(c.substring(1), 10)) {
                s.append((char)Integer.parseInt(c.substring(1)));
            } else if (c.charAt(1) == 'x' && this.isInteger(c.substring(2), 16)) {
                s.append((char)Integer.parseInt(c.substring(2), 16));
            }
        } else if (c.equals("fnof")) {
            s.append('\u0192');
        } else if (c.equals("Alpha")) {
            s.append('\u0391');
        } else if (c.equals("Beta")) {
            s.append('\u0392');
        } else if (c.equals("Gamma")) {
            s.append('\u0393');
        } else if (c.equals("Delta")) {
            s.append('\u0394');
        } else if (c.equals("Epsilon")) {
            s.append('\u0395');
        } else if (c.equals("Zeta")) {
            s.append('\u0396');
        } else if (c.equals("Eta")) {
            s.append('\u0397');
        } else if (c.equals("Theta")) {
            s.append('\u0398');
        } else if (c.equals("Iota")) {
            s.append('\u0399');
        } else if (c.equals("Kappa")) {
            s.append('\u039a');
        } else if (c.equals("Lambda")) {
            s.append('\u039b');
        } else if (c.equals("Mu")) {
            s.append('\u039c');
        } else if (c.equals("Nu")) {
            s.append('\u039d');
        } else if (c.equals("Xi")) {
            s.append('\u039e');
        } else if (c.equals("Omicron")) {
            s.append('\u039f');
        } else if (c.equals("Pi")) {
            s.append('\u03a0');
        } else if (c.equals("Rho")) {
            s.append('\u03a1');
        } else if (c.equals("Sigma")) {
            s.append('\u03a3');
        } else if (c.equals("Tau")) {
            s.append('\u03a4');
        } else if (c.equals("Upsilon")) {
            s.append('\u03a5');
        } else if (c.equals("Phi")) {
            s.append('\u03a6');
        } else if (c.equals("Chi")) {
            s.append('\u03a7');
        } else if (c.equals("Psi")) {
            s.append('\u03a8');
        } else if (c.equals("Omega")) {
            s.append('\u03a9');
        } else if (c.equals("alpha")) {
            s.append('\u03b1');
        } else if (c.equals("beta")) {
            s.append('\u03b2');
        } else if (c.equals("gamma")) {
            s.append('\u03b3');
        } else if (c.equals("delta")) {
            s.append('\u03b4');
        } else if (c.equals("epsilon")) {
            s.append('\u03b5');
        } else if (c.equals("zeta")) {
            s.append('\u03b6');
        } else if (c.equals("eta")) {
            s.append('\u03b7');
        } else if (c.equals("theta")) {
            s.append('\u03b8');
        } else if (c.equals("iota")) {
            s.append('\u03b9');
        } else if (c.equals("kappa")) {
            s.append('\u03ba');
        } else if (c.equals("lambda")) {
            s.append('\u03bb');
        } else if (c.equals("mu")) {
            s.append('\u03bc');
        } else if (c.equals("nu")) {
            s.append('\u03bd');
        } else if (c.equals("xi")) {
            s.append('\u03be');
        } else if (c.equals("omicron")) {
            s.append('\u03bf');
        } else if (c.equals("pi")) {
            s.append('\u03c0');
        } else if (c.equals("rho")) {
            s.append('\u03c1');
        } else if (c.equals("sigmaf")) {
            s.append('\u03c2');
        } else if (c.equals("sigma")) {
            s.append('\u03c3');
        } else if (c.equals("tau")) {
            s.append('\u03c4');
        } else if (c.equals("upsilon")) {
            s.append('\u03c5');
        } else if (c.equals("phi")) {
            s.append('\u03c6');
        } else if (c.equals("chi")) {
            s.append('\u03c7');
        } else if (c.equals("psi")) {
            s.append('\u03c8');
        } else if (c.equals("omega")) {
            s.append('\u03c9');
        } else if (c.equals("thetasym")) {
            s.append('\u03d1');
        } else if (c.equals("upsih")) {
            s.append('\u03d2');
        } else if (c.equals("piv")) {
            s.append('\u03d6');
        } else if (c.equals("bull")) {
            s.append('\u2022');
        } else if (c.equals("hellip")) {
            s.append('\u2026');
        } else if (c.equals("prime")) {
            s.append('\u2032');
        } else if (c.equals("Prime")) {
            s.append('\u2033');
        } else if (c.equals("oline")) {
            s.append('\u203e');
        } else if (c.equals("frasl")) {
            s.append('\u2044');
        } else if (c.equals("weierp")) {
            s.append('\u2118');
        } else if (c.equals("image")) {
            s.append('\u2111');
        } else if (c.equals("real")) {
            s.append('\u211c');
        } else if (c.equals("trade")) {
            s.append('\u2122');
        } else if (c.equals("alefsym")) {
            s.append('\u2135');
        } else if (c.equals("larr")) {
            s.append('\u2190');
        } else if (c.equals("uarr")) {
            s.append('\u2191');
        } else if (c.equals("rarr")) {
            s.append('\u2192');
        } else if (c.equals("darr")) {
            s.append('\u2193');
        } else if (c.equals("harr")) {
            s.append('\u2194');
        } else if (c.equals("crarr")) {
            s.append('\u21b5');
        } else if (c.equals("lArr")) {
            s.append('\u21d0');
        } else if (c.equals("uArr")) {
            s.append('\u21d1');
        } else if (c.equals("rArr")) {
            s.append('\u21d2');
        } else if (c.equals("dArr")) {
            s.append('\u21d3');
        } else if (c.equals("hArr")) {
            s.append('\u21d4');
        } else if (c.equals("forall")) {
            s.append('\u2200');
        } else if (c.equals("part")) {
            s.append('\u2202');
        } else if (c.equals("exist")) {
            s.append('\u2203');
        } else if (c.equals("empty")) {
            s.append('\u2205');
        } else if (c.equals("nabla")) {
            s.append('\u2207');
        } else if (c.equals("isin")) {
            s.append('\u2208');
        } else if (c.equals("notin")) {
            s.append('\u2209');
        } else if (c.equals("ni")) {
            s.append('\u220b');
        } else if (c.equals("prod")) {
            s.append('\u220f');
        } else if (c.equals("sum")) {
            s.append('\u2211');
        } else if (c.equals("minus")) {
            s.append('\u2212');
        } else if (c.equals("lowast")) {
            s.append('\u2217');
        } else if (c.equals("radic")) {
            s.append('\u221a');
        } else if (c.equals("prop")) {
            s.append('\u221d');
        } else if (c.equals("infin")) {
            s.append('\u221e');
        } else if (c.equals("ang")) {
            s.append('\u2220');
        } else if (c.equals("and")) {
            s.append('\u2227');
        } else if (c.equals("or")) {
            s.append('\u2228');
        } else if (c.equals("cap")) {
            s.append('\u2229');
        } else if (c.equals("cup")) {
            s.append('\u222a');
        } else if (c.equals("int")) {
            s.append('\u222b');
        } else if (c.equals("there4")) {
            s.append('\u2234');
        } else if (c.equals("sim")) {
            s.append('\u223c');
        } else if (c.equals("cong")) {
            s.append('\u2245');
        } else if (c.equals("asymp")) {
            s.append('\u2248');
        } else if (c.equals("ne")) {
            s.append('\u2260');
        } else if (c.equals("equiv")) {
            s.append('\u2261');
        } else if (c.equals("le")) {
            s.append('\u2264');
        } else if (c.equals("ge")) {
            s.append('\u2265');
        } else if (c.equals("sub")) {
            s.append('\u2282');
        } else if (c.equals("sup")) {
            s.append('\u2283');
        } else if (c.equals("nsub")) {
            s.append('\u2284');
        } else if (c.equals("sube")) {
            s.append('\u2286');
        } else if (c.equals("supe")) {
            s.append('\u2287');
        } else if (c.equals("oplus")) {
            s.append('\u2295');
        } else if (c.equals("otimes")) {
            s.append('\u2297');
        } else if (c.equals("perp")) {
            s.append('\u22a5');
        } else if (c.equals("sdot")) {
            s.append('\u22c5');
        } else if (c.equals("lceil")) {
            s.append('\u2308');
        } else if (c.equals("rceil")) {
            s.append('\u2309');
        } else if (c.equals("lfloor")) {
            s.append('\u230a');
        } else if (c.equals("rfloor")) {
            s.append('\u230b');
        } else if (c.equals("lang")) {
            s.append('\u2329');
        } else if (c.equals("rang")) {
            s.append('\u232a');
        } else if (c.equals("loz")) {
            s.append('\u25ca');
        } else if (c.equals("spades")) {
            s.append('\u2660');
        } else if (c.equals("clubs")) {
            s.append('\u2663');
        } else if (c.equals("hearts")) {
            s.append('\u2665');
        } else if (c.equals("diams")) {
            s.append('\u2666');
        } else if (c.equals("ndash")) {
            s.append('\u2013');
        } else if (c.equals("mdash")) {
            s.append('\u2014');
        } else if (c.equals("ldquo")) {
            s.append('\u201d');
        } else if (c.equals("rdquo")) {
            s.append('\u00c9');
        } else if (this.entities.containsKey(c)) {
            s.append(this.entities.get(c));
        } else if (!this.mustBeWellFormed) {
            s.append("&" + c);
        } else {
            throw new FHIRFormatError("unable to parse character reference '" + c + "'' (last text = '" + this.lastText + "'" + this.descLoc());
        }
    }

    private boolean isInteger(String s, int base) {
        try {
            Integer.parseInt(s, base);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public XhtmlNode parseFragment(String source) throws IOException, FHIRException {
        this.rdr = new StringReader(source);
        return this.parseFragment();
    }

    public XhtmlNode parseFragment(InputStream input) throws IOException, FHIRException {
        this.rdr = new InputStreamReader(input);
        return this.parseFragment();
    }

    private XhtmlNode parseFragment() throws IOException, FHIRException {
        this.skipWhiteSpace();
        if (this.peekChar() != '<') {
            throw new FHIRException("Unable to Parse HTML - does not start with tag. Found " + this.peekChar() + this.descLoc());
        }
        this.readChar();
        if (this.peekChar() == '?') {
            this.readToTagEnd();
            this.skipWhiteSpaceInternal();
            if (this.peekChar() != '<') {
                throw new FHIRException("Unable to Parse HTML - does not start with tag after processing instruction. Found " + this.peekChar() + this.descLoc());
            }
            this.readChar();
        }
        String n = this.readName().toLowerCase();
        this.readToTagEnd();
        XhtmlNode result = new XhtmlNode(NodeType.Element);
        int colonIndex = n.indexOf(58);
        if (colonIndex != -1) {
            n = n.substring(colonIndex + 1);
        }
        result.setName(n);
        this.unwindPoint = null;
        ArrayList<XhtmlNode> p = new ArrayList<XhtmlNode>();
        this.parseElementInner(result, p, null, true);
        return result;
    }

    public static enum ParserSecurityPolicy {
        Accept,
        Drop,
        Reject;

    }

    public class QName {
        private String ns;
        private String name;

        public QName(String src) {
            if (src.contains(":")) {
                this.ns = src.substring(0, src.indexOf(":"));
                this.name = src.substring(src.indexOf(":") + 1);
            } else {
                this.ns = null;
                this.name = src;
            }
        }

        public String getName() {
            return this.name;
        }

        public boolean hasNs() {
            return this.ns != null;
        }

        public String getNs() {
            return this.ns;
        }

        public String toString() {
            return this.ns + "::" + this.name;
        }
    }

    public class NSMap {
        private Map<String, String> nslist = new HashMap<String, String>();

        public NSMap(NSMap nsm) {
            if (nsm != null) {
                this.nslist.putAll(nsm.nslist);
            }
        }

        public void def(String ns) {
            this.nslist.put("", ns);
        }

        public void ns(String abbrev, String ns) {
            this.nslist.put(abbrev, ns);
        }

        public String def() {
            return this.nslist.get("");
        }

        public boolean hasDef() {
            return this.nslist.containsKey("");
        }

        public String get(String abbrev) {
            return this.nslist.containsKey(abbrev) ? this.nslist.get(abbrev) : "http://error/undefined-namespace";
        }
    }
}

