/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.npm;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.npm.NpmPackage;

public class PackageHacker {
    private static boolean useSecureReferences = false;

    public static void main(String[] args) throws FileNotFoundException, IOException {
        new PackageHacker().edit("M:\\web\\hl7.org\\fhir\\2021Mar\\hl7.fhir.r4b.expansions.tgz");
    }

    private void edit(String name) throws FileNotFoundException, IOException {
        File f = new File(name);
        if (!f.exists()) {
            throw new Error("Unable to find " + f.getAbsolutePath());
        }
        NpmPackage pck = NpmPackage.fromPackage(new FileInputStream(f));
        System.out.println("Altering Package " + f.getAbsolutePath());
        System.out.println(this.nice(pck.getNpm()));
        this.change(pck.getNpm(), pck.getFolders().get("package").getContent());
        System.out.println("Revised Package");
        System.out.println("=======================");
        System.out.println(this.nice(pck.getNpm()));
        System.out.println("=======================");
        System.out.print("save? y/n: ");
        int r = System.in.read();
        if (r == 121) {
            f.renameTo(new File(Utilities.changeFileExt(name, ".tgz.bak")));
            pck.save(new FileOutputStream(f));
        }
    }

    private String nice(JsonObject json) {
        return new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json);
    }

    private void change(JsonObject npm, Map<String, byte[]> content) throws FileNotFoundException, IOException {
        this.fixVersions(npm);
        npm.remove("notForPublication");
    }

    private void fixVersions(JsonObject npm) {
        npm.remove("fhirVersions");
        JsonArray a = new JsonArray();
        npm.add("fhirVersions", (JsonElement)a);
        a.add("3.0.1");
    }

    private void setProperty(JsonObject npm, String name, String value) {
        npm.remove("homepage");
        npm.addProperty("homepage", "http://hl7.org/fhir");
    }

    private void fixNames(Map<String, byte[]> content) {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(content.keySet());
        for (String s : names) {
            if (!s.endsWith("json") || s.endsWith(".json")) continue;
            String n = s.substring(0, s.length() - 4) + ".json";
            content.put(n, content.get(s));
            content.remove(s);
        }
    }

    private void addContentFrom(String folder, Map<String, byte[]> content) throws FileNotFoundException, IOException {
        for (File f : new File(folder).listFiles()) {
            String cnt;
            if (!f.getName().endsWith(".json") || f.getName().endsWith(".canonical.json") || !(cnt = TextFile.fileToString(f)).contains("\"resourceType\"")) continue;
            content.put("package/" + f.getName(), TextFile.fileToBytes(f));
        }
    }

    public static String fixPackageUrl(String webref) {
        if (webref == null) {
            return null;
        }
        switch (webref) {
            case "file://C:\\GitHub\\hl7.fhir.us.breast-radiology#0.2.0\\output": {
                return "http://hl7.org/fhir/us/breast-radiology/2020May";
            }
            case "file://C:\\GitHub\\hl7.fhir.us.bser#1.0.0\\output": {
                return "http://hl7.org/fhir/us/bser/STU1";
            }
            case "file://C:\\GitHub\\hl7.fhir.us.carin-bb#0.1.0\\output": {
                return "http://hl7.org/fhir/us/carin-bb/2020Feb";
            }
            case "file://C:\\GitHub\\hl7.fhir.us.carin-rtpbc#0.1.0\\output": {
                return "http://hl7.org/fhir/us/carin-rtpbc/2020Feb";
            }
            case "file://C:\\GitHub\\hl7.fhir.us.cqfmeasures#1.1.0\\output": {
                return "http://hl7.org/fhir/us/cqfmeasures/2020Feb";
            }
            case "file://C:\\GitHub\\hl7.fhir.us.cqfmeasures#2.0.0\\output": {
                return "http://hl7.org/fhir/us/cqfmeasures/STU2";
            }
            case "file://C:\\GitHub\\hl7.fhir.us.davinci-alerts#0.2.0\\output": {
                return "http://hl7.org/fhir/us/davinci-alerts/2020Feb";
            }
            case "file://C:\\GitHub\\hl7.fhir.us.davinci-atr#0.1.0\\output": {
                return "http://hl7.org/fhir/us/davinci-atr/2020Feb";
            }
            case "file://C:\\GitHub\\hl7.fhir.us.davinci-deqm#1.1.0\\output": {
                return "http://hl7.org/fhir/us/davinci-deqm/2020Feb";
            }
            case "file://C:\\GitHub\\hl7.fhir.us.davinci-deqm#1.0.0\\output": {
                return "http://hl7.org/fhir/us/davinci-deqm/STU1";
            }
            case "file://C:\\GitHub\\hl7.fhir.us.dme-orders#0.1.1\\output": {
                return "http://hl7.org/fhir/us/dme-orders/2020May";
            }
            case "file://C:\\GitHub\\hl7.fhir.us.ecr#1.0.0\\output": {
                return "http://hl7.org/fhir/us/ecr/STU1";
            }
            case "file://C:\\GitHub\\hl7.fhir.us.mcode#1.0.0\\output": {
                return "http://hl7.org/fhir/us/mcode/STU1";
            }
            case "file://C:\\GitHub\\hl7.fhir.us.odh#1.0.0\\output": {
                return "http://hl7.org/fhir/us/odh/STU1";
            }
            case "file://C:\\GitHub\\hl7.fhir.us.qicore#4.0.0\\output": {
                return "http://hl7.org/fhir/us/qicore/STU4";
            }
            case "file://C:\\GitHub\\hl7.fhir.uv.ips#1.0.0\\output": {
                return "http://hl7.org/fhir/uv/ips/STU1";
            }
            case "file://C:\\GitHub\\hl7.fhir.uv.mhealth-framework#0.1.0\\output": {
                return "http://hl7.org/fhir/uv/mhealth-framework/2020May";
            }
            case "file://C:\\GitHub\\hl7.fhir.uv.security-label-ds4p#0.1.0\\output": {
                return "http://hl7.org/fhir/uv/security-label-ds4p/2020May";
            }
            case "file://C:\\GitHub\\hl7.fhir.uv.shorthand#0.12.0\\output": {
                return "http://hl7.org/fhir/uv/shorthand/2020May";
            }
        }
        if (PackageHacker.isUseSecureReferences()) {
            return webref.replace("http://hl7.org/fhir", "https://hl7.org/fhir").replace("http://build.fhir.org", "https://build.fhir.org");
        }
        return webref;
    }

    public static boolean isUseSecureReferences() {
        return useSecureReferences;
    }

    public static void setUseSecureReferences(boolean useSecureReferences) {
        PackageHacker.useSecureReferences = useSecureReferences;
    }
}

