/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.npm;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.JSONUtil;
import org.hl7.fhir.utilities.json.JsonTrackingParser;
import org.hl7.fhir.utilities.npm.NpmPackageIndexBuilder;
import org.hl7.fhir.utilities.npm.PackageGenerator;
import org.hl7.fhir.utilities.npm.PackageHacker;

public class NpmPackage {
    private String path;
    private JsonObject npm;
    private Map<String, NpmPackageFolder> folders = new HashMap<String, NpmPackageFolder>();
    private boolean changedByLoader;
    private Map<String, Object> userData = new HashMap<String, Object>();
    private static final int BUFFER_SIZE = 1024;

    public static boolean isValidName(String pid) {
        return pid.matches("^[a-z][a-zA-Z0-9]*(\\.[a-z][a-zA-Z0-9\\-]*)+$");
    }

    public static boolean isValidVersion(String ver) {
        return ver.matches("^[0-9]+\\.[0-9]+\\.[0-9]+$");
    }

    private NpmPackage() {
    }

    public static NpmPackage fromFolder(String path) throws IOException {
        NpmPackage res = new NpmPackage();
        res.loadFiles(path, new File(path), new String[0]);
        res.checkIndexed(path);
        return res;
    }

    public static NpmPackage empty(PackageGenerator thePackageGenerator) {
        NpmPackage retVal = new NpmPackage();
        retVal.npm = thePackageGenerator.getRootJsonObject();
        return retVal;
    }

    public Map<String, Object> getUserData() {
        return this.userData;
    }

    public void loadFiles(String path, File source, String ... exemptions) throws FileNotFoundException, IOException {
        this.npm = (JsonObject)new JsonParser().parse(TextFile.fileToString(Utilities.path(path, "package", "package.json")));
        this.path = path;
        File dir = new File(path);
        for (File f : dir.listFiles()) {
            if (NpmPackage.isInternalExemptFile(f) || Utilities.existsInList(f.getName(), exemptions)) continue;
            if (f.isDirectory()) {
                String d = f.getName();
                if (!d.equals("package")) {
                    d = Utilities.path("package", d);
                }
                NpmPackageFolder folder = new NpmPackageFolder(d);
                folder.folder = f;
                this.folders.put(d, folder);
                File ij = new File(Utilities.path(f.getAbsolutePath(), ".index.json"));
                if (ij.exists()) {
                    try {
                        if (!folder.readIndex(JsonTrackingParser.parseJson(ij))) {
                            this.indexFolder(folder.getName(), folder);
                        }
                    }
                    catch (Exception e) {
                        throw new IOException("Error parsing " + ij.getAbsolutePath() + ": " + e.getMessage(), e);
                    }
                }
                this.loadSubFolders(dir.getAbsolutePath(), f);
                continue;
            }
            NpmPackageFolder folder = new NpmPackageFolder(Utilities.path("package", "$root"));
            folder.folder = dir;
            this.folders.put(Utilities.path("package", "$root"), folder);
        }
    }

    public static boolean isInternalExemptFile(File f) {
        return Utilities.existsInList(f.getName(), ".git", ".svn") || Utilities.existsInList(f.getName(), "package-list.json");
    }

    private void loadSubFolders(String rootPath, File dir) throws IOException {
        for (File f : dir.listFiles()) {
            if (!f.isDirectory()) continue;
            String d = f.getAbsolutePath().substring(rootPath.length() + 1);
            if (!d.startsWith("package")) {
                d = Utilities.path("package", d);
            }
            NpmPackageFolder folder = new NpmPackageFolder(d);
            folder.folder = f;
            this.folders.put(d, folder);
            File ij = new File(Utilities.path(f.getAbsolutePath(), ".index.json"));
            if (ij.exists()) {
                try {
                    if (!folder.readIndex(JsonTrackingParser.parseJson(ij))) {
                        this.indexFolder(folder.getName(), folder);
                    }
                }
                catch (Exception e) {
                    throw new IOException("Error parsing " + ij.getAbsolutePath() + ": " + e.getMessage(), e);
                }
            }
            this.loadSubFolders(rootPath, f);
        }
    }

    public static NpmPackage fromFolder(String folder, PackageGenerator.PackageType defType, String ... exemptions) throws IOException {
        NpmPackage res = new NpmPackage();
        res.loadFiles(folder, new File(folder), exemptions);
        if (!res.folders.containsKey("package")) {
            Map<String, NpmPackageFolder> map = res.folders;
            NpmPackage npmPackage = res;
            Objects.requireNonNull(npmPackage);
            map.put("package", npmPackage.new NpmPackageFolder("package"));
        }
        if (!res.folders.get("package").hasFile("package.json") && defType != null) {
            TextFile.stringToFile("{ \"type\" : \"" + defType.getCode() + "\"}", Utilities.path(res.folders.get("package").folder.getAbsolutePath(), "package.json"));
        }
        res.npm = (JsonObject)new JsonParser().parse(new String(res.folders.get("package").fetchFile("package.json")));
        return res;
    }

    public static NpmPackage fromPackage(InputStream tgz) throws IOException {
        return NpmPackage.fromPackage(tgz, null, false);
    }

    public static NpmPackage fromPackage(InputStream tgz, String desc) throws IOException {
        return NpmPackage.fromPackage(tgz, desc, false);
    }

    public static NpmPackage fromPackage(InputStream tgz, String desc, boolean progress) throws IOException {
        NpmPackage res = new NpmPackage();
        res.readStream(tgz, desc, progress);
        return res;
    }

    public void readStream(InputStream tgz, String desc, boolean progress) throws IOException {
        GzipCompressorInputStream gzipIn;
        try {
            gzipIn = new GzipCompressorInputStream(tgz);
        }
        catch (Exception e) {
            throw new IOException("Error reading " + (desc == null ? "package" : desc) + ": " + e.getMessage(), e);
        }
        try (TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)gzipIn);){
            TarArchiveEntry entry;
            int i = 0;
            int c = 12;
            while ((entry = (TarArchiveEntry)tarIn.getNextEntry()) != null) {
                ++i;
                String n = entry.getName();
                if (entry.isDirectory()) {
                    String dir = n.substring(0, n.length() - 1);
                    if (dir.startsWith("package/")) {
                        dir = dir.substring(8);
                    }
                    this.folders.put(dir, new NpmPackageFolder(dir));
                } else {
                    byte[] data = new byte[1024];
                    ByteArrayOutputStream fos = new ByteArrayOutputStream();
                    try (BufferedOutputStream dest = new BufferedOutputStream(fos, 1024);){
                        int count;
                        while ((count = tarIn.read(data, 0, 1024)) != -1) {
                            dest.write(data, 0, count);
                        }
                    }
                    fos.close();
                    this.loadFile(n, fos.toByteArray());
                }
                if (!progress || i % 50 != 0) continue;
                System.out.print(".");
                if (++c != 120) continue;
                System.out.println("");
                System.out.print("  ");
                c = 2;
            }
        }
        try {
            this.npm = JsonTrackingParser.parseJson(this.folders.get("package").fetchFile("package.json"));
        }
        catch (Exception e) {
            throw new IOException("Error parsing " + (desc == null ? "" : desc + "#") + "package/package.json: " + e.getMessage(), e);
        }
        this.checkIndexed(desc);
    }

    public void loadFile(String n, byte[] data) throws IOException {
        String dir;
        String string = dir = n.contains("/") ? n.substring(0, n.lastIndexOf("/")) : "$root";
        if (dir.startsWith("package/")) {
            dir = dir.substring(8);
        }
        n = n.substring(n.lastIndexOf("/") + 1);
        NpmPackageFolder index = this.folders.get(dir);
        if (index == null) {
            index = new NpmPackageFolder(dir);
            this.folders.put(dir, index);
        }
        index.content.put(n, data);
    }

    private void checkIndexed(String desc) throws IOException {
        for (NpmPackageFolder folder : this.folders.values()) {
            if (folder.index != null) continue;
            this.indexFolder(desc, folder);
        }
    }

    public void indexFolder(String desc, NpmPackageFolder folder) throws FileNotFoundException, IOException {
        ArrayList<String> remove = new ArrayList<String>();
        NpmPackageIndexBuilder indexer = new NpmPackageIndexBuilder();
        indexer.start();
        for (String n : folder.listFiles()) {
            if (indexer.seeFile(n, folder.fetchFile(n))) continue;
            remove.add(n);
        }
        for (String n : remove) {
            folder.removeFile(n);
        }
        String json = indexer.build();
        try {
            folder.readIndex(JsonTrackingParser.parseJson(json));
            if (folder.folder != null) {
                TextFile.stringToFile(json, Utilities.path(folder.folder.getAbsolutePath(), ".index.json"));
            }
        }
        catch (Exception e) {
            TextFile.stringToFile(json, Utilities.path("[tmp]", ".index.json"));
            throw new IOException("Error parsing " + (desc == null ? "" : desc + "#") + "package/" + folder.name + "/.index.json: " + e.getMessage(), e);
        }
    }

    public static NpmPackage fromZip(InputStream stream, boolean dropRootFolder, String desc) throws IOException {
        ZipEntry ze;
        NpmPackage res = new NpmPackage();
        ZipInputStream zip = new ZipInputStream(stream);
        while ((ze = zip.getNextEntry()) != null) {
            int size;
            byte[] buffer = new byte[2048];
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(bytes, buffer.length);
            while ((size = zip.read(buffer, 0, buffer.length)) != -1) {
                bos.write(buffer, 0, size);
            }
            bos.flush();
            bos.close();
            if (bytes.size() > 0) {
                if (dropRootFolder) {
                    res.loadFile(ze.getName().substring(ze.getName().indexOf("/") + 1), bytes.toByteArray());
                } else {
                    res.loadFile(ze.getName(), bytes.toByteArray());
                }
            }
            zip.closeEntry();
        }
        zip.close();
        try {
            res.npm = JsonTrackingParser.parseJson(res.folders.get("package").fetchFile("package.json"));
        }
        catch (Exception e) {
            throw new IOException("Error parsing " + (desc == null ? "" : desc + "#") + "package/package.json: " + e.getMessage(), e);
        }
        res.checkIndexed(desc);
        return res;
    }

    public List<String> list(String folder) throws IOException {
        ArrayList<String> res = new ArrayList<String>();
        if (this.folders.containsKey(folder)) {
            res.addAll(this.folders.get(folder).listFiles());
        } else if (this.folders.containsKey(Utilities.path("package", folder))) {
            res.addAll(this.folders.get(Utilities.path("package", folder)).listFiles());
        }
        return res;
    }

    public List<String> listResources(String ... types) throws IOException {
        ArrayList<String> res = new ArrayList<String>();
        NpmPackageFolder folder = this.folders.get("package");
        for (String s : types) {
            if (!folder.types.containsKey(s)) continue;
            res.addAll((Collection)folder.types.get(s));
        }
        Collections.sort(res);
        return res;
    }

    public List<PackageResourceInformation> listIndexedResources(String ... types) throws IOException {
        ArrayList<PackageResourceInformation> res = new ArrayList<PackageResourceInformation>();
        for (NpmPackageFolder folder : this.folders.values()) {
            if (folder.index == null) continue;
            for (JsonElement e : folder.index.getAsJsonArray("files")) {
                JsonObject fi = e.getAsJsonObject();
                if (!Utilities.existsInList(JSONUtil.str(fi, "resourceType"), types)) continue;
                res.add(new PackageResourceInformation(folder.folder.getAbsolutePath(), fi));
            }
        }
        return res;
    }

    public InputStream loadResource(String file) throws IOException {
        NpmPackageFolder folder = this.folders.get("package");
        return new ByteArrayInputStream(folder.fetchFile(file));
    }

    public InputStream loadByCanonical(String canonical) throws IOException {
        return this.loadByCanonicalVersion("package", canonical, null);
    }

    public InputStream loadByCanonical(String folder, String canonical) throws IOException {
        return this.loadByCanonicalVersion(folder, canonical, null);
    }

    public InputStream loadByCanonicalVersion(String canonical, String version) throws IOException {
        return this.loadByCanonicalVersion("package", canonical, version);
    }

    public InputStream loadByCanonicalVersion(String folder, String canonical, String version) throws IOException {
        NpmPackageFolder f = this.folders.get(folder);
        ArrayList<JsonObject> matches = new ArrayList<JsonObject>();
        for (JsonElement e : f.index.getAsJsonArray("files")) {
            JsonObject file = (JsonObject)e;
            if (canonical.equals(JSONUtil.str(file, "url"))) {
                if (version != null && version.equals(JSONUtil.str(file, "version"))) {
                    return this.load("package", JSONUtil.str(file, "filename"));
                }
                if (version == null) {
                    matches.add(file);
                }
            }
            if (matches.size() <= 0) continue;
            if (matches.size() == 1) {
                return this.load("package", JSONUtil.str((JsonObject)matches.get(0), "filename"));
            }
            Collections.sort(matches, new IndexVersionSorter());
            return this.load("package", JSONUtil.str((JsonObject)matches.get(matches.size() - 1), "filename"));
        }
        return null;
    }

    public InputStream load(String file) throws IOException {
        return this.load("package", file);
    }

    public InputStream load(String folder, String file) throws IOException {
        NpmPackageFolder f = this.folders.get(folder);
        if (f == null) {
            f = this.folders.get(Utilities.path("package", folder));
        }
        if (f != null && f.hasFile(file)) {
            return new ByteArrayInputStream(f.fetchFile(file));
        }
        throw new IOException("Unable to find the file " + folder + "/" + file + " in the package " + this.name());
    }

    public boolean hasFile(String folder, String file) throws IOException {
        NpmPackageFolder f = this.folders.get(folder);
        if (f == null) {
            f = this.folders.get(Utilities.path("package", folder));
        }
        return f != null && f.hasFile(file);
    }

    public JsonObject getNpm() {
        return this.npm;
    }

    public String name() {
        return JSONUtil.str(this.npm, "name");
    }

    public String id() {
        return JSONUtil.str(this.npm, "name");
    }

    public String date() {
        return JSONUtil.str(this.npm, "date");
    }

    public String canonical() {
        return JSONUtil.str(this.npm, "canonical");
    }

    public String version() {
        return JSONUtil.str(this.npm, "version");
    }

    public String fhirVersion() {
        JsonElement e;
        if ("hl7.fhir.core".equals(JSONUtil.str(this.npm, "name"))) {
            return JSONUtil.str(this.npm, "version");
        }
        if (JSONUtil.str(this.npm, "name").startsWith("hl7.fhir.r2.") || JSONUtil.str(this.npm, "name").startsWith("hl7.fhir.r2b.") || JSONUtil.str(this.npm, "name").startsWith("hl7.fhir.r3.") || JSONUtil.str(this.npm, "name").startsWith("hl7.fhir.r4.") || JSONUtil.str(this.npm, "name").startsWith("hl7.fhir.r4b.") || JSONUtil.str(this.npm, "name").startsWith("hl7.fhir.r5.")) {
            return JSONUtil.str(this.npm, "version");
        }
        JsonObject dep = null;
        if (this.npm.has("dependencies") && this.npm.get("dependencies").isJsonObject() && (dep = this.npm.getAsJsonObject("dependencies")) != null) {
            for (Map.Entry e2 : dep.entrySet()) {
                if (Utilities.existsInList((String)e2.getKey(), "hl7.fhir.r2.core", "hl7.fhir.r2b.core", "hl7.fhir.r3.core", "hl7.fhir.r4.core")) {
                    return ((JsonElement)e2.getValue()).getAsString();
                }
                if (!Utilities.existsInList((String)e2.getKey(), "hl7.fhir.core")) continue;
                return ((JsonElement)e2.getValue()).getAsString();
            }
        }
        if (this.npm.has("fhirVersions") && (e = this.npm.get("fhirVersions")).isJsonArray() && e.getAsJsonArray().size() > 0) {
            return this.npm.getAsJsonArray("fhirVersions").get(0).getAsString();
        }
        if (dep != null) {
            if (dep.has("simplifier.core.r4")) {
                return "4.0";
            }
            if (dep.has("simplifier.core.r3")) {
                return "3.0";
            }
            if (dep.has("simplifier.core.r2")) {
                return "2.0";
            }
        }
        throw new FHIRException("no core dependency or FHIR Version found in the Package definition");
    }

    public String summary() {
        if (this.path != null) {
            return this.path;
        }
        return "memory";
    }

    public boolean isType(PackageGenerator.PackageType template) {
        return template.getCode().equals(this.type());
    }

    public String type() {
        return JSONUtil.str(this.npm, "type");
    }

    public String description() {
        return JSONUtil.str(this.npm, "description");
    }

    public String getPath() {
        return this.path;
    }

    public List<String> dependencies() {
        ArrayList<String> res = new ArrayList<String>();
        if (this.npm.has("dependencies")) {
            for (Map.Entry e : this.npm.getAsJsonObject("dependencies").entrySet()) {
                res.add((String)e.getKey() + "#" + ((JsonElement)e.getValue()).getAsString());
            }
        }
        return res;
    }

    public String homepage() {
        return JSONUtil.str(this.npm, "homepage");
    }

    public String url() {
        return JSONUtil.str(this.npm, "url");
    }

    public String title() {
        return JSONUtil.str(this.npm, "title");
    }

    public String toolsVersion() {
        return JSONUtil.str(this.npm, "tools-version");
    }

    public String license() {
        return JSONUtil.str(this.npm, "license");
    }

    public String getWebLocation() {
        if (this.npm.has("url") && this.npm.get("url").isJsonPrimitive()) {
            return PackageHacker.fixPackageUrl(this.npm.get("url").getAsString());
        }
        return JSONUtil.str(this.npm, "canonical");
    }

    public InputStream loadResource(String type, String id) throws IOException {
        NpmPackageFolder f = this.folders.get("package");
        JsonArray files = f.index.getAsJsonArray("files");
        for (JsonElement e : files) {
            JsonObject i = (JsonObject)e;
            if (!type.equals(JSONUtil.str(i, "resourceType")) || !id.equals(JSONUtil.str(i, "id"))) continue;
            return this.load("package", JSONUtil.str(i, "filename"));
        }
        return null;
    }

    public InputStream loadExampleResource(String type, String id) throws IOException {
        NpmPackageFolder f = this.folders.get("example");
        if (f != null) {
            JsonArray files = f.index.getAsJsonArray("files");
            for (JsonElement e : files) {
                JsonObject i = (JsonObject)e;
                if (!type.equals(JSONUtil.str(i, "resourceType")) || !id.equals(JSONUtil.str(i, "id"))) continue;
                return this.load("example", JSONUtil.str(i, "filename"));
            }
        }
        return null;
    }

    public Map<String, NpmPackageFolder> getFolders() {
        return this.folders;
    }

    public void save(File directory) throws IOException {
        File dir = new File(Utilities.path(directory.getAbsolutePath(), this.name()));
        if (!dir.exists()) {
            Utilities.createDirectory(dir.getAbsolutePath());
        } else {
            Utilities.clearDirectory(dir.getAbsolutePath(), new String[0]);
        }
        for (NpmPackageFolder folder : this.folders.values()) {
            String n = folder.name;
            File pd = new File(Utilities.path(dir.getAbsolutePath(), n));
            if (!pd.exists()) {
                Utilities.createDirectory(pd.getAbsolutePath());
            }
            NpmPackageIndexBuilder indexer = new NpmPackageIndexBuilder();
            indexer.start();
            for (String s : folder.content.keySet()) {
                byte[] b = (byte[])folder.content.get(s);
                indexer.seeFile(s, b);
                if (s.equals(".index.json") || s.equals("package.json")) continue;
                TextFile.bytesToFile(b, Utilities.path(dir.getAbsolutePath(), n, s));
            }
            byte[] cnt = indexer.build().getBytes(StandardCharsets.UTF_8);
            TextFile.bytesToFile(cnt, Utilities.path(dir.getAbsolutePath(), n, ".index.json"));
        }
        byte[] cnt = TextFile.stringToBytes(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)this.npm), false);
        TextFile.bytesToFile(cnt, Utilities.path(dir.getAbsolutePath(), "package", "package.json"));
    }

    public void save(OutputStream stream) throws IOException {
        ByteArrayOutputStream OutputStream2 = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(OutputStream2);
        GzipCompressorOutputStream gzipOutputStream = new GzipCompressorOutputStream((OutputStream)bufferedOutputStream);
        TarArchiveOutputStream tar = new TarArchiveOutputStream((OutputStream)gzipOutputStream);
        for (NpmPackageFolder folder : this.folders.values()) {
            String n = folder.name;
            if (!("package".equals(n) || n.startsWith("package/") || n.startsWith("package\\"))) {
                n = "package/" + n;
            }
            NpmPackageIndexBuilder indexer = new NpmPackageIndexBuilder();
            indexer.start();
            for (String s : folder.content.keySet()) {
                byte[] b = (byte[])folder.content.get(s);
                String name = n + "/" + s;
                indexer.seeFile(s, b);
                if (s.equals(".index.json") || s.equals("package.json")) continue;
                TarArchiveEntry entry = new TarArchiveEntry(name);
                entry.setSize((long)b.length);
                tar.putArchiveEntry((ArchiveEntry)entry);
                tar.write(b);
                tar.closeArchiveEntry();
            }
            byte[] cnt = indexer.build().getBytes(StandardCharsets.UTF_8);
            TarArchiveEntry entry = new TarArchiveEntry(n + "/.index.json");
            entry.setSize((long)cnt.length);
            tar.putArchiveEntry((ArchiveEntry)entry);
            tar.write(cnt);
            tar.closeArchiveEntry();
        }
        byte[] cnt = TextFile.stringToBytes(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)this.npm), false);
        TarArchiveEntry entry = new TarArchiveEntry("package/package.json");
        entry.setSize((long)cnt.length);
        tar.putArchiveEntry((ArchiveEntry)entry);
        tar.write(cnt);
        tar.closeArchiveEntry();
        tar.finish();
        tar.close();
        gzipOutputStream.close();
        bufferedOutputStream.close();
        OutputStream2.close();
        byte[] b = OutputStream2.toByteArray();
        stream.write(b);
    }

    public Map<String, List<String>> getTypes() {
        return this.folders.get("package").types;
    }

    public String fhirVersionList() {
        if (this.npm.has("fhirVersions")) {
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            if (this.npm.get("fhirVersions").isJsonArray()) {
                for (JsonElement n : this.npm.getAsJsonArray("fhirVersions")) {
                    b.append(n.getAsString());
                }
            }
            if (this.npm.get("fhirVersions").isJsonPrimitive()) {
                b.append(this.npm.get("fhirVersions").getAsString());
            }
            return b.toString();
        }
        return "";
    }

    public String dependencySummary() {
        if (this.npm.has("dependencies")) {
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            for (Map.Entry e : this.npm.getAsJsonObject("dependencies").entrySet()) {
                b.append((String)e.getKey() + "#" + ((JsonElement)e.getValue()).getAsString());
            }
            return b.toString();
        }
        return "";
    }

    public void unPack(String dir) throws IOException {
        this.unPack(dir, false);
    }

    public void unPackWithAppend(String dir) throws IOException {
        this.unPack(dir, true);
    }

    public void unPack(String dir, boolean withAppend) throws IOException {
        for (NpmPackageFolder folder : this.folders.values()) {
            String dn = folder.getName();
            if (!dn.equals("package") && (dn.startsWith("package/") || dn.startsWith("package\\"))) {
                dn = dn.substring(8);
            }
            dn = dn.equals("$root") ? dir : Utilities.path(dir, dn);
            Utilities.createDirectory(dn);
            for (String s : folder.listFiles()) {
                String fn = Utilities.path(dn, s);
                File f = new File(fn);
                if (withAppend && f.getName().startsWith("_append.")) {
                    String appendFn = Utilities.path(dn, s.substring(8));
                    if (new File(appendFn).exists()) {
                        TextFile.appendBytesToFile(folder.fetchFile(s), appendFn);
                        continue;
                    }
                    TextFile.bytesToFile(folder.fetchFile(s), appendFn);
                    continue;
                }
                TextFile.bytesToFile(folder.fetchFile(s), fn);
            }
        }
    }

    public void debugDump(String purpose) {
    }

    private List<String> sorted(Set<String> keys) {
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(keys);
        Collections.sort(res);
        return res;
    }

    public void clearFolder(String folderName) {
        NpmPackageFolder folder = this.folders.get(folderName);
        folder.content.clear();
        folder.types.clear();
    }

    public void deleteFolder(String folderName) {
        this.folders.remove(folderName);
    }

    public void addFile(String folderName, String name, byte[] cnt, String type) {
        if (!this.folders.containsKey(folderName)) {
            this.folders.put(folderName, new NpmPackageFolder(folderName));
        }
        NpmPackageFolder folder = this.folders.get(folderName);
        folder.content.put(name, cnt);
        if (!folder.types.containsKey(type)) {
            folder.types.put(type, new ArrayList());
        }
        ((List)folder.types.get(type)).add(name);
    }

    public void loadAllFiles() throws IOException {
        for (String folder : this.folders.keySet()) {
            NpmPackageFolder pf = this.folders.get(folder);
            String p = folder.contains("$") ? this.path : Utilities.path(this.path, folder);
            for (File f : new File(p).listFiles()) {
                if (f.isDirectory() || NpmPackage.isInternalExemptFile(f)) continue;
                pf.getContent().put(f.getName(), TextFile.fileToBytes(f));
            }
        }
    }

    public void loadAllFiles(ITransformingLoader loader) throws IOException {
        for (String folder : this.folders.keySet()) {
            NpmPackageFolder pf = this.folders.get(folder);
            String p = folder.contains("$") ? this.path : Utilities.path(this.path, folder);
            for (File f : new File(p).listFiles()) {
                if (f.isDirectory() || NpmPackage.isInternalExemptFile(f)) continue;
                pf.getContent().put(f.getName(), loader.load(f));
            }
        }
    }

    public boolean isChangedByLoader() {
        return this.changedByLoader;
    }

    public boolean isCore() {
        return "fhir.core".equals(JSONUtil.str(this.npm, "type"));
    }

    public boolean hasCanonical(String url) {
        if (url == null) {
            return false;
        }
        String u = url.contains("|") ? url.substring(0, url.indexOf("|")) : url;
        String v = url.contains("|") ? url.substring(url.indexOf("|") + 1) : null;
        NpmPackageFolder folder = this.folders.get("package");
        if (folder != null) {
            for (JsonElement e : folder.index.getAsJsonArray("files")) {
                JsonObject o = (JsonObject)e;
                if (!u.equals(JSONUtil.str(o, "url")) || v != null && !v.equals(JSONUtil.str(o, "version"))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canLazyLoad() throws IOException {
        for (NpmPackageFolder folder : this.folders.values()) {
            if (folder.folder != null) continue;
            return false;
        }
        if (Utilities.existsInList(this.name(), "fhir.test.data.r2", "fhir.test.data.r3", "fhir.test.data.r4", "fhir.tx.support.r2", "fhir.tx.support.r3", "fhir.tx.support.r4", "us.nlm.vsac")) {
            return true;
        }
        if (JSONUtil.bool(this.npm, "lazy-load")) {
            return true;
        }
        return this.hasFile("other", "spec.internals");
    }

    public boolean isNotForPublication() {
        return JSONUtil.bool(this.npm, "notForPublication");
    }

    public InputStream load(PackageResourceInformation p) throws FileNotFoundException {
        return new FileInputStream(p.filename);
    }

    public class NpmPackageFolder {
        private String name;
        private Map<String, List<String>> types = new HashMap<String, List<String>>();
        private Map<String, byte[]> content = new HashMap<String, byte[]>();
        private JsonObject index;
        private File folder;

        public NpmPackageFolder(String name) {
            this.name = name;
        }

        public Map<String, List<String>> getTypes() {
            return this.types;
        }

        public String getName() {
            return this.name;
        }

        public boolean readIndex(JsonObject index) {
            if (!index.has("index-version") || index.get("index-version").getAsInt() != 1) {
                return false;
            }
            this.index = index;
            for (JsonElement e : index.getAsJsonArray("files")) {
                JsonObject file = (JsonObject)e;
                String type = JSONUtil.str(file, "resourceType");
                String name = JSONUtil.str(file, "filename");
                if (!this.types.containsKey(type)) {
                    this.types.put(type, new ArrayList());
                }
                this.types.get(type).add(name);
            }
            return true;
        }

        public List<String> listFiles() {
            ArrayList<String> res = new ArrayList<String>();
            if (this.folder != null) {
                for (File f : this.folder.listFiles()) {
                    if (f.isDirectory() || Utilities.existsInList(f.getName(), "package.json", ".index.json")) continue;
                    res.add(f.getName());
                }
            } else {
                for (String s : this.content.keySet()) {
                    if (Utilities.existsInList(s, "package.json", ".index.json")) continue;
                    res.add(s);
                }
            }
            Collections.sort(res);
            return res;
        }

        public Map<String, byte[]> getContent() {
            return this.content;
        }

        public byte[] fetchFile(String file) throws FileNotFoundException, IOException {
            if (this.folder != null) {
                File f = new File(Utilities.path(this.folder.getAbsolutePath(), file));
                if (f.exists()) {
                    return TextFile.fileToBytes(f);
                }
                return null;
            }
            return this.content.get(file);
        }

        public boolean hasFile(String file) throws IOException {
            if (this.folder != null) {
                return new File(Utilities.path(this.folder.getAbsolutePath(), file)).exists();
            }
            return this.content.containsKey(file);
        }

        public String dump() {
            return this.name + " (" + (this.folder == null ? "null" : this.folder.toString()) + ") | " + Boolean.toString(this.index != null) + " | " + this.content.size() + " | " + this.types.size();
        }

        public void removeFile(String n) throws IOException {
            if (this.folder != null) {
                new File(Utilities.path(this.folder.getAbsolutePath(), n)).delete();
            } else {
                this.content.remove(n);
            }
            NpmPackage.this.changedByLoader = true;
        }
    }

    public class IndexVersionSorter
    implements Comparator<JsonObject> {
        @Override
        public int compare(JsonObject o0, JsonObject o1) {
            String v0 = JSONUtil.str(o0, "version");
            String v1 = JSONUtil.str(o1, "version");
            return v0.compareTo(v1);
        }
    }

    public class PackageResourceInformation {
        private String id;
        private String type;
        private String url;
        private String version;
        private String filename;
        private String supplements;

        public PackageResourceInformation(String root, JsonObject fi) throws IOException {
            this.id = JSONUtil.str(fi, "id");
            this.type = JSONUtil.str(fi, "resourceType");
            this.url = JSONUtil.str(fi, "url");
            this.version = JSONUtil.str(fi, "version");
            this.filename = Utilities.path(root, JSONUtil.str(fi, "filename"));
            this.supplements = JSONUtil.str(fi, "supplements");
        }

        public String getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public String getUrl() {
            return this.url;
        }

        public String getVersion() {
            return this.version;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getSupplements() {
            return this.supplements;
        }
    }

    public class PackageResourceInformationSorter
    implements Comparator<PackageResourceInformation> {
        @Override
        public int compare(PackageResourceInformation o1, PackageResourceInformation o2) {
            return o1.filename.compareTo(o2.filename);
        }
    }

    public static interface ITransformingLoader {
        public byte[] load(File var1);
    }
}

