/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.npm;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.SimpleHTTPClient;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.json.JSONUtil;
import org.hl7.fhir.utilities.json.JsonTrackingParser;
import org.hl7.fhir.utilities.npm.PackageInfo;

public class PackageClient {
    private String address;
    private String cacheFolder;

    public PackageClient(String address) {
        this.address = address;
        try {
            this.cacheFolder = Utilities.path(System.getProperty("user.home"), ".fhir", "package-client");
            Utilities.createDirectory(this.cacheFolder);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean exists(String id, String ver) throws IOException {
        List<PackageInfo> vl = this.getVersions(id);
        for (PackageInfo pi : vl) {
            if (ver != null && !ver.equals(pi.getVersion())) continue;
            return true;
        }
        return false;
    }

    public InputStream fetch(String id, String ver) throws IOException {
        return this.fetchCached(Utilities.pathURL(this.address, id, ver));
    }

    public InputStream fetch(PackageInfo info) throws IOException {
        return this.fetchCached(Utilities.pathURL(this.address, info.getId(), info.getVersion()));
    }

    public InputStream fetchNpm(String id, String ver) throws IOException {
        return this.fetchCached(Utilities.pathURL(this.address, id, "-", id + "-" + ver + ".tgz"));
    }

    public InputStream fetchCached(String url) throws IOException, FileNotFoundException {
        return this.fetchUrl(url, null);
    }

    protected String fn(String url) {
        String[] p = url.split("\\/");
        return p[2] + "-" + p[p.length - 2] + "-" + p[p.length - 1] + ".tgz";
    }

    public List<PackageInfo> getVersions(String id) throws IOException {
        ArrayList<PackageInfo> res = new ArrayList<PackageInfo>();
        try {
            JsonObject json = this.fetchJson(Utilities.pathURL(this.address, id));
            JsonObject versions = json.getAsJsonObject("versions");
            if (versions != null) {
                for (String v : this.sorted(versions.keySet())) {
                    JsonObject obj = versions.getAsJsonObject(v);
                    res.add(new PackageInfo(JSONUtil.str(obj, "name"), JSONUtil.str(obj, "version"), JSONUtil.str(obj, "FhirVersion"), JSONUtil.str(obj, "description"), JSONUtil.str(obj, "url"), JSONUtil.str(obj, "canonical"), this.address));
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return res;
    }

    private List<String> sorted(Set<String> keys) {
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(keys);
        Collections.sort(res);
        return res;
    }

    public List<PackageInfo> search(String name, String canonical, String fhirVersion, boolean preRelease) throws IOException {
        CommaSeparatedStringBuilder params = new CommaSeparatedStringBuilder("&");
        if (!Utilities.noString(name)) {
            params.append("name=" + name);
        }
        if (!Utilities.noString(canonical)) {
            params.append("canonical=" + canonical);
        }
        if (!Utilities.noString(fhirVersion)) {
            params.append("fhirversion=" + fhirVersion);
        }
        if (preRelease) {
            params.append("prerelease=" + preRelease);
        }
        ArrayList<PackageInfo> res = new ArrayList<PackageInfo>();
        try {
            JsonArray json = this.fetchJsonArray(Utilities.pathURL(this.address, "catalog?") + params.toString());
            for (JsonElement e : json) {
                JsonObject obj = (JsonObject)e;
                res.add(new PackageInfo(JSONUtil.str(obj, "Name", "name"), JSONUtil.str(obj, "Version", "version"), JSONUtil.str(obj, "FhirVersion", "fhirVersion"), JSONUtil.str(obj, "Description", "description"), JSONUtil.str(obj, "url"), JSONUtil.str(obj, "canonical"), this.address));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res;
    }

    public Date getNewPackages(Date lastCalled, List<PackageInfo> updates) {
        return null;
    }

    private InputStream fetchUrl(String source, String accept) throws IOException {
        SimpleHTTPClient http = new SimpleHTTPClient();
        SimpleHTTPClient.HTTPResult res = http.get(source, accept);
        res.checkThrowException();
        return new ByteArrayInputStream(res.getContent());
    }

    private JsonObject fetchJson(String source) throws IOException {
        String src = TextFile.streamToString(this.fetchUrl(source, "application/json"));
        return (JsonObject)new JsonParser().parse(src);
    }

    private JsonArray fetchJsonArray(String source) throws IOException {
        String src = TextFile.streamToString(this.fetchUrl(source, "application/json"));
        return (JsonArray)new JsonParser().parse(src);
    }

    public String url(String id, String v) {
        return Utilities.pathURL(this.address, id, v);
    }

    public String getLatestVersion(String id) throws IOException {
        List<PackageInfo> list = this.getVersions(id);
        if (list.isEmpty()) {
            throw new IOException("Package not found: " + id);
        }
        String v = list.get(0).getVersion();
        for (PackageInfo p : list) {
            if (!VersionUtilities.isThisOrLater(v, p.getVersion())) continue;
            v = p.getVersion();
        }
        return v;
    }

    public String getLatestVersion(String id, String majMinVersion) throws IOException {
        List<PackageInfo> list = this.getVersions(id);
        if (list.isEmpty()) {
            throw new IOException("Package not found: " + id);
        }
        String v = majMinVersion;
        for (PackageInfo p : list) {
            if (!VersionUtilities.isMajMinOrLaterPatch(v, p.getVersion())) continue;
            v = p.getVersion();
        }
        return v;
    }

    public List<PackageInfo> listFromRegistry(String name, String canonical, String fhirVersion) throws IOException {
        ArrayList<PackageInfo> result = new ArrayList<PackageInfo>();
        JsonObject packages = JsonTrackingParser.fetchJson("https://raw.githubusercontent.com/FHIR/ig-registry/master/fhir-ig-list.json?nocache=" + System.currentTimeMillis());
        for (JsonObject o : JSONUtil.objects(packages, "guides")) {
            if (!o.has("canonical")) continue;
            String id = JSONUtil.str(o, "npm-name");
            String pname = JSONUtil.str(o, "name");
            String pcanonical = JSONUtil.str(o, "canonical");
            String description = JSONUtil.str(o, "description");
            boolean ok = true;
            if (ok && !Utilities.noString(name)) {
                boolean bl = ok = pname != null && pname.contains(name) || description != null && description.contains(name) || id != null && id.contains(name);
            }
            if (ok && !Utilities.noString(canonical)) {
                ok = pcanonical.contains(canonical);
            }
            String version = null;
            String fVersion = null;
            String url = null;
            if (ok) {
                for (JsonObject e : JSONUtil.objects(o, "editions")) {
                    if (fhirVersion != null && !fhirVersion.equals(JSONUtil.str(e, "fhir-version"))) continue;
                    String v = JSONUtil.str(e, "ig-version");
                    if (version != null && !VersionUtilities.isThisOrLater(version, v)) continue;
                    version = v;
                    fVersion = e.getAsJsonArray("fhir-version").get(0).getAsString();
                    url = JSONUtil.str(e, "url");
                }
            }
            if (version == null) continue;
            result.add(new PackageInfo(id, version, fVersion, description, url, pcanonical, this.address));
        }
        return result;
    }
}

