/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.hl7.fhir.utilities.CSFile;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.ToolGlobalSettings;
import org.hl7.fhir.utilities.Utilities;

public class BaseTestingUtilities {
    public static boolean silent;

    public static String loadTestResource(String ... paths) throws IOException {
        String contents;
        String dir = System.getenv("FHIR-TEST-CASES");
        if (dir == null && ToolGlobalSettings.hasTestsPath()) {
            dir = ToolGlobalSettings.getTestsPath();
        }
        if (dir != null && new CSFile(dir).exists()) {
            String n = Utilities.path(dir, Utilities.path(paths));
            return TextFile.fileToString(new CSFile(n));
        }
        String classpath = "/org/hl7/fhir/testcases/" + Utilities.pathURL(paths);
        try (InputStream inputStream = BaseTestingUtilities.class.getResourceAsStream(classpath);){
            if (inputStream == null) {
                throw new IOException("Can't find file on classpath: " + classpath);
            }
            contents = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        }
        return contents;
    }

    public static InputStream loadTestResourceStream(String ... paths) throws IOException {
        String dir = System.getenv("FHIR-TEST-CASES");
        if (dir == null && ToolGlobalSettings.hasTestsPath()) {
            dir = ToolGlobalSettings.getTestsPath();
        }
        if (dir != null && new File(dir).exists()) {
            String n = Utilities.path(dir, Utilities.path(paths));
            return new FileInputStream(n);
        }
        String classpath = "/org/hl7/fhir/testcases/" + Utilities.pathURL(paths);
        InputStream s = BaseTestingUtilities.class.getResourceAsStream(classpath);
        if (s == null) {
            throw new Error("unable to find resource " + classpath);
        }
        return s;
    }

    public static byte[] loadTestResourceBytes(String ... paths) throws IOException {
        String dir = System.getenv("FHIR-TEST-CASES");
        if (dir == null && ToolGlobalSettings.hasTestsPath()) {
            dir = ToolGlobalSettings.getTestsPath();
        }
        if (dir != null && new File(dir).exists()) {
            String n = Utilities.path(dir, Utilities.path(paths));
            return TextFile.fileToBytes(n);
        }
        String classpath = "/org/hl7/fhir/testcases/" + Utilities.pathURL(paths);
        InputStream s = BaseTestingUtilities.class.getResourceAsStream(classpath);
        if (s == null) {
            throw new Error("unable to find resource " + classpath);
        }
        return TextFile.streamToBytes(s);
    }

    public static boolean findTestResource(String ... paths) throws IOException {
        String dir = System.getenv("FHIR-TEST-CASES");
        if (dir == null && ToolGlobalSettings.hasTestsPath()) {
            dir = ToolGlobalSettings.getTestsPath();
        }
        if (dir != null && new File(dir).exists()) {
            String n = Utilities.path(dir, Utilities.path(paths));
            return new File(n).exists();
        }
        String classpath = "/org/hl7/fhir/testcases/" + Utilities.pathURL(paths);
        try {
            InputStream inputStream = BaseTestingUtilities.class.getResourceAsStream(classpath);
            return inputStream != null;
        }
        catch (Throwable t) {
            return false;
        }
    }
}

