/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.util.List;
import org.hl7.fhir.utilities.Utilities;

public class CommaSeparatedStringBuilder {
    boolean first = true;
    String sep = ", ";
    StringBuilder b = new StringBuilder();
    int count = 0;
    String pending = null;
    private String lastSep;

    public CommaSeparatedStringBuilder() {
        this.sep = ", ";
        this.lastSep = ", ";
    }

    public CommaSeparatedStringBuilder(String sep) {
        this.sep = sep;
        this.lastSep = sep;
    }

    public CommaSeparatedStringBuilder(String sep, String lastSep) {
        this.sep = sep;
        this.lastSep = lastSep;
    }

    private void commit(boolean last) {
        if (this.pending != null) {
            if (!this.first) {
                if (last) {
                    this.b.append(this.lastSep);
                } else {
                    this.b.append(this.sep);
                }
            }
            this.b.append(this.pending);
            this.first = false;
        }
    }

    public void append(String value) {
        this.commit(false);
        this.pending = value;
        ++this.count;
    }

    public int length() {
        this.commit(false);
        return this.b.length();
    }

    public int count() {
        return this.count;
    }

    public String toString() {
        this.commit(true);
        return this.b.toString();
    }

    public void appendIfNotNull(String s) {
        if (!Utilities.noString(s)) {
            this.append(s);
        }
    }

    public void addAll(List<String> list) {
        for (String s : list) {
            this.appendIfNotNull(s);
        }
    }

    public static String join(String sep, List<String> list) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(sep);
        for (String s : list) {
            b.append(s);
        }
        return b.toString();
    }
}

