/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.validation;

import java.util.HashSet;
import java.util.Set;
import org.hl7.fhir.utilities.Utilities;

public class ValidationOptions {
    private Set<String> languages = new HashSet<String>();
    private boolean useServer = true;
    private boolean useClient = true;
    private boolean guessSystem = false;
    private ValueSetMode valueSetMode = ValueSetMode.ALL_CHECKS;
    private boolean displayWarningMode = false;
    private boolean vsAsUrl;
    private boolean versionFlexible = true;
    private boolean useValueSetDisplays;
    private boolean englishOk = true;

    public ValidationOptions(String ... languages) {
        for (String s : languages) {
            this.languages.add(s);
        }
    }

    public static ValidationOptions defaults() {
        return new ValidationOptions("en", "en-US");
    }

    public Set<String> getLanguages() {
        return this.languages;
    }

    public boolean hasLanguages() {
        return this.languages.size() > 0;
    }

    public boolean isUseServer() {
        return this.useServer;
    }

    public boolean isUseClient() {
        return this.useClient;
    }

    public boolean isGuessSystem() {
        return this.guessSystem;
    }

    public ValueSetMode getValueSetMode() {
        return this.valueSetMode;
    }

    public boolean getVsAsUrl() {
        return this.vsAsUrl;
    }

    public boolean isVersionFlexible() {
        return this.versionFlexible;
    }

    public boolean isUseValueSetDisplays() {
        return this.useValueSetDisplays;
    }

    public boolean isEnglishOk() {
        return this.englishOk;
    }

    public ValidationOptions withLanguage(String language) {
        if (language == null) {
            return this;
        }
        ValidationOptions n = this.copy();
        n.languages.add(language);
        return n;
    }

    public ValidationOptions withNoServer() {
        ValidationOptions n = this.copy();
        n.useServer = false;
        return n;
    }

    public ValidationOptions withNoClient() {
        ValidationOptions n = this.copy();
        n.useClient = false;
        return n;
    }

    public ValidationOptions withGuessSystem() {
        ValidationOptions n = this.copy();
        n.guessSystem = true;
        return n;
    }

    public ValidationOptions withCheckValueSetOnly() {
        ValidationOptions n = this.copy();
        n.valueSetMode = ValueSetMode.CHECK_MEMERSHIP_ONLY;
        return n;
    }

    public ValidationOptions withNoCheckValueSetMembership() {
        ValidationOptions n = this.copy();
        n.valueSetMode = ValueSetMode.NO_MEMBERSHIP_CHECK;
        return n;
    }

    public ValidationOptions withVsAsUrl() {
        ValidationOptions n = this.copy();
        n.vsAsUrl = true;
        return n;
    }

    public ValidationOptions withVersionFlexible(boolean value) {
        ValidationOptions n = this.copy();
        n.versionFlexible = value;
        return n;
    }

    public ValidationOptions withUseValueSetDisplays(boolean useValueSetDisplays) {
        ValidationOptions n = this.copy();
        n.useValueSetDisplays = useValueSetDisplays;
        return n;
    }

    public ValidationOptions withEnglishOk(boolean englishOk) {
        ValidationOptions n = this.copy();
        n.englishOk = englishOk;
        return n;
    }

    public ValidationOptions addLanguage(String language) {
        this.languages.add(language);
        return this;
    }

    public ValidationOptions setNoServer(boolean useServer) {
        this.useServer = useServer;
        return this;
    }

    public ValidationOptions setNoClient(boolean useClient) {
        this.useClient = useClient;
        return this;
    }

    public ValidationOptions setGuessSystem(boolean guessSystem) {
        this.guessSystem = guessSystem;
        return this;
    }

    public ValidationOptions setCheckValueSetOnly() {
        this.valueSetMode = ValueSetMode.CHECK_MEMERSHIP_ONLY;
        return this;
    }

    public ValidationOptions setNoCheckValueSetMembership() {
        this.valueSetMode = ValueSetMode.NO_MEMBERSHIP_CHECK;
        return this;
    }

    public ValidationOptions setVsAsUrl(boolean value) {
        this.vsAsUrl = value;
        return this;
    }

    public ValidationOptions setVersionFlexible(boolean value) {
        this.versionFlexible = value;
        return this;
    }

    public ValidationOptions setUseValueSetDisplays(boolean useValueSetDisplays) {
        this.useValueSetDisplays = useValueSetDisplays;
        return this;
    }

    public ValidationOptions setEnglishOk(boolean englishOk) {
        this.englishOk = englishOk;
        return this;
    }

    public boolean isDisplayWarningMode() {
        return this.displayWarningMode;
    }

    public ValidationOptions setDisplayWarningMode(boolean displayWarningMode) {
        this.displayWarningMode = displayWarningMode;
        return this;
    }

    public ValidationOptions copy() {
        ValidationOptions n = new ValidationOptions(new String[0]);
        n.languages.addAll(this.languages);
        n.useServer = this.useServer;
        n.useClient = this.useClient;
        n.guessSystem = this.guessSystem;
        n.vsAsUrl = this.vsAsUrl;
        n.versionFlexible = this.versionFlexible;
        n.valueSetMode = this.valueSetMode;
        n.useValueSetDisplays = this.useValueSetDisplays;
        n.displayWarningMode = this.displayWarningMode;
        return n;
    }

    public String toJson() {
        return "\"langs\":\"" + this.languages.toString() + "\", \"useServer\":\"" + Boolean.toString(this.useServer) + "\", \"useClient\":\"" + Boolean.toString(this.useClient) + "\", \"guessSystem\":\"" + Boolean.toString(this.guessSystem) + "\", \"valueSetMode\":\"" + this.valueSetMode.toString() + "\", \"displayWarningMode\":\"" + Boolean.toString(this.displayWarningMode) + "\", \"versionFlexible\":\"" + Boolean.toString(this.versionFlexible) + "\"";
    }

    public String langSummary() {
        if (this.languages.size() == 0) {
            return "--";
        }
        return String.join((CharSequence)"|", Utilities.sorted(this.languages));
    }

    public static enum ValueSetMode {
        ALL_CHECKS,
        CHECK_MEMERSHIP_ONLY,
        NO_MEMBERSHIP_CHECK;

    }
}

