/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.npm;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.IniFile;
import org.hl7.fhir.utilities.SimpleHTTPClient;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.parser.JsonParser;
import org.hl7.fhir.utilities.npm.BasePackageCacheManager;
import org.hl7.fhir.utilities.npm.IPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.npm.PackageClient;
import org.hl7.fhir.utilities.npm.PackageInfo;
import org.hl7.fhir.utilities.npm.PackageList;
import org.hl7.fhir.utilities.npm.PackageServer;
import org.hl7.fhir.utilities.settings.FhirSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemPackageCacheManager
extends BasePackageCacheManager
implements IPackageCacheManager {
    private static IPackageProvider packageProvider;
    public static final String PACKAGE_REGEX = "^[a-zA-Z][A-Za-z0-9\\_\\-]*(\\.[A-Za-z0-9\\_\\-]+)+$";
    public static final String PACKAGE_VERSION_REGEX = "^[A-Za-z][A-Za-z0-9\\_\\-]*(\\.[A-Za-z0-9\\_\\-]+)+\\#[A-Za-z0-9\\-\\_\\$]+(\\.[A-Za-z0-9\\-\\_\\$]+)*$";
    public static final String PACKAGE_VERSION_REGEX_OPT = "^[A-Za-z][A-Za-z0-9\\_\\-]*(\\.[A-Za-z0-9\\_\\-]+)+(\\#[A-Za-z0-9\\-\\_]+(\\.[A-Za-z0-9\\-\\_]+)*)?$";
    private static final Logger ourLog;
    private static final String CACHE_VERSION = "3";
    private File cacheFolder;
    private boolean progress = true;
    private List<NpmPackage> temporaryPackages = new ArrayList<NpmPackage>();
    private boolean buildLoaded = false;
    private Map<String, String> ciList = new HashMap<String, String>();
    private JsonArray buildInfo;
    private boolean suppressErrors;
    private boolean minimalMemory;

    public FilesystemPackageCacheManager(boolean userMode) throws IOException {
        this.init(userMode ? FilesystemPackageCacheMode.USER : FilesystemPackageCacheMode.SYSTEM);
    }

    public FilesystemPackageCacheManager(FilesystemPackageCacheMode mode) throws IOException {
        this.init(mode);
    }

    public FilesystemPackageCacheManager(String customFolder) throws IOException {
        this.cacheFolder = new File(customFolder);
        this.init(FilesystemPackageCacheMode.CUSTOM);
    }

    protected void init(FilesystemPackageCacheMode mode) throws IOException {
        this.initPackageServers();
        switch (mode) {
            case SYSTEM: {
                this.cacheFolder = new File(Utilities.path("var", "lib", ".fhir", "packages"));
                break;
            }
            case USER: {
                this.cacheFolder = new File(Utilities.path(System.getProperty("user.home"), ".fhir", "packages"));
                break;
            }
            case TESTING: {
                this.cacheFolder = new File(Utilities.path("[tmp]", ".fhir", "packages"));
                break;
            }
            case CUSTOM: {
                if (this.cacheFolder.exists()) break;
                throw new FHIRException("The folder ''" + this.cacheFolder + "' could not be found");
            }
        }
        if (!this.cacheFolder.exists()) {
            Utilities.createDirectory(this.cacheFolder.getAbsolutePath());
        }
        if (!new File(Utilities.path(this.cacheFolder, "packages.ini")).exists()) {
            TextFile.stringToFile("[cache]\r\nversion=3\r\n\r\n[urls]\r\n\r\n[local]\r\n\r\n", Utilities.path(this.cacheFolder, "packages.ini"), false);
        }
        this.createIniFile();
        for (File f : this.cacheFolder.listFiles()) {
            if (!f.isDirectory() || !Utilities.isValidUUID(f.getName())) continue;
            Utilities.clearDirectory(f.getAbsolutePath(), new String[0]);
            f.delete();
        }
    }

    private void initPackageServers() {
        this.myPackageServers.addAll(this.getConfiguredServers());
        if (!this.isIgnoreDefaultPackageServers()) {
            this.myPackageServers.addAll(this.getDefaultServers());
        }
    }

    protected boolean isIgnoreDefaultPackageServers() {
        return FhirSettings.isIgnoreDefaultPackageServers();
    }

    @Nonnull
    protected List<PackageServer> getDefaultServers() {
        return PackageServer.defaultServers();
    }

    protected List<PackageServer> getConfiguredServers() {
        return PackageServer.getConfiguredServers();
    }

    public boolean isMinimalMemory() {
        return this.minimalMemory;
    }

    public void setMinimalMemory(boolean minimalMemory) {
        this.minimalMemory = minimalMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromFolder(String packagesFolder) throws IOException {
        assert (!this.minimalMemory);
        File[] files = new File(packagesFolder).listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.getName().endsWith(".tgz")) continue;
                try (FileInputStream fs = new FileInputStream(f);){
                    this.temporaryPackages.add(NpmPackage.fromPackage(fs));
                }
            }
        }
    }

    public String getFolder() {
        return this.cacheFolder.getAbsolutePath();
    }

    private NpmPackage loadPackageInfo(String path) throws IOException {
        NpmPackage pi = this.minimalMemory ? NpmPackage.fromFolderMinimal(path) : NpmPackage.fromFolder(path);
        return pi;
    }

    private void clearCache() throws IOException {
        for (File f : this.cacheFolder.listFiles()) {
            if (f.isDirectory()) {
                new CacheLock(f.getName()).doWithLock(() -> {
                    Utilities.clearDirectory(f.getAbsolutePath(), new String[0]);
                    try {
                        FileUtils.deleteDirectory((File)f);
                    }
                    catch (Exception e1) {
                        try {
                            FileUtils.deleteDirectory((File)f);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return null;
                });
                continue;
            }
            if (f.getName().equals("packages.ini")) continue;
            FileUtils.forceDelete((File)f);
        }
        IniFile ini = new IniFile(Utilities.path(this.cacheFolder, "packages.ini"));
        ini.removeSection("packages");
        ini.save();
    }

    private void createIniFile() throws IOException {
        IniFile ini = new IniFile(Utilities.path(this.cacheFolder, "packages.ini"));
        boolean save = false;
        String v = ini.getStringProperty("cache", "version");
        if (!CACHE_VERSION.equals(v)) {
            this.clearCache();
            ini.setStringProperty("cache", "version", CACHE_VERSION, null);
            ini.save();
        }
    }

    private void checkValidVersionString(String version, String id) {
        if (Utilities.noString(version)) {
            throw new FHIRException("Cannot add package " + id + " to the package cache - a version must be provided");
        }
        if (version.startsWith("file:")) {
            throw new FHIRException("Cannot add package " + id + " to the package cache - the version '" + version + "' is illegal in this context");
        }
        for (char ch : version.toCharArray()) {
            if (Character.isAlphabetic(ch) || Character.isDigit(ch) || Utilities.existsInList(ch, 46, 45, 36)) continue;
            throw new FHIRException("Cannot add package " + id + " to the package cache - the version '" + version + "' is illegal (ch '" + ch + "'");
        }
    }

    private void listSpecs(Map<String, String> specList, PackageServer server) throws IOException {
        PackageClient pc = new PackageClient(server);
        List<PackageInfo> matches = pc.search(null, null, null, false);
        for (PackageInfo m : matches) {
            if (specList.containsKey(m.getId())) continue;
            specList.put(m.getId(), m.getUrl());
        }
    }

    @Override
    protected BasePackageCacheManager.InputStreamWithSrc loadFromPackageServer(String id, String version) {
        BasePackageCacheManager.InputStreamWithSrc retVal = super.loadFromPackageServer(id, version);
        if (retVal != null) {
            return retVal;
        }
        retVal = super.loadFromPackageServer(id, VersionUtilities.getMajMin(version) + ".x");
        if (retVal != null) {
            return retVal;
        }
        return this.fetchTheOldWay(id, version);
    }

    public String getLatestVersion(String id) throws IOException {
        for (PackageServer nextPackageServer : this.getPackageServers()) {
            if (Utilities.existsInList(id, "hl7.fhir.pubpack", "hl7.terminology.r5") && "http://packages.fhir.org".equals(nextPackageServer.getUrl())) continue;
            PackageClient pc = new PackageClient(nextPackageServer);
            try {
                return pc.getLatestVersion(id);
            }
            catch (IOException e) {
                ourLog.info("Failed to determine latest version of package {} from server: {}", (Object)id, (Object)nextPackageServer.toString());
            }
        }
        try {
            return this.fetchVersionTheOldWay(id);
        }
        catch (Exception e) {
            ourLog.info("Failed to determine latest version of package {} from server: {}", (Object)id, (Object)"build.fhir.org");
            String version = this.getLatestVersionFromCache(id);
            if (version != null) {
                return version;
            }
            throw new FHIRException("Unable to find the last version for package " + id + ": no local copy, and no network access");
        }
    }

    public String getLatestVersionFromCache(String id) throws IOException {
        for (String f : Utilities.reverseSorted(this.cacheFolder.list())) {
            File cf = new File(Utilities.path(this.cacheFolder, f));
            if (!cf.isDirectory() || !f.startsWith(id + "#")) continue;
            String ver = f.substring(f.indexOf("#") + 1);
            ourLog.info("Latest version of package {} found locally is {} - using that", (Object)id, (Object)ver);
            return ver;
        }
        return null;
    }

    private NpmPackage loadPackageFromFile(String id, String folder) throws IOException {
        File f = new File(Utilities.path(folder, id));
        if (!f.exists()) {
            throw new FHIRException("Package '" + id + "  not found in folder " + folder);
        }
        if (!f.isDirectory()) {
            throw new FHIRException("File for '" + id + "  found in folder " + folder + ", not a folder");
        }
        File fp = new File(Utilities.path(folder, id, "package", "package.json"));
        if (!fp.exists()) {
            throw new FHIRException("Package '" + id + "  found in folder " + folder + ", but does not contain a package.json file in /package");
        }
        return NpmPackage.fromFolder(f.getAbsolutePath());
    }

    public void clear() throws IOException {
        this.clearCache();
    }

    public void removePackage(String id, String ver) throws IOException {
        new CacheLock(id + "#" + ver).doWithLock(() -> {
            String f = Utilities.path(this.cacheFolder, id + "#" + ver);
            File ff = new File(f);
            if (ff.exists()) {
                Utilities.clearDirectory(f, new String[0]);
                IniFile ini = new IniFile(Utilities.path(this.cacheFolder, "packages.ini"));
                ini.removeProperty("packages", id + "#" + ver);
                ini.save();
                ff.delete();
            }
            return null;
        });
    }

    @Override
    public NpmPackage loadPackageFromCacheOnly(String id, String version) throws IOException {
        if (!Utilities.noString(version) && version.startsWith("file:")) {
            return this.loadPackageFromFile(id, version.substring(5));
        }
        for (NpmPackage p : this.temporaryPackages) {
            if (p.name().equals(id) && ("current".equals(version) || "dev".equals(version) || p.version().equals(version))) {
                return p;
            }
            if (!p.name().equals(id) || !Utilities.noString(version)) continue;
            return p;
        }
        String foundPackage = null;
        String foundVersion = null;
        for (String f : Utilities.reverseSorted(this.cacheFolder.list())) {
            String[] parts;
            File cf = new File(Utilities.path(this.cacheFolder, f));
            if (!cf.isDirectory()) continue;
            if (f.equals(id + "#" + version) || Utilities.noString(version) && f.startsWith(id + "#")) {
                return this.loadPackageInfo(Utilities.path(this.cacheFolder, f));
            }
            if (version == null || version.equals("current") || !version.endsWith(".x") && Utilities.charCount(version, '.') >= 2 || !f.contains("#") || !(parts = f.split("#"))[0].equals(id) || !VersionUtilities.isMajMinOrLaterPatch(foundVersion != null ? foundVersion : version, parts[1])) continue;
            foundVersion = parts[1];
            foundPackage = f;
        }
        if (foundPackage != null) {
            return this.loadPackageInfo(Utilities.path(this.cacheFolder, foundPackage));
        }
        if ("dev".equals(version)) {
            return this.loadPackageFromCacheOnly(id, "current");
        }
        return null;
    }

    @Override
    public NpmPackage addPackageToCache(String id, String version, InputStream packageTgzInputStream, String sourceDesc) throws IOException {
        this.checkValidVersionString(version, id);
        String uuid = UUID.randomUUID().toString().toLowerCase();
        String tempDir = Utilities.path(this.cacheFolder, uuid);
        NpmPackage npm = NpmPackage.extractFromTgz(packageTgzInputStream, sourceDesc, tempDir, this.minimalMemory);
        if (this.progress) {
            this.log("");
            this.logn("Installing " + id + "#" + version);
        }
        if (!(npm.name() == null || id == null || id.equalsIgnoreCase(npm.name()) || this.suppressErrors || id.equals("hl7.fhir.r5.core") || id.equals("hl7.fhir.us.immds"))) {
            throw new IOException("Attempt to import a mis-identified package. Expected " + id + ", got " + npm.name());
        }
        if (version == null) {
            version = npm.version();
        }
        String v = version;
        return new CacheLock(id + "#" + version).doWithLock(() -> {
            NpmPackage pck = null;
            String packRoot = Utilities.path(this.cacheFolder, id + "#" + v);
            try {
                if (!new File(packRoot).exists() || Utilities.existsInList(v, "current", "dev")) {
                    Utilities.createDirectory(packRoot);
                    try {
                        Utilities.clearDirectory(packRoot, new String[0]);
                    }
                    catch (Throwable t) {
                        this.log("Unable to clear directory: " + packRoot + ": " + t.getMessage() + " - this may cause problems later");
                    }
                    Utilities.renameDirectory(tempDir, packRoot);
                    IniFile ini = new IniFile(Utilities.path(this.cacheFolder, "packages.ini"));
                    ini.setTimeStampFormat("yyyyMMddhhmmss");
                    ini.setTimestampProperty("packages", id + "#" + v, Timestamp.from(Instant.now()), null);
                    ini.setIntegerProperty("package-sizes", id + "#" + v, npm.getSize(), null);
                    ini.save();
                    if (this.progress) {
                        this.log(" done.");
                    }
                } else {
                    Utilities.clearDirectory(tempDir, new String[0]);
                    new File(tempDir).delete();
                }
                if (!id.equals(npm.getNpm().asString("name")) || !v.equals(npm.getNpm().asString("version"))) {
                    if (!id.equals(npm.getNpm().asString("name"))) {
                        npm.getNpm().add("original-name", npm.getNpm().asString("name"));
                        npm.getNpm().remove("name");
                        npm.getNpm().add("name", id);
                    }
                    if (!v.equals(npm.getNpm().asString("version"))) {
                        npm.getNpm().add("original-version", npm.getNpm().asString("version"));
                        npm.getNpm().remove("version");
                        npm.getNpm().add("version", v);
                    }
                    TextFile.stringToFile(JsonParser.compose((JsonElement)npm.getNpm(), true), Utilities.path(this.cacheFolder, id + "#" + v, "package", "package.json"), false);
                }
                pck = this.loadPackageInfo(packRoot);
            }
            catch (Exception e) {
                try {
                    this.log("Clean up package " + packRoot + " because installation failed: " + e.getMessage());
                    e.printStackTrace();
                    Utilities.clearDirectory(packRoot, new String[0]);
                    new File(packRoot).delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
            return pck;
        });
    }

    private void log(String s) {
        if (!this.silent) {
            System.out.println(s);
        }
    }

    private void logn(String s) {
        if (!this.silent) {
            System.out.print(s);
        }
    }

    @Override
    public String getPackageUrl(String packageId) throws IOException {
        String result = super.getPackageUrl(packageId);
        if (result == null) {
            result = this.getPackageUrlFromBuildList(packageId);
        }
        return result;
    }

    public void listAllIds(Map<String, String> specList) throws IOException {
        for (NpmPackage p : this.temporaryPackages) {
            specList.put(p.name(), p.canonical());
        }
        for (PackageServer next : this.getPackageServers()) {
            this.listSpecs(specList, next);
        }
        this.addCIBuildSpecs(specList);
    }

    @Override
    public NpmPackage loadPackage(String id, String version) throws FHIRException, IOException {
        BasePackageCacheManager.InputStreamWithSrc source;
        NpmPackage p;
        if (!Utilities.noString(version) && version.startsWith("file:")) {
            return this.loadPackageFromFile(id, version.substring(5));
        }
        if (version == null && id.contains("#")) {
            version = id.substring(id.indexOf("#") + 1);
            id = id.substring(0, id.indexOf("#"));
        }
        if (version == null) {
            try {
                version = this.getLatestVersion(id);
            }
            catch (Exception e) {
                version = null;
            }
        }
        if ((p = this.loadPackageFromCacheOnly(id, version)) != null) {
            if ("current".equals(version)) {
                p = this.checkCurrency(id, p);
            }
            if (p != null) {
                return p;
            }
        }
        if ("dev".equals(version)) {
            p = this.loadPackageFromCacheOnly(id, "current");
            if ((p = this.checkCurrency(id, p)) != null) {
                return p;
            }
            version = "current";
        }
        if (this.progress) {
            this.log("Installing " + id + "#" + (version == null ? "?" : version) + " to the package cache");
            this.log("  Fetching:");
        }
        if ((source = Utilities.isAbsoluteUrl(version) ? this.fetchSourceFromUrlSpecific(version) : ("current".equals(version) || version != null && version.startsWith("current$") ? this.loadFromCIBuild(id, version.startsWith("current$") ? version.substring(8) : null) : this.loadFromPackageServer(id, version))) == null) {
            throw new FHIRException("Unable to find package " + id + "#" + version);
        }
        return this.addPackageToCache(id, source.version, source.stream, source.url);
    }

    private BasePackageCacheManager.InputStreamWithSrc fetchSourceFromUrlSpecific(String url) {
        return new BasePackageCacheManager.InputStreamWithSrc(this.fetchFromUrlSpecific(url, false), url, "current");
    }

    private InputStream fetchFromUrlSpecific(String source, boolean optional) throws FHIRException {
        try {
            SimpleHTTPClient http = new SimpleHTTPClient();
            SimpleHTTPClient.HTTPResult res = http.get(source);
            res.checkThrowException();
            return new ByteArrayInputStream(res.getContent());
        }
        catch (Exception e) {
            if (optional) {
                return null;
            }
            throw new FHIRException("Unable to fetch: " + e.getMessage(), e);
        }
    }

    private BasePackageCacheManager.InputStreamWithSrc loadFromCIBuild(String id, String branch) throws IOException {
        this.checkBuildLoaded();
        if (this.ciList.containsKey(id)) {
            if (branch == null) {
                InputStream stream;
                try {
                    stream = this.fetchFromUrlSpecific(Utilities.pathURL(this.ciList.get(id), "package.tgz"), false);
                }
                catch (Exception e) {
                    stream = this.fetchFromUrlSpecific(Utilities.pathURL(this.ciList.get(id), "branches", "main", "package.tgz"), false);
                }
                return new BasePackageCacheManager.InputStreamWithSrc(stream, Utilities.pathURL(this.ciList.get(id), "package.tgz"), "current");
            }
            InputStream stream = this.fetchFromUrlSpecific(Utilities.pathURL(this.ciList.get(id), "branches", branch, "package.tgz"), false);
            return new BasePackageCacheManager.InputStreamWithSrc(stream, Utilities.pathURL(this.ciList.get(id), "branches", branch, "package.tgz"), "current$" + branch);
        }
        if (id.startsWith("hl7.fhir.r6")) {
            InputStream stream = this.fetchFromUrlSpecific(Utilities.pathURL("http://build.fhir.org", id + ".tgz"), false);
            return new BasePackageCacheManager.InputStreamWithSrc(stream, Utilities.pathURL("http://build.fhir.org", id + ".tgz"), "current");
        }
        throw new FHIRException("The package '" + id + "' has no entry on the current build server (" + this.ciList.toString() + ")");
    }

    private String getPackageUrlFromBuildList(String packageId) throws IOException {
        this.checkBuildLoaded();
        for (JsonObject o : this.buildInfo.asJsonObjects()) {
            if (!packageId.equals(o.asString("package-id"))) continue;
            return o.asString("url");
        }
        return null;
    }

    private void addCIBuildSpecs(Map<String, String> specList) throws IOException {
        this.checkBuildLoaded();
        for (JsonElement n : this.buildInfo) {
            JsonObject o = (JsonObject)n;
            if (specList.containsKey(o.asString("package-id"))) continue;
            specList.put(o.asString("package-id"), o.asString("url"));
        }
    }

    @Override
    public String getPackageId(String canonicalUrl) throws IOException {
        String retVal = this.findCanonicalInLocalCache(canonicalUrl);
        if (retVal == null) {
            retVal = super.getPackageId(canonicalUrl);
        }
        if (retVal == null) {
            retVal = this.getPackageIdFromBuildList(canonicalUrl);
        }
        return retVal;
    }

    public String findCanonicalInLocalCache(String canonicalUrl) {
        try {
            for (String pf : this.listPackages()) {
                JsonObject npm;
                if (!new File(Utilities.path(this.cacheFolder, pf, "package", "package.json")).exists() || !canonicalUrl.equals((npm = JsonParser.parseObjectFromFile(Utilities.path(this.cacheFolder, pf, "package", "package.json"))).asString("canonical"))) continue;
                return npm.asString("name");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private String getPackageIdFromBuildList(String canonical) throws IOException {
        if (canonical == null) {
            return null;
        }
        this.checkBuildLoaded();
        if (this.buildInfo != null) {
            JsonObject o;
            for (JsonElement n : this.buildInfo) {
                o = (JsonObject)n;
                if (!canonical.equals(o.asString("url"))) continue;
                return o.asString("package-id");
            }
            for (JsonElement n : this.buildInfo) {
                o = (JsonObject)n;
                if (!o.asString("url").startsWith(canonical + "/ImplementationGuide/")) continue;
                return o.asString("package-id");
            }
        }
        return null;
    }

    private NpmPackage checkCurrency(String id, NpmPackage p) throws IOException {
        this.checkBuildLoaded();
        try {
            String url = this.ciList.get(id);
            JsonObject json = JsonParser.parseObjectFromUrl(Utilities.pathURL(url, "package.manifest.json"));
            String currDate = json.asString("date");
            String packDate = p.date();
            if (!currDate.equals(packDate)) {
                return null;
            }
        }
        catch (Exception e) {
            this.log("Unable to check package currency: " + id + ": " + id);
        }
        return p;
    }

    private void checkBuildLoaded() {
        if (!this.buildLoaded) {
            try {
                this.loadFromBuildServer();
            }
            catch (Exception e) {
                try {
                    Thread.sleep(1000L);
                    this.loadFromBuildServer();
                }
                catch (Exception e2) {
                    this.log("Error connecting to build server - running without build (" + e2.getMessage() + ")");
                }
            }
        }
    }

    private void loadFromBuildServer() throws IOException {
        SimpleHTTPClient http = new SimpleHTTPClient();
        SimpleHTTPClient.HTTPResult res = http.get("https://build.fhir.org/ig/qas.json?nocache=" + System.currentTimeMillis());
        res.checkThrowException();
        this.buildInfo = (JsonArray)JsonParser.parse(TextFile.bytesToString(res.getContent()));
        ArrayList<BuildRecord> builds = new ArrayList<BuildRecord>();
        for (JsonElement n : this.buildInfo) {
            JsonObject o = (JsonObject)n;
            if (!o.has("url") || !o.has("package-id") || !o.asString("package-id").contains(".")) continue;
            String u = o.asString("url");
            if (u.contains("/ImplementationGuide/")) {
                u = u.substring(0, u.indexOf("/ImplementationGuide/"));
            }
            builds.add(new BuildRecord(u, o.asString("package-id"), this.getRepo(o.asString("repo")), this.readDate(o.asString("date"))));
        }
        Collections.sort(builds, new BuildRecordSorter());
        for (BuildRecord bld : builds) {
            if (this.ciList.containsKey(bld.getPackageId())) continue;
            this.ciList.put(bld.getPackageId(), "https://build.fhir.org/ig/" + bld.getRepo());
        }
        this.buildLoaded = true;
    }

    private String getRepo(String path) {
        String[] p = path.split("\\/");
        return p[0] + "/" + p[1];
    }

    private Date readDate(String s) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM, yyyy HH:mm:ss Z", new Locale("en", "US"));
        try {
            return sdf.parse(s);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    private BasePackageCacheManager.InputStreamWithSrc fetchTheOldWay(String id, String v) {
        PackageList pl;
        String pu;
        String url = this.getUrlForPackage(id);
        if (url == null) {
            try {
                url = this.getPackageUrlFromBuildList(id);
            }
            catch (Exception e) {
                url = null;
            }
        }
        if (url == null) {
            throw new FHIRException("Unable to resolve package id " + id + "#" + v);
        }
        if (url.contains("/ImplementationGuide/")) {
            url = url.substring(0, url.indexOf("/ImplementationGuide/"));
        }
        String aurl = pu = Utilities.pathURL(url, "package-list.json");
        try {
            pl = PackageList.fromUrl(pu);
        }
        catch (Exception e) {
            String pv = Utilities.pathURL(url, v, "package.tgz");
            try {
                aurl = pv;
                BasePackageCacheManager.InputStreamWithSrc src = new BasePackageCacheManager.InputStreamWithSrc(this.fetchFromUrlSpecific(pv, false), pv, v);
                return src;
            }
            catch (Exception e1) {
                throw new FHIRException("Error fetching package directly (" + pv + "), or fetching package list for " + id + " from " + pu + ": " + e1.getMessage(), e1);
            }
        }
        if (!id.equals(pl.pid())) {
            throw new FHIRException("Package ids do not match in " + pu + ": " + id + " vs " + pl.pid());
        }
        for (PackageList.PackageListEntry vo : pl.versions()) {
            if (!v.equals(vo.version())) continue;
            aurl = Utilities.pathURL(vo.path(), "package.tgz");
            String u = Utilities.pathURL(vo.path(), "package.tgz");
            return new BasePackageCacheManager.InputStreamWithSrc(this.fetchFromUrlSpecific(u, true), u, v);
        }
        return null;
    }

    private String fetchVersionTheOldWay(String id) throws IOException {
        String url = this.getUrlForPackage(id);
        if (url == null) {
            try {
                url = this.getPackageUrlFromBuildList(id);
            }
            catch (Exception e) {
                url = null;
            }
        }
        if (url == null) {
            throw new FHIRException("Unable to resolve package id " + id);
        }
        PackageList pl = PackageList.fromUrl(Utilities.pathURL(url, "package-list.json"));
        if (!id.equals(pl.pid())) {
            throw new FHIRException("Package ids do not match in " + pl.source() + ": " + id + " vs " + pl.pid());
        }
        for (PackageList.PackageListEntry vo : pl.versions()) {
            if (!vo.current()) continue;
            return vo.version();
        }
        return null;
    }

    private String getUrlForPackage(String id) {
        if ("hl7.fhir.xver-extensions".equals(id)) {
            return "http://fhir.org/packages/hl7.fhir.xver-extensions";
        }
        return null;
    }

    public List<String> listPackages() {
        ArrayList<String> res = new ArrayList<String>();
        for (File f : this.cacheFolder.listFiles()) {
            if (!f.isDirectory() || !f.getName().contains("#")) continue;
            res.add(f.getName());
        }
        return res;
    }

    public boolean packageExists(String id, String ver) throws IOException {
        if (this.packageInstalled(id, ver)) {
            return true;
        }
        for (PackageServer s : this.getPackageServers()) {
            if (!new PackageClient(s).exists(id, ver)) continue;
            return true;
        }
        return false;
    }

    public boolean packageInstalled(String id, String version) {
        for (NpmPackage p : this.temporaryPackages) {
            if (p.name().equals(id) && ("current".equals(version) || "dev".equals(version) || p.version().equals(version))) {
                return true;
            }
            if (!p.name().equals(id) || !Utilities.noString(version)) continue;
            return true;
        }
        for (String f : Utilities.sorted(this.cacheFolder.list())) {
            if (!f.equals(id + "#" + version) && (!Utilities.noString(version) || !f.startsWith(id + "#"))) continue;
            return true;
        }
        if ("dev".equals(version)) {
            return this.packageInstalled(id, "current");
        }
        return false;
    }

    public boolean isSuppressErrors() {
        return this.suppressErrors;
    }

    public void setSuppressErrors(boolean suppressErrors) {
        this.suppressErrors = suppressErrors;
    }

    public static IPackageProvider getPackageProvider() {
        return packageProvider;
    }

    public static void setPackageProvider(IPackageProvider packageProvider) {
        FilesystemPackageCacheManager.packageProvider = packageProvider;
    }

    static {
        ourLog = LoggerFactory.getLogger(FilesystemPackageCacheManager.class);
    }

    public class CacheLock {
        private final File lockFile;

        public CacheLock(String name) throws IOException {
            this.lockFile = new File(FilesystemPackageCacheManager.this.cacheFolder, name + ".lock");
            if (!this.lockFile.isFile()) {
                TextFile.stringToFile("", this.lockFile);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T doWithLock(CacheLockFunction<T> f) throws FileNotFoundException, IOException {
            try (FileChannel channel = new RandomAccessFile(this.lockFile, "rw").getChannel();){
                FileLock fileLock = channel.lock();
                T result = null;
                try {
                    result = f.get();
                }
                finally {
                    fileLock.release();
                }
                if (!this.lockFile.delete()) {
                    this.lockFile.deleteOnExit();
                }
                T t = result;
                return t;
            }
        }
    }

    public class PackageEntry {
        private byte[] bytes;
        private String name;

        public PackageEntry(String name) {
            this.name = name;
        }

        public PackageEntry(String name, byte[] bytes) {
            this.name = name;
            this.bytes = bytes;
        }
    }

    public class VersionHistory {
        private String id;
        private String canonical;
        private String current;
        private Map<String, String> versions = new HashMap<String, String>();

        public String getCanonical() {
            return this.canonical;
        }

        public String getCurrent() {
            return this.current;
        }

        public Map<String, String> getVersions() {
            return this.versions;
        }

        public String getId() {
            return this.id;
        }
    }

    public class BuildRecord {
        private String url;
        private String packageId;
        private String repo;
        private Date date;

        public BuildRecord(String url, String packageId, String repo, Date date) {
            this.url = url;
            this.packageId = packageId;
            this.repo = repo;
            this.date = date;
        }

        public String getUrl() {
            return this.url;
        }

        public String getPackageId() {
            return this.packageId;
        }

        public String getRepo() {
            return this.repo;
        }

        public Date getDate() {
            return this.date;
        }
    }

    public class BuildRecordSorter
    implements Comparator<BuildRecord> {
        @Override
        public int compare(BuildRecord arg0, BuildRecord arg1) {
            return arg1.date.compareTo(arg0.date);
        }
    }

    public static interface CacheLockFunction<T> {
        public T get() throws IOException;
    }

    public static interface INetworkServices {
        public InputStream resolvePackage(String var1, String var2);
    }

    public static interface IPackageProvider {
        public boolean handlesPackage(String var1, String var2);

        public BasePackageCacheManager.InputStreamWithSrc provide(String var1, String var2) throws IOException;
    }

    public static enum FilesystemPackageCacheMode {
        USER,
        SYSTEM,
        TESTING,
        CUSTOM;

    }
}

