/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import org.apache.commons.lang3.StringUtils;

public class CanonicalPair {
    private final String url;
    private final String version;

    public static CanonicalPair of(String target) {
        return new CanonicalPair(target);
    }

    public CanonicalPair(String target) {
        int pipeIndex;
        int n = pipeIndex = target != null ? target.indexOf(124) : -1;
        if (pipeIndex >= 0) {
            this.url = target.substring(0, pipeIndex);
            this.version = target.substring(pipeIndex + 1);
        } else {
            this.url = target;
            this.version = null;
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public String getVersionOr(String alternative) {
        return this.hasVersion() ? this.version : alternative;
    }

    public boolean hasNonEmptyVersion() {
        return StringUtils.isNotEmpty((CharSequence)this.version);
    }
}

