/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;

public class SimpleTimeTracker {
    private long start;
    private String name;
    private String context;
    private int count;
    public static int level = 0;
    public static BufferedWriter bw;

    public SimpleTimeTracker(String name) {
        ++level;
        this.name = name;
        this.count = -1;
        this.start = System.currentTimeMillis();
        this.init();
        this.log(name);
    }

    public SimpleTimeTracker(String name, String context) {
        ++level;
        this.name = name;
        this.context = context;
        this.start = System.currentTimeMillis();
        this.count = -1;
        this.init();
        this.log(name + " [" + context + "]");
    }

    private void init() {
        if (bw == null) {
            try {
                File fout = ManagedFileAccess.file("/Users/grahamegrieve/temp/time.txt");
                FileOutputStream fos = ManagedFileAccess.outStream(fout);
                bw = new BufferedWriter(new OutputStreamWriter(fos));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void report() {
        Object s = this.count == -1 ? "" : " (" + this.count + ")";
        s = this.context == null ? this.name + ": " + (System.currentTimeMillis() - this.start) + "ms " + (String)s : this.name + ": " + (System.currentTimeMillis() - this.start) + "ms " + (String)s + " [" + this.context + "]";
        this.log((String)s);
        if (--level == 0) {
            try {
                bw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void log(String s) {
        System.out.println(Utilities.padLeft("", '#', level) + " " + s);
        try {
            bw.write(s);
            bw.newLine();
        }
        catch (Exception e) {
            System.out.println("e: " + e.getMessage());
        }
    }

    public void count() {
        this.count = this.count == -1 ? 1 : ++this.count;
    }
}

