/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.json.parser;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.http.HTTPResult;
import org.hl7.fhir.utilities.http.ManagedWebAccess;
import org.hl7.fhir.utilities.json.JsonException;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonBoolean;
import org.hl7.fhir.utilities.json.model.JsonComment;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonElementType;
import org.hl7.fhir.utilities.json.model.JsonLocationData;
import org.hl7.fhir.utilities.json.model.JsonNull;
import org.hl7.fhir.utilities.json.model.JsonNumber;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.model.JsonPrimitive;
import org.hl7.fhir.utilities.json.model.JsonProperty;
import org.hl7.fhir.utilities.json.model.JsonString;
import org.hl7.fhir.utilities.json.parser.JsonLexer;

public class JsonParser {
    private JsonLexer lexer;
    private ItemType itemType = ItemType.Object;
    private String itemName;
    private String itemValue;
    private boolean allowDuplicates = true;
    private boolean allowComments = false;
    private boolean allowNoComma = false;
    private JsonLocationData startProperty;
    private JsonLocationData endProperty;
    private boolean itemNoComma;
    private boolean allowUnquotedStrings;
    private boolean itemUnquoted;
    private boolean valueUnquoted;
    private String sourceName;
    private int line = 0;

    protected JsonParser() {
    }

    protected JsonParser(int line) {
        this.line = line;
    }

    public static JsonObject parseObject(InputStream stream) throws IOException, JsonException {
        return new JsonParser().parseJsonObject(TextFile.streamToString(stream), false, false);
    }

    public static JsonObject parseObject(byte[] content) throws IOException, JsonException {
        return new JsonParser().parseJsonObject(TextFile.bytesToString(content), false, false);
    }

    public static JsonObject parseObject(String source) throws IOException, JsonException {
        return new JsonParser().parseJsonObject(source, false, false);
    }

    public static JsonObject parseObject(File source) throws IOException, JsonException {
        if (!source.exists()) {
            throw new IOException("File " + source + " not found");
        }
        return new JsonParser().setSourceName(source.getAbsolutePath()).parseJsonObject(TextFile.fileToString(source), false, false);
    }

    public static JsonObject parseObjectFromFile(String source) throws IOException, JsonException {
        return new JsonParser().setSourceName(source).parseJsonObject(TextFile.fileToString(source), false, false);
    }

    public static JsonObject parseObjectFromUrl(String source) throws IOException, JsonException {
        return new JsonParser().setSourceName(source).parseJsonObject(TextFile.bytesToString(JsonParser.fetch(source)), false, false);
    }

    public static JsonObject parseObject(InputStream stream, boolean isJson5) throws IOException, JsonException {
        return new JsonParser().parseJsonObject(TextFile.streamToString(stream), isJson5, false);
    }

    public static JsonObject parseObject(byte[] content, boolean isJson5) throws IOException, JsonException {
        return new JsonParser().parseJsonObject(TextFile.bytesToString(content), isJson5, false);
    }

    public static JsonObject parseObject(String source, boolean isJson5) throws IOException, JsonException {
        return new JsonParser().parseJsonObject(source, isJson5, false);
    }

    public static JsonObject parseObjectFromUrl(String source, boolean isJson5) throws IOException, JsonException {
        return new JsonParser().setSourceName(source).parseJsonObject(TextFile.bytesToString(JsonParser.fetch(source)), isJson5, false);
    }

    public static JsonObject parseObject(InputStream stream, boolean isJson5, boolean allowDuplicates) throws IOException, JsonException {
        return JsonParser.parseObject(TextFile.streamToString(stream), isJson5, allowDuplicates);
    }

    public static JsonObject parseObject(byte[] stream, boolean isJson5, boolean allowDuplicates) throws IOException, JsonException {
        return JsonParser.parseObject(TextFile.bytesToString(stream), isJson5, allowDuplicates);
    }

    public static JsonObject parseObject(String source, boolean isJson5, boolean allowDuplicates) throws IOException, JsonException {
        return new JsonParser().parseJsonObject(source, isJson5, allowDuplicates);
    }

    public static JsonObject parseObject(String source, boolean isJson5, boolean allowDuplicates, int line) throws IOException, JsonException {
        return new JsonParser(line).parseJsonObject(source, isJson5, allowDuplicates);
    }

    public static JsonElement parse(InputStream stream) throws IOException, JsonException {
        return JsonParser.parse(TextFile.streamToString(stream));
    }

    public static JsonElement parse(byte[] stream) throws IOException, JsonException {
        return JsonParser.parse(TextFile.bytesToString(stream));
    }

    public static JsonElement parse(String source) throws IOException, JsonException {
        return JsonParser.parse(source, false);
    }

    public static JsonElement parse(File source) throws IOException, JsonException {
        return JsonParser.parse(TextFile.fileToString(source));
    }

    public static JsonElement parseFromFile(String source) throws IOException, JsonException {
        return JsonParser.parse(TextFile.fileToString(source));
    }

    public static JsonElement parseFromUrl(String source) throws IOException, JsonException {
        return JsonParser.parse(JsonParser.fetch(source));
    }

    public static JsonElement parse(InputStream stream, boolean isJson5) throws IOException, JsonException {
        return JsonParser.parse(TextFile.streamToString(stream), isJson5);
    }

    public static JsonElement parse(byte[] stream, boolean isJson5) throws IOException, JsonException {
        return JsonParser.parse(TextFile.bytesToString(stream), isJson5);
    }

    public static JsonElement parse(String source, boolean isJson5) throws IOException, JsonException {
        return JsonParser.parse(source, isJson5, false);
    }

    public static JsonElement parseFromUrl(String source, boolean isJson5) throws IOException, JsonException {
        return JsonParser.parse(JsonParser.fetch(source), isJson5);
    }

    public static JsonElement parse(InputStream stream, boolean isJson5, boolean allowDuplicates) throws IOException, JsonException {
        return JsonParser.parse(TextFile.streamToString(stream), isJson5, allowDuplicates);
    }

    public static JsonElement parse(byte[] stream, boolean isJson5, boolean allowDuplicates) throws IOException, JsonException {
        return JsonParser.parse(TextFile.bytesToString(stream), isJson5, allowDuplicates);
    }

    public static JsonElement parse(String source, boolean isJson5, boolean allowDuplicates) throws IOException, JsonException {
        return new JsonParser().parseJsonElement(source, isJson5, allowDuplicates);
    }

    public static String compose(JsonElement element) {
        return JsonParser.compose(element, false);
    }

    public static void compose(JsonElement element, OutputStream stream) throws IOException {
        JsonParser.compose(element, stream, false);
    }

    public static void compose(JsonElement element, File file) throws IOException {
        FileOutputStream fo = ManagedFileAccess.outStream(file);
        JsonParser.compose(element, fo, false);
        fo.close();
    }

    public static byte[] composeBytes(JsonElement element) {
        return JsonParser.composeBytes(element, false);
    }

    public static String compose(JsonElement element, boolean pretty) {
        return new JsonParser().write(element, pretty);
    }

    public static void compose(JsonElement element, OutputStream stream, boolean pretty) throws IOException {
        byte[] cnt = JsonParser.composeBytes(element, pretty);
        stream.write(cnt);
    }

    public static void compose(JsonElement element, File file, boolean pretty) throws IOException {
        byte[] cnt = JsonParser.composeBytes(element, pretty);
        FileOutputStream fo = ManagedFileAccess.outStream(file);
        fo.write(cnt);
        fo.close();
    }

    public static byte[] composeBytes(JsonElement element, boolean pretty) {
        String s = JsonParser.compose(element, pretty);
        return s.getBytes(StandardCharsets.UTF_8);
    }

    private JsonObject parseJsonObject(String source, boolean isJson5, boolean allowDuplicates) throws IOException, JsonException {
        this.allowDuplicates = allowDuplicates;
        this.allowComments = isJson5;
        this.allowNoComma = isJson5;
        this.allowUnquotedStrings = isJson5;
        return this.parseSource(Utilities.stripBOM(source));
    }

    private JsonObject parseSource(String source) throws IOException, JsonException {
        this.lexer = new JsonLexer(source, this.allowComments, this.allowUnquotedStrings, this.line);
        this.lexer.setSourceName(this.sourceName);
        JsonObject result = new JsonObject();
        this.lexer.takeComments(result);
        result.setStart(this.lexer.getLastLocationAWS().copy());
        if (this.lexer.getType() != JsonLexer.TokenType.Open) {
            if (this.lexer.getType() != null) {
                throw this.lexer.error("Unexpected content at start of JSON: " + this.lexer.getType().toString());
            }
            throw this.lexer.error("Unexpected content at start of JSON");
        }
        this.lexer.next();
        this.lexer.getStates().push(new JsonLexer.State("", true));
        if (this.lexer.getType() != JsonLexer.TokenType.Close) {
            this.parseProperty();
            this.readObject("$", result, true);
            result.setEnd(this.endProperty != null ? this.endProperty.copy() : this.lexer.getLocation().copy());
        } else {
            result.setEnd(this.endProperty != null ? this.endProperty.copy() : this.lexer.getLocation().copy());
            this.lexer.next();
        }
        if (this.lexer.getType() != JsonLexer.TokenType.Eof) {
            throw this.lexer.error("Unexpected content at end of JSON: " + this.lexer.getType().toString());
        }
        return result;
    }

    private JsonElement parseJsonElement(String source, boolean isJson5, boolean allowDuplicates) throws IOException, JsonException {
        this.allowDuplicates = allowDuplicates;
        this.allowComments = isJson5;
        this.allowNoComma = isJson5;
        this.allowUnquotedStrings = isJson5;
        return this.parseSourceElement(Utilities.stripBOM(source));
    }

    private JsonElement parseSourceElement(String source) throws IOException, JsonException {
        this.lexer = new JsonLexer(source, this.allowComments, this.allowUnquotedStrings, this.line);
        switch (this.lexer.getType()) {
            case Boolean: {
                JsonBoolean bool = new JsonBoolean(this.lexer.getValue().equals("true"));
                this.lexer.takeComments(bool);
                bool.setStart(this.lexer.getLastLocationAWS().copy());
                bool.setEnd(this.endProperty != null ? this.endProperty.copy() : this.lexer.getLocation().copy());
                return bool;
            }
            case Null: {
                JsonNull nll = new JsonNull();
                this.lexer.takeComments(nll);
                nll.setStart(this.lexer.getLastLocationAWS().copy());
                nll.setEnd(this.endProperty != null ? this.endProperty.copy() : this.lexer.getLocation().copy());
                return nll;
            }
            case Number: {
                JsonNumber num = new JsonNumber(this.lexer.getValue());
                this.lexer.takeComments(num);
                num.setStart(this.lexer.getLastLocationAWS().copy());
                num.setEnd(this.endProperty != null ? this.endProperty.copy() : this.lexer.getLocation().copy());
                return num;
            }
            case Open: {
                JsonObject obj = new JsonObject();
                this.lexer.takeComments(obj);
                obj.setStart(this.lexer.getLastLocationAWS().copy());
                if (this.lexer.getType() != JsonLexer.TokenType.Open) {
                    throw this.lexer.error("Unexpected content at start of JSON: " + this.lexer.getType().toString());
                }
                this.lexer.next();
                this.lexer.getStates().push(new JsonLexer.State("", true));
                if (this.lexer.getType() != JsonLexer.TokenType.Close) {
                    this.parseProperty();
                    this.readObject("$", obj, true);
                }
                obj.setEnd(this.endProperty != null ? this.endProperty.copy() : this.lexer.getLocation().copy());
                return obj;
            }
            case OpenArray: {
                JsonArray arr = new JsonArray();
                this.lexer.takeComments(arr);
                arr.setStart(this.lexer.getLastLocationAWS().copy());
                this.lexer.next();
                this.lexer.getStates().push(new JsonLexer.State("", false));
                if (this.lexer.getType() != JsonLexer.TokenType.CloseArray) {
                    this.parseProperty();
                    this.readArray("$", arr, true);
                }
                arr.setEnd(this.endProperty != null ? this.endProperty.copy() : this.lexer.getLocation().copy());
                return arr;
            }
            case String: {
                JsonString str = new JsonString(this.lexer.getValue());
                this.lexer.takeComments(str);
                str.setStart(this.lexer.getLastLocationAWS().copy());
                str.setEnd(this.endProperty != null ? this.endProperty.copy() : this.lexer.getLocation().copy());
                return str;
            }
        }
        throw this.lexer.error("Unexpected content at start of JSON: " + this.lexer.getType().toString());
    }

    private void readObject(String path, JsonObject obj, boolean root) throws IOException, JsonException {
        while (this.itemType != ItemType.End || root && this.itemType == ItemType.Eof) {
            obj.setExtraComma(false);
            switch (this.itemType) {
                case Object: {
                    JsonObject child = new JsonObject();
                    child.setStart(this.startProperty.copy());
                    this.lexer.takeComments(child);
                    if (obj.has(this.itemName) && !this.allowDuplicates) {
                        throw this.lexer.error("Duplicated property name: " + this.itemName + " @ " + path);
                    }
                    obj.addForParser(this.itemName, child, this.itemNoComma, this.itemUnquoted, this.valueUnquoted);
                    this.next();
                    this.readObject(path + "." + this.itemName, child, false);
                    child.setEnd(this.endProperty.copy());
                    break;
                }
                case Boolean: {
                    JsonBoolean childB = new JsonBoolean(Boolean.valueOf(this.itemValue));
                    childB.setStart(this.startProperty.copy());
                    this.lexer.takeComments(childB);
                    if (obj.has(this.itemName) && !this.allowDuplicates) {
                        throw this.lexer.error("Duplicated property name: " + this.itemName + " @ " + path);
                    }
                    obj.addForParser(this.itemName, childB, this.itemNoComma, this.itemUnquoted, this.valueUnquoted);
                    childB.setEnd(this.endProperty.copy());
                    break;
                }
                case String: {
                    JsonString childS = new JsonString(this.itemValue);
                    childS.setStart(this.startProperty.copy());
                    this.lexer.takeComments(childS);
                    if (obj.has(this.itemName) && !this.allowDuplicates) {
                        throw this.lexer.error("Duplicated property name: " + this.itemName + " @ " + path);
                    }
                    obj.addForParser(this.itemName, childS, this.itemNoComma, this.itemUnquoted, this.valueUnquoted);
                    childS.setEnd(this.endProperty.copy());
                    break;
                }
                case Number: {
                    JsonNumber childN = new JsonNumber(this.itemValue);
                    childN.setStart(this.startProperty.copy());
                    this.lexer.takeComments(childN);
                    if (obj.has(this.itemName) && !this.allowDuplicates) {
                        throw this.lexer.error("Duplicated property name: " + this.itemName + " @ " + path);
                    }
                    obj.addForParser(this.itemName, childN, this.itemNoComma, this.itemUnquoted, this.valueUnquoted);
                    childN.setEnd(this.endProperty.copy());
                    break;
                }
                case Null: {
                    JsonNull childn = new JsonNull();
                    childn.setStart(this.startProperty.copy());
                    this.lexer.takeComments(childn);
                    if (obj.has(this.itemName) && !this.allowDuplicates) {
                        throw this.lexer.error("Duplicated property name: " + this.itemName + " @ " + path);
                    }
                    obj.addForParser(this.itemName, childn, this.itemNoComma, this.itemUnquoted, this.valueUnquoted);
                    childn.setEnd(this.endProperty.copy());
                    break;
                }
                case Array: {
                    JsonArray childA = new JsonArray();
                    childA.setStart(this.startProperty.copy());
                    this.lexer.takeComments(childA);
                    if (obj.has(this.itemName) && !this.allowDuplicates) {
                        throw this.lexer.error("Duplicated property name: " + this.itemName + " @ " + path);
                    }
                    obj.addForParser(this.itemName, childA, this.itemNoComma, this.itemUnquoted, this.valueUnquoted);
                    this.next();
                    if (!this.readArray(path + "." + this.itemName, childA, false)) {
                        this.next(true);
                    }
                    if (childA.getEnd() != null) break;
                    childA.setEnd(this.endProperty.copy());
                    break;
                }
                case Eof: {
                    throw this.lexer.error("Unexpected End of File");
                }
                case End: {
                    throw this.lexer.error("Unexpected End");
                }
            }
            this.itemNoComma = false;
            this.endProperty = this.lexer.getLocation().copy();
            obj.setExtraComma(this.lexer.getType() == JsonLexer.TokenType.Comma);
            this.next();
        }
    }

    private boolean readArray(String path, JsonArray arr, boolean root) throws IOException, JsonException {
        boolean res = false;
        while (!(this.itemType == ItemType.End || root && this.itemType == ItemType.Eof)) {
            res = true;
            arr.setExtraComma(false);
            switch (this.itemType) {
                case Object: {
                    JsonObject obj = new JsonObject();
                    obj.setStart(this.startProperty.copy());
                    this.lexer.takeComments(obj);
                    arr.addForParser(obj, this.itemNoComma, this.valueUnquoted);
                    this.next();
                    this.readObject(path + "[" + (arr.size() - 1) + "]", obj, false);
                    obj.setEnd(this.endProperty.copy());
                    break;
                }
                case String: {
                    JsonString s = new JsonString(this.itemValue);
                    s.setStart(this.startProperty.copy());
                    this.lexer.takeComments(s);
                    arr.addForParser(s, this.itemNoComma, this.valueUnquoted);
                    s.setEnd(this.endProperty.copy());
                    break;
                }
                case Number: {
                    JsonNumber n = new JsonNumber(this.itemValue);
                    n.setStart(this.startProperty.copy());
                    this.lexer.takeComments(n);
                    arr.addForParser(n, this.itemNoComma, this.valueUnquoted);
                    n.setEnd(this.endProperty.copy());
                    break;
                }
                case Boolean: {
                    JsonBoolean b = new JsonBoolean("true".equals(this.itemValue));
                    b.setStart(this.startProperty.copy());
                    this.lexer.takeComments(b);
                    arr.addForParser(b, this.itemNoComma, this.valueUnquoted);
                    b.setEnd(this.endProperty.copy());
                    break;
                }
                case Null: {
                    JsonNull nn = new JsonNull();
                    nn.setStart(this.startProperty.copy());
                    this.lexer.takeComments(nn);
                    arr.addForParser(nn, this.itemNoComma, this.valueUnquoted);
                    nn.setEnd(this.endProperty.copy());
                    break;
                }
                case Array: {
                    JsonArray child = new JsonArray();
                    child.setStart(this.startProperty.copy());
                    this.lexer.takeComments(child);
                    arr.addForParser(child, this.itemNoComma, this.valueUnquoted);
                    this.next();
                    this.readArray(path + "[" + (arr.size() - 1) + "]", child, false);
                    child.setEnd(this.endProperty.copy());
                    break;
                }
                case Eof: {
                    throw this.lexer.error("Unexpected End of File");
                }
                case End: {
                    throw this.lexer.error("Can't get here");
                }
            }
            this.itemNoComma = false;
            arr.setEnd(this.lexer.getLocation().copy());
            arr.setExtraComma(this.lexer.getType() == JsonLexer.TokenType.Comma);
            this.next();
        }
        return res;
    }

    private void next() throws IOException {
        this.next(false);
    }

    private void next(boolean noPop) throws IOException {
        switch (this.itemType) {
            case Object: {
                this.lexer.consume(JsonLexer.TokenType.Open);
                this.lexer.getStates().push(new JsonLexer.State(this.itemName, true));
                if (this.lexer.getType() == JsonLexer.TokenType.Close) {
                    this.itemType = ItemType.End;
                    this.lexer.next();
                    break;
                }
                this.parseProperty();
                break;
            }
            case Boolean: 
            case String: 
            case Number: 
            case Null: 
            case End: {
                if (this.itemType == ItemType.End && !noPop) {
                    this.lexer.getStates().pop();
                }
                if (this.lexer.getType() == JsonLexer.TokenType.Comma) {
                    this.lexer.next();
                    if (this.allowNoComma && (this.lexer.getType() == JsonLexer.TokenType.CloseArray || this.lexer.getType() == JsonLexer.TokenType.Close)) {
                        this.itemType = ItemType.End;
                        this.lexer.next();
                        break;
                    }
                    this.parseProperty();
                    break;
                }
                if (this.lexer.getType() == JsonLexer.TokenType.Close) {
                    this.itemType = ItemType.End;
                    this.lexer.next();
                    break;
                }
                if (this.lexer.getType() == JsonLexer.TokenType.CloseArray) {
                    this.itemType = ItemType.End;
                    this.lexer.next();
                    break;
                }
                if (this.lexer.getType() == JsonLexer.TokenType.Eof) {
                    this.itemType = ItemType.Eof;
                    break;
                }
                if (this.allowNoComma && (this.lexer.getType() == JsonLexer.TokenType.String || !this.lexer.getStates().peek().isProp() && this.lexer.getType().isValueType())) {
                    this.itemNoComma = true;
                    this.parseProperty();
                    break;
                }
                throw this.lexer.error("Unexpected JSON syntax");
            }
            case Array: {
                this.lexer.next();
                this.lexer.getStates().push(new JsonLexer.State(this.itemName + "[]", false));
                this.parseProperty();
                break;
            }
            case Eof: {
                throw this.lexer.error("JSON Syntax Error - attempt to read past end of json stream");
            }
            default: {
                throw this.lexer.error("not done yet (a): " + this.itemType.toString());
            }
        }
    }

    private void parseProperty() throws IOException {
        if (this.lexer.getStates().peek().isProp()) {
            this.itemUnquoted = this.lexer.isUnquoted();
            this.itemName = this.lexer.consume(JsonLexer.TokenType.String);
            this.itemValue = null;
            this.lexer.consume(JsonLexer.TokenType.Colon);
        }
        this.startProperty = this.lexer.getLastLocationAWS().copy();
        this.endProperty = this.lexer.getLocation().copy();
        this.valueUnquoted = this.lexer.isUnquoted();
        switch (this.lexer.getType()) {
            case Null: {
                this.itemType = ItemType.Null;
                this.itemValue = this.lexer.getValue();
                this.lexer.next();
                break;
            }
            case String: {
                this.itemType = ItemType.String;
                this.itemValue = this.lexer.getValue();
                this.lexer.next();
                break;
            }
            case Boolean: {
                this.itemType = ItemType.Boolean;
                this.itemValue = this.lexer.getValue();
                this.lexer.next();
                break;
            }
            case Number: {
                this.itemType = ItemType.Number;
                this.itemValue = this.lexer.getValue();
                this.lexer.next();
                break;
            }
            case Open: {
                this.itemType = ItemType.Object;
                break;
            }
            case OpenArray: {
                this.itemType = ItemType.Array;
                break;
            }
            case CloseArray: {
                this.itemType = ItemType.End;
                break;
            }
            default: {
                throw this.lexer.error("not done yet (b): " + this.lexer.getType().toString());
            }
        }
    }

    private String write(JsonElement element, boolean pretty) {
        StringBuilder b = new StringBuilder();
        if (pretty && element.hasComments()) {
            this.writeComments(b, element.getComments(), 0);
        }
        this.write(b, element, pretty, 0);
        if (pretty) {
            b.append("\n");
        }
        return b.toString();
    }

    private void writeComments(StringBuilder b, List<JsonComment> comments, int indent) {
        for (JsonComment s : comments) {
            b.append("// ");
            b.append(s.getContent());
            b.append("\n");
            b.append(Utilities.padLeft("", ' ', indent));
        }
    }

    private void write(StringBuilder b, JsonElement e, boolean pretty, int indent) {
        switch (e.type()) {
            case ARRAY: {
                boolean complex;
                JsonArray arr = (JsonArray)e;
                b.append("[");
                boolean first = true;
                boolean bl = complex = arr.size() > 6;
                if (!complex) {
                    int length = 0;
                    for (JsonElement i : arr.getItems()) {
                        if (i instanceof JsonPrimitive) {
                            length += ((JsonPrimitive)i).toJson().length();
                        }
                        if (i.type() != JsonElementType.ARRAY && i.type() != JsonElementType.OBJECT && !i.hasComments()) continue;
                        complex = true;
                    }
                    if (length > 60) {
                        complex = true;
                    }
                }
                for (JsonElement i : arr.getItems()) {
                    if (first) {
                        first = false;
                    } else {
                        b.append(pretty && !complex ? ", " : ",");
                    }
                    if (pretty && complex) {
                        b.append("\n");
                        b.append(Utilities.padLeft("", ' ', indent + 2));
                        if (i.hasComments()) {
                            this.writeComments(b, i.getComments(), indent + 2);
                        }
                    }
                    this.write(b, i, pretty && complex, indent + 2);
                }
                if (pretty && complex) {
                    b.append("\n");
                    b.append(Utilities.padLeft("", ' ', indent));
                }
                b.append("]");
                break;
            }
            case BOOLEAN: {
                b.append(((JsonBoolean)e).getValue());
                break;
            }
            case NULL: {
                b.append(((JsonNull)e).getValue());
                break;
            }
            case NUMBER: {
                b.append(((JsonNumber)e).getValue());
                break;
            }
            case OBJECT: {
                b.append("{");
                boolean first = true;
                for (JsonProperty p : ((JsonObject)e).getProperties()) {
                    if (first) {
                        first = false;
                    } else {
                        b.append(",");
                    }
                    if (pretty) {
                        b.append("\n");
                        b.append(Utilities.padLeft("", ' ', indent + 2));
                        if (p.getValue().hasComments()) {
                            this.writeComments(b, p.getValue().getComments(), indent + 2);
                        }
                    }
                    b.append("\"");
                    b.append(p.getName());
                    b.append(pretty ? "\" : " : "\":");
                    this.write(b, p.getValue(), pretty, indent + 2);
                }
                if (pretty) {
                    b.append("\n");
                    b.append(Utilities.padLeft("", ' ', indent));
                }
                b.append("}");
                break;
            }
            case STRING: {
                b.append("\"");
                b.append(Utilities.escapeJson(((JsonString)e).getValue()));
                b.append("\"");
                break;
            }
            default: {
                throw new Error("Can't get here");
            }
        }
    }

    private static byte[] fetch(String source) throws IOException {
        String murl = source.contains("?") ? source + "&nocache=" + System.currentTimeMillis() : source + "?nocache=" + System.currentTimeMillis();
        HTTPResult res = ManagedWebAccess.get(murl, "application/json, application/fhir+json");
        res.checkThrowException();
        return res.getContent();
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public JsonParser setSourceName(String sourceName) {
        this.sourceName = sourceName;
        return this;
    }

    static enum ItemType {
        Object,
        String,
        Number,
        Boolean,
        Array,
        End,
        Eof,
        Null;

    }
}

