/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.i18n.subtag;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.hl7.fhir.utilities.i18n.subtag.ExtLangSubtag;
import org.hl7.fhir.utilities.i18n.subtag.LanguageSubtag;
import org.hl7.fhir.utilities.i18n.subtag.LanguageSubtagRegistry;
import org.hl7.fhir.utilities.i18n.subtag.RegionSubtag;
import org.hl7.fhir.utilities.i18n.subtag.ScriptSubtag;
import org.hl7.fhir.utilities.i18n.subtag.Subtag;
import org.hl7.fhir.utilities.i18n.subtag.VariantSubtag;

public class LanguageSubtagRegistryLoader {
    private final LanguageSubtagRegistry registry;
    private final boolean loadLanguages;
    private final boolean loadScripts;
    private final boolean loadExtLangs;
    private final boolean loadRegions;
    private final boolean loadVariants;
    public static final String TYPE = "Type";
    public static final String ADDED = "Added";
    public static final String DESCRIPTION = "Description";
    public static final String SCOPE = "Scope";
    public static final String DEPRECATED = "Deprecated";
    public static final String PREFERRED_VALUE = "Preferred-Value";
    public static final String SUPPRESS_SCRIPT = "Suppress-Script";
    public static final String COMMENTS = "Comments";
    public static final String MACROLANGUAGE = "Macrolanguage";
    public static final String SUBTAG = "Subtag";
    public static final String PREFIX = "Prefix";
    public static final String VARIANT = "variant";
    public static final String LANGUAGE = "language";
    public static final String REGION = "region";
    public static final String SCRIPT = "script";
    public static final String EXTLANG = "extlang";
    public static final String REDUNDANT = "redundant";
    public static final String GRANDFATHERED = "grandfathered";

    public static boolean isMultiField(String field) {
        return DESCRIPTION.equals(field) || COMMENTS.equals(field) || PREFIX.equals(field);
    }

    public LanguageSubtagRegistryLoader(LanguageSubtagRegistry registry) {
        this(registry, true, true, true, true, true);
    }

    private LanguageSubtagRegistryLoader(LanguageSubtagRegistry registry, boolean loadLanguages, boolean loadScripts, boolean loadExtLangs, boolean loadRegions, boolean loadVariants) {
        this.registry = registry;
        this.loadLanguages = loadLanguages;
        this.loadScripts = loadScripts;
        this.loadExtLangs = loadExtLangs;
        this.loadRegions = loadRegions;
        this.loadVariants = loadVariants;
    }

    public void loadFromDefaultResource() throws IOException {
        this.loadFromResource("lang.dat.txt");
    }

    public void loadFromResource(String resourceName) throws IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL resourceUrl = classLoader.getResource(resourceName);
        assert (resourceUrl != null);
        this.load(resourceUrl.openStream());
    }

    private void load(InputStream inputStream) throws IOException {
        Scanner scanner = new Scanner(inputStream, "UTF-8");
        Record record = null;
        String currentField = null;
        Object currentValue = null;
        while (scanner.hasNext()) {
            String[] split;
            String line = scanner.nextLine();
            if (line.equals("%%")) {
                if (record != null) {
                    record.addField(currentField, (String)currentValue);
                }
                record = this.processRecord(record);
                currentField = null;
                currentValue = null;
                continue;
            }
            if (line.startsWith(" ")) {
                assert (currentValue != null);
                currentValue = currentValue + " " + line.trim();
                continue;
            }
            if (currentField != null && currentValue != null) {
                record.addField(currentField, (String)currentValue);
            }
            if ((split = line.split(":\\s")).length != 2) continue;
            currentField = split[0];
            currentValue = split[1];
        }
        if (record != null) {
            record.addField(currentField, (String)currentValue);
        }
        this.processRecord(record);
    }

    protected Record processRecord(Record record) {
        Subtag subtag;
        if (record == null) {
            return new Record();
        }
        String typeValue = record.fields.get(TYPE);
        assert (record.fields.containsKey(ADDED));
        switch (typeValue) {
            case "language": {
                subtag = this.processLanguageRecord(record);
                break;
            }
            case "extlang": {
                subtag = this.processExtLangRecord(record);
                break;
            }
            case "script": {
                subtag = this.processScriptRecord(record);
                break;
            }
            case "region": {
                subtag = this.processRegionRecord(record);
                break;
            }
            case "variant": {
                subtag = this.processVariantRecord(record);
                break;
            }
            default: {
                subtag = null;
            }
        }
        assert (subtag != null || typeValue.equals(GRANDFATHERED) || typeValue.equals(REDUNDANT));
        if (subtag != null) {
            this.addSubtag(subtag);
        }
        return new Record();
    }

    protected void addSubtag(Subtag subtag) {
        assert (subtag.getSubtag() != null);
        if (subtag instanceof LanguageSubtag && this.loadLanguages) {
            this.registry.addLanguage(subtag.getSubtag(), (LanguageSubtag)subtag);
        } else if (subtag instanceof ExtLangSubtag && this.loadExtLangs) {
            this.registry.addExtLang(subtag.getSubtag(), (ExtLangSubtag)subtag);
        } else if (subtag instanceof ScriptSubtag && this.loadScripts) {
            this.registry.addScript(subtag.getSubtag(), (ScriptSubtag)subtag);
        } else if (subtag instanceof RegionSubtag && this.loadRegions) {
            this.registry.addRegion(subtag.getSubtag(), (RegionSubtag)subtag);
        } else if (subtag instanceof VariantSubtag && this.loadVariants) {
            this.registry.addVariant(subtag.getSubtag(), (VariantSubtag)subtag);
        }
    }

    protected Subtag processVariantRecord(Record record) {
        assert (record.fields.containsKey(SUBTAG));
        VariantSubtag variant = new VariantSubtag(record.fields.get(SUBTAG));
        this.addCommonFieldsToSubtag(variant, record);
        variant.setPreferredValue(record.fields.get(PREFERRED_VALUE));
        if (record.multiFields.containsKey(PREFIX)) {
            for (String prefix : record.multiFields.get(PREFIX)) {
                variant.addPrefix(prefix);
            }
        }
        return variant;
    }

    protected Subtag processScriptRecord(Record record) {
        assert (record.fields.containsKey(SUBTAG));
        ScriptSubtag script = new ScriptSubtag(record.fields.get(SUBTAG));
        this.addCommonFieldsToSubtag(script, record);
        return script;
    }

    protected Subtag processRegionRecord(Record record) {
        assert (record.fields.containsKey(SUBTAG));
        RegionSubtag region = new RegionSubtag(record.fields.get(SUBTAG));
        this.addCommonFieldsToSubtag(region, record);
        region.setPreferredValue(record.fields.get(PREFERRED_VALUE));
        return region;
    }

    protected Subtag processExtLangRecord(Record record) {
        assert (record.fields.containsKey(SUBTAG));
        ExtLangSubtag extLang = new ExtLangSubtag(record.fields.get(SUBTAG));
        this.addCommonFieldsToSubtag(extLang, record);
        extLang.setPreferredValue(record.fields.get(PREFERRED_VALUE));
        extLang.setMacrolanguage(record.fields.get(MACROLANGUAGE));
        if (record.multiFields.containsKey(PREFIX)) {
            assert (record.multiFields.get(PREFIX).size() == 1);
            extLang.setPrefix(record.multiFields.get(PREFIX).get(0));
        }
        return extLang;
    }

    protected Subtag processLanguageRecord(Record record) {
        assert (record.fields.containsKey(SUBTAG));
        LanguageSubtag language = new LanguageSubtag(record.fields.get(SUBTAG));
        this.addCommonFieldsToSubtag(language, record);
        language.setScope(record.fields.get(SCOPE));
        language.setPreferredValue(record.fields.get(PREFERRED_VALUE));
        language.setSuppressScript(record.fields.get(SUPPRESS_SCRIPT));
        language.setMacrolanguage(record.fields.get(MACROLANGUAGE));
        return language;
    }

    private void addCommonFieldsToSubtag(Subtag subtag, Record record) {
        if (record.multiFields.containsKey(DESCRIPTION)) {
            for (String description : record.multiFields.get(DESCRIPTION)) {
                subtag.addDescription(description);
            }
        }
        if (record.multiFields.containsKey(COMMENTS)) {
            for (String comment : record.multiFields.get(COMMENTS)) {
                subtag.addComments(comment);
            }
        }
        subtag.setAdded(record.fields.get(ADDED));
        subtag.setDeprecated(record.fields.get(DEPRECATED));
    }

    public LanguageSubtagRegistry getRegistry() {
        return this.registry;
    }

    public LanguageSubtagRegistryLoader withLoadLanguages(boolean loadLanguages) {
        return this.loadLanguages == loadLanguages ? this : new LanguageSubtagRegistryLoader(this.registry, loadLanguages, this.loadScripts, this.loadExtLangs, this.loadRegions, this.loadVariants);
    }

    public LanguageSubtagRegistryLoader withLoadScripts(boolean loadScripts) {
        return this.loadScripts == loadScripts ? this : new LanguageSubtagRegistryLoader(this.registry, this.loadLanguages, loadScripts, this.loadExtLangs, this.loadRegions, this.loadVariants);
    }

    public LanguageSubtagRegistryLoader withLoadExtLangs(boolean loadExtLangs) {
        return this.loadExtLangs == loadExtLangs ? this : new LanguageSubtagRegistryLoader(this.registry, this.loadLanguages, this.loadScripts, loadExtLangs, this.loadRegions, this.loadVariants);
    }

    public LanguageSubtagRegistryLoader withLoadRegions(boolean loadRegions) {
        return this.loadRegions == loadRegions ? this : new LanguageSubtagRegistryLoader(this.registry, this.loadLanguages, this.loadScripts, this.loadExtLangs, loadRegions, this.loadVariants);
    }

    public LanguageSubtagRegistryLoader withLoadVariants(boolean loadVariants) {
        return this.loadVariants == loadVariants ? this : new LanguageSubtagRegistryLoader(this.registry, this.loadLanguages, this.loadScripts, this.loadExtLangs, this.loadRegions, loadVariants);
    }

    public static class Record {
        final Map<String, String> fields = new HashMap<String, String>();
        final Map<String, List<String>> multiFields = new HashMap<String, List<String>>();

        public void addField(String field, String value) {
            if (LanguageSubtagRegistryLoader.isMultiField(field)) {
                List<String> list = this.multiFields.get(field);
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(value);
                this.multiFields.put(field, list);
            } else {
                this.fields.put(field, value);
            }
        }
    }
}

