/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.settings;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.settings.FhirSettingsPOJO;
import org.hl7.fhir.utilities.settings.ServerDetailsPOJO;

public class FhirSettings {
    public static final String FHIR_SETTINGS_PATH = "fhir.settings.path";
    private static String explicitFilePath = null;
    private static Boolean prohibitNetworkAccess;
    private final FhirSettingsPOJO fhirSettings;
    final String filePath;
    private static FhirSettings instance;

    public static void setExplicitFilePath(String explicitFilePath) {
        if (instance != null) {
            throw new IllegalStateException("Attempted to set explicitFilePath after FhirSettings has already been initialized with path: " + FhirSettings.instance.filePath);
        }
        if (FhirSettings.explicitFilePath != null) {
            throw new IllegalStateException("Attempted to set explicitFilePath to " + explicitFilePath + " when already set to " + FhirSettings.explicitFilePath);
        }
        FhirSettings.explicitFilePath = explicitFilePath;
    }

    public static String getFilePath() {
        FhirSettings.getInstance();
        return FhirSettings.instance.filePath;
    }

    private FhirSettings(FhirSettingsPOJO fhirSettings, String filePath) {
        this.fhirSettings = fhirSettings;
        this.filePath = filePath;
    }

    public static String getApiKey(String key) {
        FhirSettings.getInstance();
        return FhirSettings.instance.fhirSettings.getApiKeys() != null ? FhirSettings.instance.fhirSettings.getApiKeys().get(key) : null;
    }

    public static boolean hasApiKey(String key) {
        FhirSettings.getInstance();
        return FhirSettings.instance.fhirSettings.getApiKeys() != null ? FhirSettings.instance.fhirSettings.getApiKeys().get(key) != null : false;
    }

    public static String getNpmPath() {
        FhirSettings.getInstance();
        return FhirSettings.instance.fhirSettings.getNpmPath();
    }

    public static boolean hasNpmPath() {
        FhirSettings.getInstance();
        return FhirSettings.instance.fhirSettings.getNpmPath() != null;
    }

    public static boolean hasRubyPath() {
        FhirSettings.getInstance();
        return FhirSettings.instance.fhirSettings.getRubyPath() != null;
    }

    public static String getRubyPath() {
        FhirSettings.getInstance();
        return FhirSettings.instance.fhirSettings.getRubyPath();
    }

    public static boolean hasFhirTestCasesPath() {
        FhirSettings.getInstance();
        return FhirSettings.instance.fhirSettings.getFhirTestCasesPath() != null;
    }

    public static String getFhirTestCasesPath() {
        FhirSettings.getInstance();
        return FhirSettings.instance.fhirSettings.getFhirTestCasesPath();
    }

    public static boolean hasDiffToolPath() {
        FhirSettings.getInstance();
        return FhirSettings.instance.fhirSettings.getDiffToolPath() != null;
    }

    public static String getDiffToolPath() {
        FhirSettings.getInstance();
        return FhirSettings.instance.fhirSettings.getDiffToolPath();
    }

    public static boolean hasTempPath() {
        FhirSettings.getInstance();
        return FhirSettings.instance.fhirSettings.getTempPath() != null;
    }

    public static String getTempPath() {
        FhirSettings.getInstance();
        return FhirSettings.instance.fhirSettings.getTempPath();
    }

    public static boolean hasTestIGsPath() {
        FhirSettings.getInstance();
        return FhirSettings.instance.fhirSettings.getTestIgsPath() != null;
    }

    public static String getTestIgsPath() {
        FhirSettings.getInstance();
        return FhirSettings.instance.fhirSettings.getTestIgsPath();
    }

    public static boolean hasProhibitNetworkAccess() {
        if (prohibitNetworkAccess != null) {
            return true;
        }
        FhirSettings.getInstance();
        return FhirSettings.instance.fhirSettings.getProhibitNetworkAccess() != null;
    }

    public static boolean isProhibitNetworkAccess() {
        if (prohibitNetworkAccess != null) {
            return prohibitNetworkAccess;
        }
        FhirSettings.getInstance();
        return FhirSettings.instance.fhirSettings.getProhibitNetworkAccess() == null ? false : FhirSettings.instance.fhirSettings.getProhibitNetworkAccess();
    }

    @Deprecated
    public static void setProhibitNetworkAccess(boolean value) {
        prohibitNetworkAccess = value;
    }

    public static String getTxFhirProduction() {
        FhirSettings.getInstance();
        return FhirSettings.instance.fhirSettings.getTxFhirProduction() == null ? "http://tx.fhir.org" : FhirSettings.instance.fhirSettings.getTxFhirProduction();
    }

    public static String getTxFhirDevelopment() {
        FhirSettings.getInstance();
        return FhirSettings.instance.fhirSettings.getTxFhirDevelopment() == null ? "http://tx-dev.fhir.org" : FhirSettings.instance.fhirSettings.getTxFhirDevelopment();
    }

    public static String getTxFhirLocal() {
        FhirSettings.getInstance();
        return FhirSettings.instance.fhirSettings.getTxFhirLocal() == null ? "http://local.fhir.org" : FhirSettings.instance.fhirSettings.getTxFhirLocal();
    }

    private static FhirSettings getInstance() {
        if (instance == null) {
            try {
                instance = FhirSettings.getInstanceFromPath(explicitFilePath);
            }
            catch (IOException e) {
                e.printStackTrace();
                instance = new FhirSettings(new FhirSettingsPOJO(), null);
            }
        }
        return instance;
    }

    protected static FhirSettings getInstanceFromPath(String explicitFilePath) throws IOException {
        String filePath = FhirSettings.getSettingsFilePath(explicitFilePath);
        return new FhirSettings(FhirSettings.getFhirSettingsPOJO(filePath), filePath);
    }

    protected static String getSettingsFilePath(String explicitFilePath) {
        String pathFromSystemProperties;
        try {
            pathFromSystemProperties = FhirSettings.getDefaultSettingsPath();
        }
        catch (IOException e) {
            pathFromSystemProperties = null;
        }
        String filePath = explicitFilePath != null ? explicitFilePath : System.getProperty(FHIR_SETTINGS_PATH, pathFromSystemProperties);
        return filePath;
    }

    static FhirSettingsPOJO getFhirSettingsPOJO(String filePath) throws IOException {
        File file = ManagedFileAccess.file(filePath);
        if (!file.exists()) {
            return new FhirSettingsPOJO();
        }
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        FileInputStream inputStream = ManagedFileAccess.inStream(file);
        FhirSettingsPOJO output = (FhirSettingsPOJO)objectMapper.readValue((InputStream)inputStream, FhirSettingsPOJO.class);
        return output;
    }

    protected static String getDefaultSettingsPath() throws IOException {
        return Utilities.path(System.getProperty("user.home"), ".fhir", "fhir-settings.json");
    }

    public static boolean isIgnoreDefaultPackageServers() {
        FhirSettings.getInstance();
        if (FhirSettings.instance.fhirSettings.getPackageManagement() == null || FhirSettings.instance.fhirSettings.getPackageManagement().getIgnoreDefaultServers() == null) {
            return false;
        }
        return FhirSettings.instance.fhirSettings.getPackageManagement().getIgnoreDefaultServers();
    }

    public static List<ServerDetailsPOJO> getPackageServers() {
        FhirSettings.getInstance();
        if (FhirSettings.instance.fhirSettings.getPackageManagement() == null) {
            return Collections.emptyList();
        }
        return List.of(FhirSettings.instance.fhirSettings.getPackageManagement().getServers().toArray(new ServerDetailsPOJO[0]));
    }

    static {
        instance = null;
    }
}

