/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation;

import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_10_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_10_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_14_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_30_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_40_50;
import org.hl7.fhir.convertors.misc.IGR2ConvertorAdvisor5;
import org.hl7.fhir.dstu3.utils.StructureMapUtilities;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.formats.XmlParser;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.utilities.IniFile;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.json.JSONUtil;
import org.hl7.fhir.utilities.json.JsonTrackingParser;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.turtle.Turtle;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.hl7.fhir.validation.Content;
import org.hl7.fhir.validation.ResourceChecker;
import org.hl7.fhir.validation.ValidatorUtils;
import org.hl7.fhir.validation.cli.utils.Common;
import org.hl7.fhir.validation.cli.utils.VersionSourceInformation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IgLoader {
    private static final String[] IGNORED_EXTENSIONS = new String[]{"md", "css", "js", "png", "gif", "jpg", "html", "tgz", "pack", "zip"};
    private static final String[] EXEMPT_FILES = new String[]{"spec.internals", "version.info", "schematron.zip", "package.json"};
    private final FilesystemPackageCacheManager packageCacheManager;
    private final SimpleWorkerContext context;
    private final String version;
    private final boolean isDebug;

    public IgLoader(FilesystemPackageCacheManager packageCacheManager, SimpleWorkerContext context, String theVersion) {
        this(packageCacheManager, context, theVersion, false);
    }

    public IgLoader(FilesystemPackageCacheManager packageCacheManager, SimpleWorkerContext context, String theVersion, boolean isDebug) {
        this.packageCacheManager = packageCacheManager;
        this.context = context;
        this.version = theVersion;
        this.isDebug = isDebug;
    }

    public void loadIg(List<ImplementationGuide> igs, Map<String, byte[]> binaries, String src, boolean recursive) throws IOException, FHIRException {
        NpmPackage npm;
        NpmPackage npmPackage = npm = src.matches("^[A-Za-z][A-Za-z0-9\\_\\-]*(\\.[A-Za-z0-9\\_\\-]+)+(\\#[A-Za-z0-9\\-\\_]+(\\.[A-Za-z0-9\\-\\_]+)*)?$") && !new File(src).exists() ? this.getPackageCacheManager().loadPackage(src, null) : null;
        if (npm != null) {
            for (String s : npm.dependencies()) {
                if (this.getContext().getLoadedPackages().contains(s) || VersionUtilities.isCorePackage((String)s)) continue;
                this.loadIg(igs, binaries, s, false);
            }
            System.out.print("  Load " + src);
            if (!src.contains("#")) {
                System.out.print("#" + npm.version());
            }
            int count = this.getContext().loadFromPackage(npm, ValidatorUtils.loaderForVersion(npm.fhirVersion()));
            System.out.println(" - " + count + " resources (" + this.getContext().clock().milestone() + ")");
        } else {
            System.out.print("  Load " + src);
            String canonical = null;
            int count = 0;
            Map<String, byte[]> source = this.loadIgSource(src, recursive, true);
            String version = "4.6.0";
            if (this.getVersion() != null) {
                version = this.getVersion();
            }
            if (source.containsKey("version.info")) {
                version = this.readInfoVersion(source.get("version.info"));
            }
            for (Map.Entry<String, byte[]> t : source.entrySet()) {
                Resource r;
                String fn = t.getKey();
                if (this.exemptFile(fn) || (r = this.loadFileWithErrorChecking(version, t, fn)) == null) continue;
                ++count;
                this.getContext().cacheResource(r);
                if (!(r instanceof ImplementationGuide)) continue;
                canonical = ((ImplementationGuide)r).getUrl();
                igs.add((ImplementationGuide)r);
                if (!canonical.contains("/ImplementationGuide/")) continue;
                Resource r2 = r.copy();
                ((ImplementationGuide)r2).setUrl(canonical.substring(0, canonical.indexOf("/ImplementationGuide/")));
                this.getContext().cacheResource(r2);
            }
            if (canonical != null) {
                ValidatorUtils.grabNatives(binaries, source, canonical);
            }
            System.out.println(" - " + count + " resources (" + this.getContext().clock().milestone() + ")");
        }
    }

    public Content loadContent(String source, String opName, boolean asIg) throws FHIRException, IOException {
        Map<String, byte[]> s = this.loadIgSource(source, false, asIg);
        Content res = new Content();
        if (s.size() != 1) {
            throw new FHIRException("Unable to find resource " + source + " to " + opName);
        }
        for (Map.Entry<String, byte[]> t : s.entrySet()) {
            res.focus = t.getValue();
            if (t.getKey().endsWith(".json")) {
                res.cntType = Manager.FhirFormat.JSON;
                continue;
            }
            if (t.getKey().endsWith(".xml")) {
                res.cntType = Manager.FhirFormat.XML;
                continue;
            }
            if (t.getKey().endsWith(".ttl")) {
                res.cntType = Manager.FhirFormat.TURTLE;
                continue;
            }
            if (t.getKey().endsWith(".txt") || t.getKey().endsWith(".map")) {
                res.cntType = Manager.FhirFormat.TEXT;
                continue;
            }
            throw new FHIRException("Todo: Determining resource type is not yet done");
        }
        return res;
    }

    public Map<String, byte[]> loadIgSource(String src, boolean recursive, boolean explore) throws FHIRException, IOException {
        if (Common.isNetworkPath(src)) {
            String pid;
            String v = null;
            if (src.contains("|")) {
                v = src.substring(src.indexOf("|") + 1);
                src = src.substring(0, src.indexOf("|"));
            }
            String string = pid = explore ? this.getPackageCacheManager().getPackageId(src) : null;
            if (!Utilities.noString((String)pid)) {
                return this.fetchByPackage(pid + (v == null ? "" : "#" + v));
            }
            return this.fetchFromUrl(src + (v == null ? "" : "|" + v), explore);
        }
        File f = new File(Utilities.path((String[])new String[]{src}));
        if (f.exists()) {
            if (f.isDirectory() && new File(Utilities.path((String[])new String[]{src, "package.tgz"})).exists()) {
                return this.loadPackage(new FileInputStream(Utilities.path((String[])new String[]{src, "package.tgz"})), Utilities.path((String[])new String[]{src, "package.tgz"}));
            }
            if (f.isDirectory() && new File(Utilities.path((String[])new String[]{src, "igpack.zip"})).exists()) {
                return this.readZip(new FileInputStream(Utilities.path((String[])new String[]{src, "igpack.zip"})));
            }
            if (f.isDirectory() && new File(Utilities.path((String[])new String[]{src, "validator.pack"})).exists()) {
                return this.readZip(new FileInputStream(Utilities.path((String[])new String[]{src, "validator.pack"})));
            }
            if (f.isDirectory()) {
                return this.scanDirectory(f, recursive);
            }
            if (src.endsWith(".tgz")) {
                return this.loadPackage(new FileInputStream(src), src);
            }
            if (src.endsWith(".pack")) {
                return this.readZip(new FileInputStream(src));
            }
            if (src.endsWith("igpack.zip")) {
                return this.readZip(new FileInputStream(src));
            }
            Manager.FhirFormat fmt = ResourceChecker.checkIsResource(this.getContext(), this.isDebug(), src);
            if (fmt != null) {
                HashMap<String, byte[]> res = new HashMap<String, byte[]>();
                res.put(Utilities.changeFileExt((String)src, (String)("." + fmt.getExtension())), TextFile.fileToBytesNCS((String)src));
                return res;
            }
        } else if ((src.matches("^[a-zA-Z][A-Za-z0-9\\_\\-]*(\\.[A-Za-z0-9\\_\\-]+)+$") || src.matches("^[A-Za-z][A-Za-z0-9\\_\\-]*(\\.[A-Za-z0-9\\_\\-]+)+\\#[A-Za-z0-9\\-\\_]+(\\.[A-Za-z0-9\\-\\_]+)*$")) && !src.endsWith(".zip") && !src.endsWith(".tgz")) {
            return this.fetchByPackage(src);
        }
        throw new FHIRException("Unable to find/resolve/read " + (explore ? "-ig " : "") + src);
    }

    public void scanForIgVersion(String src, boolean recursive, VersionSourceInformation versions) throws Exception {
        Map<String, byte[]> source = this.loadIgSourceForVersion(src, recursive, true, versions);
        if (source != null && source.containsKey("version.info")) {
            versions.see(this.readInfoVersion(source.get("version.info")), "version.info in " + src);
        }
    }

    public void scanForVersions(List<String> sources, VersionSourceInformation versions) throws FHIRException, IOException {
        ArrayList<String> refs = new ArrayList<String>();
        ValidatorUtils.parseSources(sources, refs, this.context);
        for (String ref : refs) {
            Content cnt = this.loadContent(ref, "validate", false);
            String s = TextFile.bytesToString((byte[])cnt.focus);
            if (s.contains("http://hl7.org/fhir/3.0")) {
                versions.see("3.0", "Profile in " + ref);
            }
            if (s.contains("http://hl7.org/fhir/1.0")) {
                versions.see("1.0", "Profile in " + ref);
            }
            if (s.contains("http://hl7.org/fhir/4.0")) {
                versions.see("4.0", "Profile in " + ref);
            }
            if (s.contains("http://hl7.org/fhir/1.4")) {
                versions.see("1.4", "Profile in " + ref);
            }
            try {
                if (s.startsWith("{")) {
                    JsonObject json = JsonTrackingParser.parse((String)s, null);
                    if (!json.has("fhirVersion")) continue;
                    versions.see(VersionUtilities.getMajMin((String)JSONUtil.str((JsonObject)json, (String)"fhirVersion")), "fhirVersion in " + ref);
                    continue;
                }
                Document doc = ValidatorUtils.parseXml(cnt.focus);
                String v = XMLUtil.getNamedChildValue((Element)doc.getDocumentElement(), (String)"fhirVersion");
                if (v == null) continue;
                versions.see(VersionUtilities.getMajMin((String)v), "fhirVersion in " + ref);
            }
            catch (Exception exception) {}
        }
    }

    protected Map<String, byte[]> readZip(InputStream stream) throws IOException {
        ZipEntry ze;
        HashMap<String, byte[]> res = new HashMap<String, byte[]>();
        ZipInputStream zip = new ZipInputStream(stream);
        while ((ze = zip.getNextEntry()) != null) {
            int n;
            String name = ze.getName();
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((n = ((InputStream)zip).read(buf, 0, 1024)) > -1) {
                b.write(buf, 0, n);
            }
            res.put(name, b.toByteArray());
            zip.closeEntry();
        }
        zip.close();
        return res;
    }

    private String loadPackageForVersion(InputStream stream) throws FHIRException, IOException {
        return NpmPackage.fromPackage((InputStream)stream).fhirVersion();
    }

    private InputStream fetchFromUrlSpecific(String source, boolean optional) throws FHIRException, IOException {
        try {
            URL url = new URL(source + "?nocache=" + System.currentTimeMillis());
            URLConnection c = url.openConnection();
            return c.getInputStream();
        }
        catch (IOException e) {
            if (optional) {
                return null;
            }
            throw e;
        }
    }

    private Map<String, byte[]> loadIgSourceForVersion(String src, boolean recursive, boolean explore, VersionSourceInformation versions) throws FHIRException, IOException {
        if (Common.isNetworkPath(src)) {
            String pid;
            String v = null;
            if (src.contains("|")) {
                v = src.substring(src.indexOf("|") + 1);
                src = src.substring(0, src.indexOf("|"));
            }
            if (!Utilities.noString((String)(pid = this.getPackageCacheManager().getPackageId(src)))) {
                versions.see(this.fetchVersionByPackage(pid + (v == null ? "" : "#" + v)), "Package " + src);
                return null;
            }
            return this.fetchVersionFromUrl(src + (v == null ? "" : "|" + v), explore, versions);
        }
        File f = new File(Utilities.path((String[])new String[]{src}));
        if (f.exists()) {
            if (f.isDirectory() && new File(Utilities.path((String[])new String[]{src, "package.tgz"})).exists()) {
                versions.see(this.loadPackageForVersion(new FileInputStream(Utilities.path((String[])new String[]{src, "package.tgz"}))), "Package " + src);
                return null;
            }
            if (f.isDirectory() && new File(Utilities.path((String[])new String[]{src, "igpack.zip"})).exists()) {
                return this.readZip(new FileInputStream(Utilities.path((String[])new String[]{src, "igpack.zip"})));
            }
            if (f.isDirectory() && new File(Utilities.path((String[])new String[]{src, "validator.pack"})).exists()) {
                return this.readZip(new FileInputStream(Utilities.path((String[])new String[]{src, "validator.pack"})));
            }
            if (f.isDirectory()) {
                return this.scanDirectory(f, recursive);
            }
            if (src.endsWith(".tgz")) {
                versions.see(this.loadPackageForVersion(new FileInputStream(src)), "Package " + src);
                return null;
            }
            if (src.endsWith(".pack")) {
                return this.readZip(new FileInputStream(src));
            }
            if (src.endsWith("igpack.zip")) {
                return this.readZip(new FileInputStream(src));
            }
            Manager.FhirFormat fmt = ResourceChecker.checkIsResource(this.getContext(), this.isDebug(), src);
            if (fmt != null) {
                HashMap<String, byte[]> res = new HashMap<String, byte[]>();
                res.put(Utilities.changeFileExt((String)src, (String)("." + fmt.getExtension())), TextFile.fileToBytesNCS((String)src));
                return res;
            }
        } else if ((src.matches("^[a-zA-Z][A-Za-z0-9\\_\\-]*(\\.[A-Za-z0-9\\_\\-]+)+$") || src.matches("^[A-Za-z][A-Za-z0-9\\_\\-]*(\\.[A-Za-z0-9\\_\\-]+)+\\#[A-Za-z0-9\\-\\_]+(\\.[A-Za-z0-9\\-\\_]+)*$")) && !src.endsWith(".zip") && !src.endsWith(".tgz")) {
            versions.see(this.fetchVersionByPackage(src), "Package " + src);
            return null;
        }
        throw new FHIRException("Unable to find/resolve/read -ig " + src);
    }

    private Map<String, byte[]> fetchByPackage(String src) throws FHIRException, IOException {
        NpmPackage pi;
        String id = src;
        String version = null;
        if (src.contains("#")) {
            id = src.substring(0, src.indexOf("#"));
            version = src.substring(src.indexOf("#") + 1);
        }
        if (version == null) {
            version = this.getPackageCacheManager().getLatestVersion(id);
        }
        if (version == null) {
            pi = this.getPackageCacheManager().loadPackageFromCacheOnly(id);
            if (pi != null) {
                System.out.println("   ... Using version " + pi.version());
            }
        } else {
            pi = this.getPackageCacheManager().loadPackageFromCacheOnly(id, version);
        }
        if (pi == null) {
            return this.resolvePackage(id, version);
        }
        return this.loadPackage(pi);
    }

    private Map<String, byte[]> loadPackage(InputStream stream, String name) throws FHIRException, IOException {
        return this.loadPackage(NpmPackage.fromPackage((InputStream)stream));
    }

    public Map<String, byte[]> loadPackage(NpmPackage pi) throws FHIRException, IOException {
        this.getContext().getLoadedPackages().add(pi.name() + "#" + pi.version());
        HashMap<String, byte[]> res = new HashMap<String, byte[]>();
        for (String s : pi.dependencies()) {
            if (s.endsWith(".x") && s.length() > 2) {
                String packageMajorMinor = s.substring(0, s.length() - 2);
                boolean found = false;
                for (int i = 0; i < this.getContext().getLoadedPackages().size() && !found; ++i) {
                    String loadedPackage = (String)this.getContext().getLoadedPackages().get(i);
                    if (!loadedPackage.startsWith(packageMajorMinor)) continue;
                    found = true;
                }
                if (found) continue;
            }
            if (this.getContext().getLoadedPackages().contains(s) || VersionUtilities.isCorePackage((String)s)) continue;
            System.out.println("+  .. load IG from " + s);
            res.putAll(this.fetchByPackage(s));
        }
        for (String s : pi.listResources(new String[]{"CodeSystem", "ConceptMap", "ImplementationGuide", "CapabilityStatement", "SearchParameter", "Conformance", "StructureMap", "ValueSet", "StructureDefinition"})) {
            res.put(s, TextFile.streamToBytes((InputStream)pi.load("package", s)));
        }
        String ini = "[FHIR]\r\nversion=" + pi.fhirVersion() + "\r\n";
        res.put("version.info", ini.getBytes());
        return res;
    }

    private Map<String, byte[]> resolvePackage(String id, String v) throws FHIRException, IOException {
        NpmPackage pi = this.getPackageCacheManager().loadPackage(id, v);
        if (pi != null && v == null) {
            System.out.println("   ... Using version " + pi.version());
        }
        return this.loadPackage(pi);
    }

    private String readInfoVersion(byte[] bs) throws IOException {
        String is = TextFile.bytesToString((byte[])bs);
        is = is.trim();
        IniFile ini = new IniFile((InputStream)new ByteArrayInputStream(TextFile.stringToBytes((String)is, (boolean)false)));
        return ini.getStringProperty("FHIR", "version");
    }

    private byte[] fetchFromUrlSpecific(String source, String contentType, boolean optional, List<String> errors) throws FHIRException, IOException {
        try {
            try {
                URL url = new URL(source + "?nocache=" + System.currentTimeMillis());
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("Accept", contentType);
                return TextFile.streamToBytes((InputStream)conn.getInputStream());
            }
            catch (Exception e) {
                URL url = new URL(source);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("Accept", contentType);
                return TextFile.streamToBytes((InputStream)conn.getInputStream());
            }
        }
        catch (IOException e) {
            if (errors != null) {
                errors.add("Error accessing " + source + ": " + e.getMessage());
            }
            if (optional) {
                return null;
            }
            throw e;
        }
    }

    private Map<String, byte[]> fetchVersionFromUrl(String src, boolean explore, VersionSourceInformation versions) throws FHIRException, IOException {
        if (src.endsWith(".tgz")) {
            versions.see(this.loadPackageForVersion(this.fetchFromUrlSpecific(src, false)), "From Package " + src);
            return null;
        }
        if (src.endsWith(".pack")) {
            return this.readZip(this.fetchFromUrlSpecific(src, false));
        }
        if (src.endsWith("igpack.zip")) {
            return this.readZip(this.fetchFromUrlSpecific(src, false));
        }
        InputStream stream = null;
        if (explore) {
            stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{src, "package.tgz"}), true);
            if (stream != null) {
                versions.see(this.loadPackageForVersion(stream), "From Package at " + src);
                return null;
            }
            stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{src, "igpack.zip"}), true);
            if (stream != null) {
                return this.readZip(stream);
            }
            stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{src, "validator.pack"}), true);
            if (stream != null) {
                return this.readZip(stream);
            }
            stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{src, "validator.pack"}), true);
        }
        byte[] cnt = stream == null ? this.fetchFromUrlSpecific(src, "application/json", true, null) : TextFile.streamToBytes(stream);
        Manager.FhirFormat fmt = ResourceChecker.checkIsResource(this.getContext(), this.isDebug(), cnt, src);
        if (fmt != null) {
            HashMap<String, byte[]> res = new HashMap<String, byte[]>();
            res.put(Utilities.changeFileExt((String)src, (String)("." + fmt.getExtension())), cnt);
            return res;
        }
        String fn = Utilities.path((String[])new String[]{"[tmp]", "fetch-resource-error-content.bin"});
        TextFile.bytesToFile((byte[])cnt, (String)fn);
        System.out.println("Error Fetching " + src);
        System.out.println("Some content was found, saved to " + fn);
        System.out.println("1st 100 bytes = " + this.presentForDebugging(cnt));
        throw new FHIRException("Unable to find/resolve/read " + (explore ? "-ig " : "") + src);
    }

    private String fetchVersionByPackage(String src) throws FHIRException, IOException {
        String id = src;
        String version = null;
        if (src.contains("#")) {
            id = src.substring(0, src.indexOf("#"));
            version = src.substring(src.indexOf("#") + 1);
        }
        if (version == null) {
            version = this.getPackageCacheManager().getLatestVersion(id);
        }
        NpmPackage pi = null;
        if (version == null) {
            pi = this.getPackageCacheManager().loadPackageFromCacheOnly(id);
            if (pi != null) {
                System.out.println("   ... Using version " + pi.version());
            }
        } else {
            pi = this.getPackageCacheManager().loadPackageFromCacheOnly(id, version);
        }
        if (pi == null) {
            return this.resolvePackageForVersion(id, version);
        }
        return pi.fhirVersion();
    }

    private Map<String, byte[]> fetchFromUrl(String src, boolean explore) throws FHIRException, IOException {
        byte[] cnt;
        if (src.endsWith(".tgz")) {
            return this.loadPackage(this.fetchFromUrlSpecific(src, false), src);
        }
        if (src.endsWith(".pack")) {
            return this.readZip(this.fetchFromUrlSpecific(src, false));
        }
        if (src.endsWith("igpack.zip")) {
            return this.readZip(this.fetchFromUrlSpecific(src, false));
        }
        InputStream stream = null;
        if (explore) {
            stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{src, "package.tgz"}), true);
            if (stream != null) {
                return this.loadPackage(stream, Utilities.pathURL((String[])new String[]{src, "package.tgz"}));
            }
            stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{src, "igpack.zip"}), true);
            if (stream != null) {
                return this.readZip(stream);
            }
            stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{src, "validator.pack"}), true);
            if (stream != null) {
                return this.readZip(stream);
            }
            stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{src, "validator.pack"}), true);
        }
        ArrayList<String> errors = new ArrayList<String>();
        if (stream != null) {
            cnt = TextFile.streamToBytes(stream);
        } else {
            cnt = this.fetchFromUrlSpecific(src, "application/json", true, errors);
            if (cnt == null) {
                cnt = this.fetchFromUrlSpecific(src, "application/xml", true, errors);
            }
        }
        if (cnt == null) {
            throw new FHIRException("Unable to fetch content from " + src + " (" + ((Object)errors).toString() + ")");
        }
        Manager.FhirFormat fmt = this.checkFormat(cnt, src);
        if (fmt != null) {
            HashMap<String, byte[]> res = new HashMap<String, byte[]>();
            res.put(Utilities.changeFileExt((String)src, (String)("." + fmt.getExtension())), cnt);
            return res;
        }
        throw new FHIRException("Unable to read content from " + src + ": cannot determine format");
    }

    private boolean isIgnoreFile(File ff) {
        if (ff.getName().startsWith(".") || ff.getAbsolutePath().contains(".git")) {
            return true;
        }
        return Utilities.existsInList((String)Utilities.getFileExtension((String)ff.getName()).toLowerCase(), (String[])IGNORED_EXTENSIONS);
    }

    private Map<String, byte[]> scanDirectory(File f, boolean recursive) throws IOException {
        HashMap<String, byte[]> res = new HashMap<String, byte[]>();
        for (File ff : f.listFiles()) {
            Manager.FhirFormat fmt;
            if (ff.isDirectory() && recursive) {
                res.putAll(this.scanDirectory(ff, true));
                continue;
            }
            if (ff.isDirectory() || this.isIgnoreFile(ff) || (fmt = ResourceChecker.checkIsResource(this.getContext(), this.isDebug(), ff.getAbsolutePath())) == null) continue;
            res.put(Utilities.changeFileExt((String)ff.getName(), (String)("." + fmt.getExtension())), TextFile.fileToBytes((String)ff.getAbsolutePath()));
        }
        return res;
    }

    private String resolvePackageForVersion(String id, String v) throws FHIRException, IOException {
        NpmPackage pi = this.getPackageCacheManager().loadPackage(id, v);
        return pi.fhirVersion();
    }

    private String presentForDebugging(byte[] cnt) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < Integer.min(cnt.length, 50); ++i) {
            b.append(Integer.toHexString(cnt[i]));
        }
        return b.toString();
    }

    private Manager.FhirFormat checkFormat(byte[] cnt, String filename) {
        System.out.println("   ..Detect format for " + filename);
        try {
            JsonTrackingParser.parseJson((byte[])cnt);
            return Manager.FhirFormat.JSON;
        }
        catch (Exception e) {
            this.log("Not JSON: " + e.getMessage());
            try {
                ValidatorUtils.parseXml(cnt);
                return Manager.FhirFormat.XML;
            }
            catch (Exception e2) {
                this.log("Not XML: " + e2.getMessage());
                try {
                    new Turtle().parse(TextFile.bytesToString((byte[])cnt));
                    return Manager.FhirFormat.TURTLE;
                }
                catch (Exception e3) {
                    this.log("Not Turtle: " + e3.getMessage());
                    try {
                        new org.hl7.fhir.r5.utils.structuremap.StructureMapUtilities((IWorkerContext)this.getContext(), null, null).parse(TextFile.bytesToString((byte[])cnt), null);
                        return Manager.FhirFormat.TEXT;
                    }
                    catch (Exception e4) {
                        this.log("Not Text: " + e4.getMessage());
                        this.log("     .. not a resource: " + filename);
                        return null;
                    }
                }
            }
        }
    }

    private boolean exemptFile(String fn) {
        return Utilities.existsInList((String)fn, (String[])EXEMPT_FILES);
    }

    private Resource loadFileWithErrorChecking(String version, Map.Entry<String, byte[]> t, String fn) {
        Resource r;
        block3: {
            this.log("* load file: " + fn);
            r = null;
            try {
                r = this.loadResourceByVersion(version, t.getValue(), fn);
                this.log(" .. success");
            }
            catch (Exception e) {
                if (!this.isDebug()) {
                    System.out.print("* load file: " + fn);
                }
                System.out.println(" - ignored due to error: " + (e.getMessage() == null ? " (null - NPE)" : e.getMessage()));
                if (!this.isDebug() && (e.getMessage() == null || !e.getMessage().contains("cannot be cast"))) break block3;
                e.printStackTrace();
            }
        }
        return r;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Resource loadResourceByVersion(String fhirVersion, byte[] content, String fn) throws IOException, FHIRException {
        if (fhirVersion.startsWith("3.0")) {
            org.hl7.fhir.dstu3.model.Resource res;
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                res = new org.hl7.fhir.dstu3.formats.XmlParser().parse((InputStream)new ByteArrayInputStream(content));
                return VersionConvertorFactory_30_50.convertResource((org.hl7.fhir.dstu3.model.Resource)res);
            } else if (fn.endsWith(".json") && !fn.endsWith("template.json")) {
                res = new org.hl7.fhir.dstu3.formats.JsonParser().parse((InputStream)new ByteArrayInputStream(content));
                return VersionConvertorFactory_30_50.convertResource((org.hl7.fhir.dstu3.model.Resource)res);
            } else {
                if (!fn.endsWith(".txt")) {
                    if (!fn.endsWith(".map")) throw new FHIRException("Unsupported format for " + fn);
                }
                res = new StructureMapUtilities(null).parse(new String(content));
            }
            return VersionConvertorFactory_30_50.convertResource((org.hl7.fhir.dstu3.model.Resource)res);
        }
        if (fhirVersion.startsWith("4.0")) {
            org.hl7.fhir.r4.model.Resource res;
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                res = new XmlParser().parse((InputStream)new ByteArrayInputStream(content));
                return VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)res);
            } else if (fn.endsWith(".json") && !fn.endsWith("template.json")) {
                res = new org.hl7.fhir.r4.formats.JsonParser().parse((InputStream)new ByteArrayInputStream(content));
                return VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)res);
            } else {
                if (!fn.endsWith(".txt")) {
                    if (!fn.endsWith(".map")) throw new FHIRException("Unsupported format for " + fn);
                }
                res = new org.hl7.fhir.r4.utils.StructureMapUtilities(null).parse(new String(content), fn);
            }
            return VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)res);
        }
        if (fhirVersion.startsWith("1.4")) {
            org.hl7.fhir.dstu2016may.model.Resource res;
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                res = new org.hl7.fhir.dstu2016may.formats.XmlParser().parse((InputStream)new ByteArrayInputStream(content));
                return VersionConvertorFactory_14_50.convertResource((org.hl7.fhir.dstu2016may.model.Resource)res);
            } else {
                if (!fn.endsWith(".json")) throw new FHIRException("Unsupported format for " + fn);
                if (fn.endsWith("template.json")) throw new FHIRException("Unsupported format for " + fn);
                res = new org.hl7.fhir.dstu2016may.formats.JsonParser().parse((InputStream)new ByteArrayInputStream(content));
            }
            return VersionConvertorFactory_14_50.convertResource((org.hl7.fhir.dstu2016may.model.Resource)res);
        }
        if (fhirVersion.startsWith("1.0")) {
            org.hl7.fhir.dstu2.model.Resource res;
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                res = new org.hl7.fhir.dstu2.formats.JsonParser().parse((InputStream)new ByteArrayInputStream(content));
                return VersionConvertorFactory_10_50.convertResource((org.hl7.fhir.dstu2.model.Resource)res, (BaseAdvisor_10_50)new IGR2ConvertorAdvisor5());
            } else {
                if (!fn.endsWith(".json")) throw new FHIRException("Unsupported format for " + fn);
                if (fn.endsWith("template.json")) throw new FHIRException("Unsupported format for " + fn);
                res = new org.hl7.fhir.dstu2.formats.JsonParser().parse((InputStream)new ByteArrayInputStream(content));
            }
            return VersionConvertorFactory_10_50.convertResource((org.hl7.fhir.dstu2.model.Resource)res, (BaseAdvisor_10_50)new IGR2ConvertorAdvisor5());
        }
        if (!fhirVersion.equals("4.6.0")) {
            if (!"current".equals(fhirVersion)) throw new FHIRException("Unsupported version " + fhirVersion);
        }
        if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
            return new org.hl7.fhir.r5.formats.XmlParser().parse((InputStream)new ByteArrayInputStream(content));
        }
        if (fn.endsWith(".json") && !fn.endsWith("template.json")) {
            return new JsonParser().parse((InputStream)new ByteArrayInputStream(content));
        }
        if (fn.endsWith(".txt")) {
            return new org.hl7.fhir.r5.utils.structuremap.StructureMapUtilities((IWorkerContext)this.getContext(), null, null).parse(TextFile.bytesToString((byte[])content), fn);
        }
        if (!fn.endsWith(".map")) throw new FHIRException("Unsupported format for " + fn);
        return new org.hl7.fhir.r5.utils.structuremap.StructureMapUtilities(null).parse(new String(content), fn);
    }

    private void log(String s) {
        if (this.isDebug()) {
            System.out.println(s);
        }
    }

    public FilesystemPackageCacheManager getPackageCacheManager() {
        return this.packageCacheManager;
    }

    public SimpleWorkerContext getContext() {
        return this.context;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isDebug() {
        return this.isDebug;
    }
}

