/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_10_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_14_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_30_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.FhirPublication;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.ValueSetUtilities;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.r5.utils.validation.ValidationContextCarrier;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.TimeTracker;
import org.hl7.fhir.validation.instance.utils.IndexedElement;

public class BaseValidator
implements ValidationContextCarrier.IValidationContextResourceLoader {
    protected final String META = "meta";
    protected final String ENTRY = "entry";
    protected final String LINK = "link";
    protected final String DOCUMENT = "document";
    protected final String RESOURCE = "resource";
    protected final String MESSAGE = "message";
    protected final String SEARCHSET = "searchset";
    protected final String ID = "id";
    protected final String FULL_URL = "fullUrl";
    protected final String PATH_ARG = ":0";
    protected final String TYPE = "type";
    protected final String BUNDLE = "Bundle";
    protected final String LAST_UPDATED = "lastUpdated";
    protected ValidationMessage.Source source;
    protected IWorkerContext context;
    protected TimeTracker timeTracker = new TimeTracker();
    protected XVerExtensionManager xverManager;
    protected List<TrackedLocationRelatedMessage> trackedMessages = new ArrayList<TrackedLocationRelatedMessage>();
    protected List<ValidationMessage> messagesToRemove = new ArrayList<ValidationMessage>();
    private Map<String, ValidationControl> validationControl = new HashMap<String, ValidationControl>();

    public BaseValidator(IWorkerContext context, XVerExtensionManager xverManager) {
        this.context = context;
        this.xverManager = xverManager;
        if (this.xverManager == null) {
            this.xverManager = new XVerExtensionManager(context);
        }
    }

    @Deprecated
    protected boolean fail(List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String msg) {
        if (!thePass) {
            this.addValidationMessage(errors, type, line, col, path, msg, ValidationMessage.IssueSeverity.FATAL, null);
        }
        return thePass;
    }

    protected boolean fail(List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String msg = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, type, line, col, path, msg, ValidationMessage.IssueSeverity.FATAL, theMessage);
        }
        return thePass;
    }

    @Deprecated
    protected boolean fail(List<ValidationMessage> errors, ValidationMessage.IssueType type, List<String> pathParts, boolean thePass, String msg) {
        if (!thePass) {
            String path = this.toPath(pathParts);
            this.addValidationMessage(errors, type, -1, -1, path, msg, ValidationMessage.IssueSeverity.FATAL, null);
        }
        return thePass;
    }

    @Deprecated
    protected boolean fail(List<ValidationMessage> errors, ValidationMessage.IssueType type, List<String> pathParts, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String path = this.toPath(pathParts);
            this.addValidationMessage(errors, type, -1, -1, path, this.context.formatMessage(theMessage, theMessageArguments), ValidationMessage.IssueSeverity.FATAL, theMessage);
        }
        return thePass;
    }

    @Deprecated
    protected boolean fail(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg) {
        if (!thePass) {
            this.addValidationMessage(errors, type, -1, -1, path, msg, ValidationMessage.IssueSeverity.FATAL, null);
        }
        return thePass;
    }

    protected boolean grammarWord(String w) {
        return w.equals("and") || w.equals("or") || w.equals("a") || w.equals("the") || w.equals("for") || w.equals("this") || w.equals("that") || w.equals("of");
    }

    protected boolean hint(List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String msg) {
        if (!thePass) {
            String message = this.context.formatMessage(msg, new Object[0]);
            this.addValidationMessage(errors, type, line, col, path, message, ValidationMessage.IssueSeverity.INFORMATION, msg);
        }
        return thePass;
    }

    protected boolean slicingHint(List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, boolean isCritical, String msg, String html, String[] text) {
        if (!thePass) {
            this.addValidationMessage(errors, type, line, col, path, msg, ValidationMessage.IssueSeverity.INFORMATION, null).setSlicingHint(true).setSliceHtml(html, text).setCriticalSignpost(isCritical);
        }
        return thePass;
    }

    protected boolean hint(List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, type, line, col, path, message, ValidationMessage.IssueSeverity.INFORMATION, theMessage);
        }
        return thePass;
    }

    protected ValidationMessage signpost(List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, String theMessage, Object ... theMessageArguments) {
        String message = this.context.formatMessage(theMessage, theMessageArguments);
        return this.addValidationMessage(errors, type, line, col, path, message, ValidationMessage.IssueSeverity.INFORMATION, theMessage).setSignpost(true);
    }

    protected boolean txHint(List<ValidationMessage> errors, String txLink, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, type, line, col, path, message, ValidationMessage.IssueSeverity.INFORMATION, ValidationMessage.Source.TerminologyEngine, theMessage).setTxLink(txLink);
        }
        return thePass;
    }

    protected boolean hint(List<ValidationMessage> errors, ValidationMessage.IssueType type, List<String> pathParts, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String path = this.toPath(pathParts);
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, type, -1, -1, path, message, ValidationMessage.IssueSeverity.INFORMATION, theMessage);
        }
        return thePass;
    }

    protected boolean hint(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, type, -1, -1, path, message, ValidationMessage.IssueSeverity.INFORMATION, null);
        }
        return thePass;
    }

    protected boolean rule(List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, type, line, col, path, message, ValidationMessage.IssueSeverity.ERROR, theMessage);
        }
        return thePass;
    }

    protected boolean txRule(List<ValidationMessage> errors, String txLink, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String theMessage, Object ... theMessageArguments) {
        String message;
        ValidationMessage vm;
        if (!thePass && this.checkMsgId(theMessage, vm = new ValidationMessage(ValidationMessage.Source.TerminologyEngine, type, line, col, path, message = this.context.formatMessage(theMessage, theMessageArguments), ValidationMessage.IssueSeverity.ERROR).setMessageId(theMessage))) {
            errors.add(vm.setTxLink(txLink));
        }
        return thePass;
    }

    protected boolean rule(List<ValidationMessage> errors, ValidationMessage.IssueType type, List<String> pathParts, boolean thePass, String msg) {
        if (!thePass) {
            String path = this.toPath(pathParts);
            this.addValidationMessage(errors, type, -1, -1, path, msg, ValidationMessage.IssueSeverity.ERROR, null);
        }
        return thePass;
    }

    protected boolean rule(List<ValidationMessage> errors, ValidationMessage.IssueType type, List<String> pathParts, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String path = this.toPath(pathParts);
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, type, -1, -1, path, message, ValidationMessage.IssueSeverity.ERROR, theMessage);
        }
        return thePass;
    }

    protected boolean rule(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, type, -1, -1, path, message, ValidationMessage.IssueSeverity.ERROR, theMessage);
        }
        return thePass;
    }

    public boolean rule(List<ValidationMessage> errors, ValidationMessage.Source source, ValidationMessage.IssueType type, String path, boolean thePass, String msg) {
        if (!thePass) {
            this.addValidationMessage(errors, type, -1, -1, path, msg, ValidationMessage.IssueSeverity.ERROR, source, null);
        }
        return thePass;
    }

    protected boolean ruleHtml(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg, String html) {
        if (!thePass) {
            msg = this.context.formatMessage(msg, null);
            html = this.context.formatMessage(html, null);
            this.addValidationMessage(errors, type, path, msg, html, ValidationMessage.IssueSeverity.ERROR, null);
        }
        return thePass;
    }

    protected String splitByCamelCase(String s) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isUpperCase(c) && i != 0 && !Character.isUpperCase(s.charAt(i - 1))) {
                b.append(' ');
            }
            b.append(c);
        }
        return b.toString();
    }

    protected String stripPunctuation(String s, boolean numbers) {
        StringBuilder b = new StringBuilder();
        for (char c : s.toCharArray()) {
            int t = Character.getType(c);
            if (!(t == 1 || t == 2 || t == 3 || t == 4 || t == 5 || t == 9 && numbers || t == 10 && numbers) && c != ' ') continue;
            b.append(c);
        }
        return b.toString();
    }

    private String toPath(List<String> pathParts) {
        if (pathParts == null || pathParts.isEmpty()) {
            return "";
        }
        return "//" + StringUtils.join(pathParts, (char)'/');
    }

    protected boolean warning(List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String msg, Object ... theMessageArguments) {
        if (!thePass) {
            String nmsg = this.context.formatMessage(msg, theMessageArguments);
            ValidationMessage.IssueSeverity severity = ValidationMessage.IssueSeverity.WARNING;
            this.addValidationMessage(errors, type, line, col, path, nmsg, severity, msg);
        }
        return thePass;
    }

    protected ValidationMessage addValidationMessage(List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, String msg, ValidationMessage.IssueSeverity theSeverity, String id) {
        ValidationMessage.Source source = this.source;
        return this.addValidationMessage(errors, type, line, col, path, msg, theSeverity, source, id);
    }

    protected ValidationMessage addValidationMessage(List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, String msg, ValidationMessage.IssueSeverity theSeverity, ValidationMessage.Source theSource, String id) {
        ValidationMessage validationMessage = new ValidationMessage(theSource, type, line, col, path, msg, theSeverity).setMessageId(id);
        if (this.checkMsgId(id, validationMessage)) {
            errors.add(validationMessage);
        }
        return validationMessage;
    }

    public boolean checkMsgId(String id, ValidationMessage vm) {
        if (id != null && this.validationControl.containsKey(id)) {
            ValidationControl control = this.validationControl.get(id);
            if (control.level != null) {
                vm.setLevel(control.level);
            }
            return control.isAllowed();
        }
        return true;
    }

    protected boolean txWarning(List<ValidationMessage> errors, String txLink, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String msg, Object ... theMessageArguments) {
        String nmsg;
        ValidationMessage vmsg;
        if (!thePass && this.checkMsgId(msg, vmsg = new ValidationMessage(ValidationMessage.Source.TerminologyEngine, type, line, col, path, nmsg = this.context.formatMessage(msg, theMessageArguments), ValidationMessage.IssueSeverity.WARNING).setTxLink(txLink).setMessageId(msg))) {
            errors.add(vmsg);
        }
        return thePass;
    }

    protected boolean txWarningForLaterRemoval(Object location, List<ValidationMessage> errors, String txLink, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String msg, Object ... theMessageArguments) {
        if (!thePass) {
            String nmsg = this.context.formatMessage(msg, theMessageArguments);
            ValidationMessage vmsg = new ValidationMessage(ValidationMessage.Source.TerminologyEngine, type, line, col, path, nmsg, ValidationMessage.IssueSeverity.WARNING).setTxLink(txLink).setMessageId(msg);
            if (this.checkMsgId(msg, vmsg)) {
                errors.add(vmsg);
            }
            this.trackedMessages.add(new TrackedLocationRelatedMessage(location, vmsg));
        }
        return thePass;
    }

    protected void removeTrackedMessagesForLocation(List<ValidationMessage> errors, Object location, String path) {
        ArrayList<TrackedLocationRelatedMessage> messages = new ArrayList<TrackedLocationRelatedMessage>();
        for (TrackedLocationRelatedMessage m : this.trackedMessages) {
            if (m.getLocation() != location) continue;
            messages.add(m);
            this.messagesToRemove.add(m.getVmsg());
        }
        this.trackedMessages.removeAll(messages);
    }

    protected boolean warningOrError(boolean isError, List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String msg, Object ... theMessageArguments) {
        if (!thePass) {
            String nmsg = this.context.formatMessage(msg, theMessageArguments);
            this.addValidationMessage(errors, type, line, col, path, nmsg, isError ? ValidationMessage.IssueSeverity.ERROR : ValidationMessage.IssueSeverity.WARNING, msg);
        }
        return thePass;
    }

    protected boolean warning(List<ValidationMessage> errors, ValidationMessage.IssueType type, List<String> pathParts, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String path = this.toPath(pathParts);
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, type, -1, -1, path, message, ValidationMessage.IssueSeverity.WARNING, theMessage);
        }
        return thePass;
    }

    protected boolean warning(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg, Object ... theMessageArguments) {
        if (!thePass) {
            String message = this.context.formatMessage(msg, theMessageArguments);
            this.addValidationMessage(errors, type, -1, -1, path, message, ValidationMessage.IssueSeverity.WARNING, null);
        }
        return thePass;
    }

    protected boolean warningOrHint(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, boolean warning, String msg, Object ... theMessageArguments) {
        if (!thePass) {
            String message = this.context.formatMessage(msg, theMessageArguments);
            this.addValidationMessage(errors, type, -1, -1, path, message, warning ? ValidationMessage.IssueSeverity.WARNING : ValidationMessage.IssueSeverity.INFORMATION, null);
        }
        return thePass;
    }

    protected boolean warningHtml(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg, String html) {
        if (!thePass) {
            this.addValidationMessage(errors, type, path, msg, html, ValidationMessage.IssueSeverity.WARNING, null);
        }
        return thePass;
    }

    protected boolean warningHtml(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg, String html, Object ... theMessageArguments) {
        if (!thePass) {
            String nmsg = this.context.formatMessage(msg, theMessageArguments);
            this.addValidationMessage(errors, type, path, nmsg, html, ValidationMessage.IssueSeverity.WARNING, msg);
        }
        return thePass;
    }

    protected boolean suppressedwarning(List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String msg, Object ... theMessageArguments) {
        if (!thePass) {
            String nmsg = this.context.formatMessage(msg, theMessageArguments);
            this.addValidationMessage(errors, type, line, col, path, nmsg, ValidationMessage.IssueSeverity.INFORMATION, msg);
        }
        return thePass;
    }

    protected boolean suppressedwarning(List<ValidationMessage> errors, ValidationMessage.IssueType type, List<String> pathParts, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String path = this.toPath(pathParts);
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, type, -1, -1, path, message, ValidationMessage.IssueSeverity.INFORMATION, theMessage);
        }
        return thePass;
    }

    protected boolean suppressedwarning(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg) {
        if (!thePass) {
            this.addValidationMessage(errors, type, -1, -1, path, msg, ValidationMessage.IssueSeverity.INFORMATION, null);
        }
        return thePass;
    }

    protected boolean suppressedwarning(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg, String html) {
        if (!thePass) {
            ValidationMessage.IssueSeverity severity = ValidationMessage.IssueSeverity.INFORMATION;
            this.addValidationMessage(errors, type, path, msg, html, severity, null);
        }
        return thePass;
    }

    protected void addValidationMessage(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, String msg, String html, ValidationMessage.IssueSeverity theSeverity, String id) {
        ValidationMessage vm = new ValidationMessage(this.source, type, -1, -1, path, msg, html, theSeverity);
        if (this.checkMsgId(id, vm)) {
            errors.add(vm.setMessageId(id));
        }
    }

    protected boolean suppressedwarning(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg, String html, Object ... theMessageArguments) {
        if (!thePass) {
            String nmsg = this.context.formatMessage(msg, theMessageArguments);
            this.addValidationMessage(errors, type, path, nmsg, html, ValidationMessage.IssueSeverity.INFORMATION, msg);
        }
        return thePass;
    }

    protected ValueSet resolveBindingReference(DomainResource ctxt, String reference, String uri) {
        if (reference != null) {
            if (reference.startsWith("#")) {
                for (Resource c : ctxt.getContained()) {
                    if (!c.getId().equals(reference.substring(1)) || !(c instanceof ValueSet)) continue;
                    return (ValueSet)c;
                }
                return null;
            }
            long t = System.nanoTime();
            ValueSet fr = (ValueSet)this.context.fetchResource(ValueSet.class, reference);
            if (fr == null && !Utilities.isAbsoluteUrl((String)reference)) {
                reference = this.resolve(uri, reference);
                fr = (ValueSet)this.context.fetchResource(ValueSet.class, reference);
            }
            if (fr == null) {
                fr = ValueSetUtilities.generateImplicitValueSet((String)reference);
            }
            this.timeTracker.tx(t, "vs " + uri);
            return fr;
        }
        return null;
    }

    private String resolve(String uri, String ref) {
        if (StringUtils.isBlank((CharSequence)uri)) {
            return ref;
        }
        String[] up = uri.split("\\/");
        String[] rp = ref.split("\\/");
        if (this.context.getResourceNames().contains(up[up.length - 2]) && this.context.getResourceNames().contains(rp[0])) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < up.length - 2; ++i) {
                b.append(up[i]);
                b.append("/");
            }
            b.append(ref);
            return b.toString();
        }
        return ref;
    }

    protected String describeReference(String reference) {
        if (reference == null) {
            return "null";
        }
        return reference;
    }

    protected Base resolveInBundle(String url, Element bnd) {
        if (bnd == null) {
            return null;
        }
        if (bnd.fhirType().equals("Bundle")) {
            for (Element be : bnd.getChildrenByName("entry")) {
                Element res = be.getNamedChild("resource");
                if (res == null) continue;
                String fullUrl = be.getChildValue("fullUrl");
                String rt = res.fhirType();
                String id = res.getChildValue("id");
                if (url.equals(fullUrl)) {
                    return res;
                }
                if (!url.equals(rt + "/" + id)) continue;
                return res;
            }
        }
        return null;
    }

    protected Element resolveInBundle(List<Element> entries, String ref, String fullUrl, String type, String id) {
        String[] parts;
        if (Utilities.isAbsoluteUrl((String)ref)) {
            for (Element entry : entries) {
                String fu = entry.getNamedChildValue("fullUrl");
                if (!ref.equals(fu)) continue;
                return entry;
            }
            return null;
        }
        String u = null;
        if (fullUrl != null && fullUrl.endsWith(type + "/" + id)) {
            u = fullUrl.substring(0, fullUrl.length() - (type + "/" + id).length()) + ref;
        }
        if ((parts = ref.split("\\/")).length >= 2) {
            String t = parts[0];
            String i = parts[1];
            for (Element entry : entries) {
                Element resource;
                String fu = entry.getNamedChildValue("fullUrl");
                if (fu != null && fu.equals(u)) {
                    return entry;
                }
                if (u != null || (resource = entry.getNamedChild("resource")) == null) continue;
                String et = resource.getType();
                String eid = resource.getNamedChildValue("id");
                if (!t.equals(et) || !i.equals(eid)) continue;
                return entry;
            }
        }
        return null;
    }

    protected IndexedElement getFromBundle(Element bundle, String ref, String fullUrl, List<ValidationMessage> errors, String path, String type, boolean isTransaction) {
        String targetUrl = null;
        String version = "";
        String resourceType = null;
        if (ref.startsWith("http:") || ref.startsWith("urn:") || Utilities.isAbsoluteUrl((String)ref)) {
            if (ref.contains("/_history/")) {
                targetUrl = ref.substring(0, ref.indexOf("/_history/") - 1);
                version = ref.substring(ref.indexOf("/_history/") + 10);
            } else {
                targetUrl = ref;
            }
        } else {
            int i;
            String[] parts;
            if (fullUrl == null) {
                this.rule(errors, ValidationMessage.IssueType.REQUIRED, -1, -1, path, Utilities.existsInList((String)type, (String[])new String[]{"batch-response", "transaction-response"}) || path.startsWith("Bundle.signature"), "Bundle_BUNDLE_FullUrl_Missing", new Object[0]);
                return null;
            }
            if (ref.split("/").length != 2 && ref.split("/").length != 4) {
                if (isTransaction) {
                    this.rule(errors, ValidationMessage.IssueType.INVALID, -1, -1, path, this.isSearchUrl(ref), "Reference_REF_Format1", ref);
                } else {
                    this.rule(errors, ValidationMessage.IssueType.INVALID, -1, -1, path, false, "Reference_REF_Format2", ref);
                }
                return null;
            }
            String base = "";
            if (fullUrl.startsWith("urn")) {
                parts = fullUrl.split("\\:");
                for (i = 0; i < parts.length - 1; ++i) {
                    base = base + parts[i] + ":";
                }
            } else {
                parts = fullUrl.split("/");
                for (i = 0; i < parts.length - 2; ++i) {
                    base = base + parts[i] + "/";
                }
            }
            String id = null;
            if (ref.contains("/_history/")) {
                version = ref.substring(ref.indexOf("/_history/") + 10);
                String[] refBaseParts = ref.substring(0, ref.indexOf("/_history/")).split("/");
                resourceType = refBaseParts[0];
                id = refBaseParts[1];
            } else if (base.startsWith("urn")) {
                resourceType = ref.split("/")[0];
                id = ref.split("/")[1];
            } else {
                id = ref;
            }
            targetUrl = base + id;
        }
        ArrayList entries = new ArrayList();
        bundle.getNamedChildren("entry", entries);
        Element match = null;
        int matchIndex = -1;
        for (int i = 0; i < entries.size(); ++i) {
            Element we = (Element)entries.get(i);
            if (!targetUrl.equals(we.getChildValue("fullUrl"))) continue;
            Element r = we.getNamedChild("resource");
            if (version.isEmpty()) {
                this.rule(errors, ValidationMessage.IssueType.FORBIDDEN, -1, -1, path, match == null, "Bundle_BUNDLE_MultipleMatches", ref);
                match = r;
                matchIndex = i;
                continue;
            }
            try {
                if (!version.equals(((Element)r.getChildren("meta").get(0)).getChildValue("versionId"))) continue;
                this.rule(errors, ValidationMessage.IssueType.FORBIDDEN, -1, -1, path, match == null, "Bundle_BUNDLE_MultipleMatches", ref);
                match = r;
                matchIndex = i;
                continue;
            }
            catch (Exception e) {
                this.warning(errors, ValidationMessage.IssueType.REQUIRED, -1, -1, path, r.getChildren("meta").size() == 1 && ((Element)r.getChildren("meta").get(0)).getChildValue("versionId") != null, "Bundle_BUNDLE_FullUrl_NeedVersion", targetUrl);
            }
        }
        if (match != null && resourceType != null) {
            this.rule(errors, ValidationMessage.IssueType.REQUIRED, -1, -1, path, match.getType().equals(resourceType), "Reference_REF_ResourceType", ref, match.getType());
        }
        if (match == null) {
            this.warning(errors, ValidationMessage.IssueType.REQUIRED, -1, -1, path, !ref.startsWith("urn"), "Bundle_BUNDLE_Not_Local", ref);
        }
        return match == null ? null : new IndexedElement(matchIndex, match, (Element)entries.get(matchIndex));
    }

    private boolean isSearchUrl(String ref) {
        if (Utilities.noString((String)ref) || !ref.contains("?")) {
            return false;
        }
        String tn = ref.substring(0, ref.indexOf("?"));
        String q = ref.substring(ref.indexOf("?") + 1);
        if (!this.context.getResourceNames().contains(tn)) {
            return false;
        }
        return q.matches("([_a-zA-Z][_a-zA-Z0-9]*=[^=&]+)(&([_a-zA-Z][_a-zA-Z0-9]*=[^=&]+))*");
    }

    public Map<String, ValidationControl> getValidationControl() {
        return this.validationControl;
    }

    public XVerExtensionManager.XVerExtensionStatus xverStatus(String url) {
        return this.xverManager.status(url);
    }

    public boolean isXverUrl(String url) {
        return this.xverManager.matchingUrl(url);
    }

    public StructureDefinition xverDefn(String url) {
        return this.xverManager.makeDefinition(url);
    }

    public String xverVersion(String url) {
        return this.xverManager.getVersion(url);
    }

    public String xverElementId(String url) {
        return this.xverManager.getElementId(url);
    }

    public StructureDefinition getXverExt(StructureDefinition profile, List<ValidationMessage> errors, String url) {
        if (this.isXverUrl(url)) {
            switch (this.xverStatus(url)) {
                case BadVersion: {
                    this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, profile.getId(), false, "Extension_EXT_Version_Invalid", url, this.xverVersion(url));
                    return null;
                }
                case Unknown: {
                    this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, profile.getId(), false, "Extension_EXT_Version_InvalidId", url, this.xverElementId(url));
                    return null;
                }
                case Invalid: {
                    this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, profile.getId(), false, "Extension_EXT_Version_NoChange", url, this.xverElementId(url));
                    return null;
                }
                case Valid: {
                    StructureDefinition defn = this.xverDefn(url);
                    this.context.generateSnapshot(defn);
                    this.context.cacheResource((Resource)defn);
                    return defn;
                }
            }
            this.rule(errors, ValidationMessage.IssueType.INVALID, profile.getId(), false, "Extension_EXT_Version_Internal", url);
            return null;
        }
        return null;
    }

    public StructureDefinition getXverExt(List<ValidationMessage> errors, String path, Element element, String url) {
        if (this.isXverUrl(url)) {
            switch (this.xverStatus(url)) {
                case BadVersion: {
                    this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path + "[url='" + url + "']", false, "Extension_EXT_Version_Invalid", url, this.xverVersion(url));
                    break;
                }
                case Unknown: {
                    this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path + "[url='" + url + "']", false, "Extension_EXT_Version_InvalidId", url, this.xverElementId(url));
                    break;
                }
                case Invalid: {
                    this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path + "[url='" + url + "']", false, "Extension_EXT_Version_NoChange", url, this.xverElementId(url));
                    break;
                }
                case Valid: {
                    StructureDefinition ex = this.xverDefn(url);
                    this.context.generateSnapshot(ex);
                    this.context.cacheResource((Resource)ex);
                    return ex;
                }
                default: {
                    this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path + "[url='" + url + "']", false, "Extension_EXT_Version_Internal", url);
                }
            }
        }
        return null;
    }

    protected String versionFromCanonical(String system) {
        if (system == null) {
            return null;
        }
        if (system.contains("|")) {
            return system.substring(0, system.indexOf("|"));
        }
        return system;
    }

    protected String systemFromCanonical(String system) {
        if (system == null) {
            return null;
        }
        if (system.contains("|")) {
            return system.substring(system.indexOf("|") + 1);
        }
        return system;
    }

    public Resource loadContainedResource(List<ValidationMessage> errors, String path, Element resource, String id, Class<? extends Resource> class1) throws FHIRException {
        for (Element contained : resource.getChildren("contained")) {
            if (!contained.getIdBase().equals(id)) continue;
            return this.loadFoundResource(errors, path, contained, class1);
        }
        return null;
    }

    protected Resource loadFoundResource(List<ValidationMessage> errors, String path, Element resource, Class<? extends Resource> class1) throws FHIRException {
        try {
            FhirPublication v = FhirPublication.fromCode((String)this.context.getVersion());
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            new org.hl7.fhir.r5.elementmodel.JsonParser(this.context).compose(resource, (OutputStream)bs, IParser.OutputStyle.NORMAL, resource.getIdBase());
            byte[] json = bs.toByteArray();
            Resource r5 = null;
            switch (v) {
                case DSTU1: {
                    this.rule(errors, ValidationMessage.IssueType.INVALID, resource.line(), resource.col(), path, false, "Unsupported_version_R1", resource.getIdBase());
                    return null;
                }
                case DSTU2: {
                    org.hl7.fhir.dstu2.model.Resource r2 = new org.hl7.fhir.dstu2.formats.JsonParser().parse(json);
                    r5 = VersionConvertorFactory_10_50.convertResource((org.hl7.fhir.dstu2.model.Resource)r2);
                    break;
                }
                case DSTU2016May: {
                    org.hl7.fhir.dstu2016may.model.Resource r2a = new org.hl7.fhir.dstu2016may.formats.JsonParser().parse(json);
                    r5 = VersionConvertorFactory_14_50.convertResource((org.hl7.fhir.dstu2016may.model.Resource)r2a);
                    break;
                }
                case STU3: {
                    org.hl7.fhir.dstu3.model.Resource r3 = new org.hl7.fhir.dstu3.formats.JsonParser().parse(json);
                    r5 = VersionConvertorFactory_30_50.convertResource((org.hl7.fhir.dstu3.model.Resource)r3);
                    break;
                }
                case R4: {
                    org.hl7.fhir.r4.model.Resource r4 = new org.hl7.fhir.r4.formats.JsonParser().parse(json);
                    r5 = VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)r4);
                    break;
                }
                case R5: {
                    r5 = new JsonParser().parse(json);
                    break;
                }
                default: {
                    return null;
                }
            }
            if (class1.isInstance(r5)) {
                return r5;
            }
            this.rule(errors, ValidationMessage.IssueType.INVALID, resource.line(), resource.col(), path, false, "REFERENCE_REF_WRONGTARGET_LOAD", resource.getIdBase(), class1.toString(), r5.fhirType());
            return null;
        }
        catch (IOException e) {
            throw new FHIRException((Throwable)e);
        }
    }

    public class ValidationControl {
        private boolean allowed;
        private ValidationMessage.IssueSeverity level;

        public ValidationControl(boolean allowed, ValidationMessage.IssueSeverity level) {
            this.allowed = allowed;
            this.level = level;
        }

        public boolean isAllowed() {
            return this.allowed;
        }

        public ValidationMessage.IssueSeverity getLevel() {
            return this.level;
        }
    }

    public class TrackedLocationRelatedMessage {
        private Object location;
        private ValidationMessage vmsg;

        public TrackedLocationRelatedMessage(Object location, ValidationMessage vmsg) {
            this.location = location;
            this.vmsg = vmsg;
        }

        public Object getLocation() {
            return this.location;
        }

        public ValidationMessage getVmsg() {
            return this.vmsg;
        }
    }
}

