/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.renderers;

import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.validation.cli.renderers.ValidationOutputRenderer;

public class ESLintCompactRenderer
extends ValidationOutputRenderer {
    @Override
    public void render(OperationOutcome oo) {
        String file = ToolingExtensions.readStringExtension((DomainResource)oo, (String)"http://hl7.org/fhir/StructureDefinition/operationoutcome-file");
        for (OperationOutcome.OperationOutcomeIssueComponent issue : oo.getIssue()) {
            int line = ToolingExtensions.readIntegerExtension((Element)issue, (String)"http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-line", (int)-1);
            int col = ToolingExtensions.readIntegerExtension((Element)issue, (String)"http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-col", (int)-1);
            System.out.println(file + ": line " + Integer.toString(line) + ", col" + Integer.toString(col) + ", " + issue.getSeverity().getDisplay() + " - " + issue.getDetails().getText());
        }
    }
}

