/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.utilities.Utilities;

public class NodeStack {
    protected IWorkerContext context;
    private ElementDefinition definition;
    private Element element;
    private ElementDefinition extension;
    private String literalPath;
    private List<String> logicalPaths;
    private NodeStack parent;
    private ElementDefinition type;
    private String workingLang;
    private Map<String, Element> ids;
    private boolean resetPoint = false;
    private boolean contained = false;

    public NodeStack(IWorkerContext context) {
        this.context = context;
    }

    public NodeStack(IWorkerContext context, String initialPath, Element element, String validationLanguage) {
        this.context = context;
        this.ids = new HashMap<String, Element>();
        this.element = element;
        this.literalPath = (initialPath == null ? "" : initialPath + ".") + element.getPath();
        this.workingLang = validationLanguage;
        if (!element.getName().equals(element.fhirType())) {
            this.logicalPaths = new ArrayList<String>();
            this.logicalPaths.add(element.fhirType());
        }
    }

    public NodeStack(IWorkerContext context, Element element, String refPath, String validationLanguage) {
        this.context = context;
        this.ids = new HashMap<String, Element>();
        this.element = element;
        this.literalPath = refPath + "->" + element.getName();
        this.workingLang = validationLanguage;
    }

    public String addToLiteralPath(String ... path) {
        StringBuilder b = new StringBuilder();
        b.append(this.getLiteralPath());
        for (String p : path) {
            if (p.startsWith(":")) {
                b.append("[");
                b.append(p.substring(1));
                b.append("]");
                continue;
            }
            b.append(".");
            b.append(p);
        }
        return b.toString();
    }

    private ElementDefinition getDefinition() {
        return this.definition;
    }

    public Element getElement() {
        return this.element;
    }

    public String getLiteralPath() {
        return this.literalPath == null ? "" : this.literalPath;
    }

    public List<String> getLogicalPaths() {
        return this.logicalPaths == null ? new ArrayList() : this.logicalPaths;
    }

    private ElementDefinition getType() {
        return this.type;
    }

    public NodeStack pushTarget(Element element, int count, ElementDefinition definition, ElementDefinition type) {
        return this.pushInternal(element, count, definition, type, "->");
    }

    public NodeStack push(Element element, int count, ElementDefinition definition, ElementDefinition type) {
        return this.pushInternal(element, count, definition, type, ".");
    }

    private NodeStack pushInternal(Element element, int count, ElementDefinition definition, ElementDefinition type, String sep) {
        NodeStack res = new NodeStack(this.context);
        res.ids = this.ids;
        res.parent = this;
        res.workingLang = this.workingLang;
        res.element = element;
        res.definition = definition;
        res.contained = this.contained;
        res.literalPath = this.getLiteralPath() + sep + element.getName();
        if (count > -1) {
            res.literalPath = res.literalPath + "[" + Integer.toString(count) + "]";
        } else if (element.getSpecial() == null && element.getProperty().isList()) {
            res.literalPath = res.literalPath + "[0]";
        } else if (element.getProperty().isChoice()) {
            String n = res.literalPath.substring(res.literalPath.lastIndexOf(".") + 1);
            String en = element.getProperty().getName();
            String t = n.substring((en = en.substring(0, en.length() - 3)).length());
            if (this.isPrimitiveType(Utilities.uncapitalize((String)t))) {
                t = Utilities.uncapitalize((String)t);
            }
            res.literalPath = res.literalPath.substring(0, res.literalPath.lastIndexOf(".")) + "." + en + ".ofType(" + t + ")";
        }
        res.logicalPaths = new ArrayList<String>();
        if (type != null) {
            res.type = type;
            String tn = res.type.getPath();
            String t = this.tail(definition.getPath());
            if ("Resource".equals(tn)) {
                tn = element.fhirType();
            }
            for (String lp : this.getLogicalPaths()) {
                res.logicalPaths.add(lp + "." + t);
                if (!t.endsWith("[x]")) continue;
                res.logicalPaths.add(lp + "." + t.substring(0, t.length() - 3) + ".ofType(" + type.getPath() + ")");
                res.logicalPaths.add(lp + "." + t.substring(0, t.length() - 3) + type.getPath());
            }
            res.logicalPaths.add(tn);
        } else if (definition != null) {
            for (String lp : this.getLogicalPaths()) {
                res.logicalPaths.add(lp + "." + element.getName());
            }
            res.logicalPaths.add(definition.typeSummary());
        } else {
            res.logicalPaths.addAll(this.getLogicalPaths());
        }
        return res;
    }

    private void setType(ElementDefinition type) {
        this.type = type;
    }

    public NodeStack resetIds() {
        this.ids = new HashMap<String, Element>();
        this.resetPoint = true;
        return this;
    }

    public Map<String, Element> getIds() {
        return this.ids;
    }

    private String tail(String path) {
        return path.substring(path.lastIndexOf(".") + 1);
    }

    public boolean isPrimitiveType(String code) {
        StructureDefinition sd = this.context.fetchTypeDefinition(code);
        return sd != null && sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE;
    }

    public String getWorkingLang() {
        return this.workingLang;
    }

    public void setWorkingLang(String workingLang) {
        this.workingLang = workingLang;
    }

    public NodeStack getParent() {
        return this.parent;
    }

    public void qualifyPath(String qualifier) {
        this.literalPath = this.literalPath + qualifier;
    }

    public boolean isResetPoint() {
        return this.resetPoint;
    }

    public String toString() {
        return this.literalPath;
    }

    public int depth() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.depth() + 1;
    }

    public boolean isContained() {
        return this.contained;
    }

    public void setContained(boolean contained) {
        this.contained = contained;
    }
}

