/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class ValidatorHostContext {
    private Object appContext;
    private Element resource;
    private Element rootResource;
    private Element groupingResource;
    private StructureDefinition profile;
    private boolean checkSpecials = true;
    private Map<String, List<ValidationMessage>> sliceRecords;

    public ValidatorHostContext(Object appContext) {
        this.appContext = appContext;
    }

    public ValidatorHostContext(Object appContext, Element element) {
        this.appContext = appContext;
        this.resource = element;
        this.rootResource = element;
        this.check();
        this.dump("creating");
    }

    private void check() {
        if (!this.rootResource.hasParentForValidator()) {
            throw new Error("No parent on root resource");
        }
    }

    public ValidatorHostContext(Object appContext, Element element, Element root) {
        this.appContext = appContext;
        this.resource = element;
        this.rootResource = root;
        this.check();
        this.dump("creating");
    }

    public ValidatorHostContext(Object appContext, Element element, Element root, Element groupingResource) {
        this.appContext = appContext;
        this.resource = element;
        this.rootResource = root;
        this.groupingResource = groupingResource;
        this.check();
        this.dump("creating");
    }

    public Object getAppContext() {
        return this.appContext;
    }

    public ValidatorHostContext setAppContext(Object appContext) {
        this.appContext = appContext;
        return this;
    }

    public ValidatorHostContext setResource(Element resource) {
        this.resource = resource;
        return this;
    }

    public Element getRootResource() {
        return this.rootResource;
    }

    public ValidatorHostContext setRootResource(Element rootResource) {
        this.rootResource = rootResource;
        this.dump("setting root resource");
        return this;
    }

    public Element getGroupingResource() {
        return this.groupingResource;
    }

    public StructureDefinition getProfile() {
        return this.profile;
    }

    public ValidatorHostContext setProfile(StructureDefinition profile) {
        this.profile = profile;
        return this;
    }

    public Map<String, List<ValidationMessage>> getSliceRecords() {
        return this.sliceRecords;
    }

    public ValidatorHostContext setSliceRecords(Map<String, List<ValidationMessage>> sliceRecords) {
        this.sliceRecords = sliceRecords;
        return this;
    }

    public boolean isCheckSpecials() {
        return this.checkSpecials;
    }

    public void setCheckSpecials(boolean checkSpecials) {
        this.checkSpecials = checkSpecials;
    }

    public Element getResource() {
        return this.resource;
    }

    public void sliceNotes(String url, List<ValidationMessage> record) {
        if (this.sliceRecords != null) {
            this.sliceRecords.put(url, record);
        }
    }

    public ValidatorHostContext forContained(Element element) {
        ValidatorHostContext res = new ValidatorHostContext(this.appContext);
        res.rootResource = this.resource;
        res.resource = element;
        res.profile = this.profile;
        res.groupingResource = this.groupingResource;
        res.dump("forContained");
        return res;
    }

    public ValidatorHostContext forEntry(Element element, Element groupingResource) {
        ValidatorHostContext res = new ValidatorHostContext(this.appContext);
        res.rootResource = element;
        res.resource = element;
        res.profile = this.profile;
        res.groupingResource = groupingResource;
        res.dump("forEntry");
        return res;
    }

    public ValidatorHostContext forProfile(StructureDefinition profile) {
        ValidatorHostContext res = new ValidatorHostContext(this.appContext);
        res.resource = this.resource;
        res.rootResource = this.rootResource;
        res.profile = profile;
        res.groupingResource = this.groupingResource;
        res.sliceRecords = this.sliceRecords != null ? this.sliceRecords : new HashMap<String, List<ValidationMessage>>();
        res.dump("forProfile " + profile.getUrl());
        return res;
    }

    public ValidatorHostContext forLocalReference(StructureDefinition profile, Element resource) {
        ValidatorHostContext res = new ValidatorHostContext(this.appContext);
        res.resource = resource;
        res.rootResource = resource;
        res.profile = profile;
        res.groupingResource = this.groupingResource;
        res.checkSpecials = false;
        res.dump("forLocalReference " + profile.getUrl());
        return res;
    }

    private void dump(String ctxt) {
    }

    public ValidatorHostContext forRemoteReference(StructureDefinition profile, Element resource) {
        ValidatorHostContext res = new ValidatorHostContext(this.appContext);
        res.resource = resource;
        res.rootResource = resource;
        res.profile = profile;
        res.groupingResource = null;
        res.checkSpecials = false;
        res.dump("forRemoteReference " + profile.getUrl());
        return res;
    }

    public ValidatorHostContext forSlicing() {
        ValidatorHostContext res = new ValidatorHostContext(this.appContext);
        res.resource = this.resource;
        res.rootResource = this.resource;
        res.groupingResource = this.groupingResource;
        res.profile = this.profile;
        res.checkSpecials = false;
        res.sliceRecords = new HashMap<String, List<ValidationMessage>>();
        res.dump("forSlicing");
        return res;
    }
}

