/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Version {
    V21("2.1"),
    V22("2.2"),
    V23("2.3"),
    V231("2.3.1"),
    V24("2.4"),
    V25("2.5"),
    V251("2.5.1"),
    V26("2.6");

    private String version;

    private Version(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPackageVersion() {
        return "v" + this.version.replace(".", "");
    }

    public static boolean supportsVersion(String version) {
        return Version.versionOf(version) != null;
    }

    public static Version versionOf(String version) {
        for (Version v : Version.values()) {
            if (!v.getVersion().equals(version)) continue;
            return v;
        }
        return null;
    }

    public boolean isGreaterThan(Version theVersion) {
        return this.compareTo(theVersion) > 0;
    }

    public static Version latestVersion() {
        Version[] versions = Version.values();
        return versions[versions.length - 1];
    }
}

