/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.concurrent.Service;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AcceptorThread
extends Service {
    static final int TIMEOUT = 500;
    private static final Logger log = LoggerFactory.getLogger(AcceptorThread.class);
    private int port;
    private boolean tls = false;
    private ServerSocket ss;
    private final BlockingQueue<AcceptedSocket> queue;

    public AcceptorThread(int port, ExecutorService service, BlockingQueue<AcceptedSocket> queue) throws IOException, SocketException {
        this(port, false, service, queue);
    }

    public AcceptorThread(int port, boolean tls, ExecutorService service, BlockingQueue<AcceptedSocket> queue) throws IOException, SocketException {
        super("Socket Acceptor", service);
        this.port = port;
        this.queue = queue;
        this.tls = tls;
    }

    @Override
    protected void afterStartup() {
        try {
            this.ss = this.createServerSocket(this.port);
            this.ss.setSoTimeout(500);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void handle() {
        try {
            Socket s = this.ss.accept();
            s.setSoTimeout(500);
            if (!this.queue.offer(new AcceptedSocket(s))) {
                log.error("Denied enqueuing server-side socket {}", (Object)s);
                s.close();
            } else {
                log.debug("Enqueued server-side socket {}", (Object)s);
            }
        }
        catch (SocketTimeoutException e) {
            log.trace("No connection established in recent {} ms.", (Object)500);
        }
        catch (IOException e) {
            log.error("Error while accepting connections", (Throwable)e);
        }
    }

    @Override
    protected void afterTermination() {
        try {
            if (this.ss != null && !this.ss.isClosed()) {
                this.ss.close();
            }
        }
        catch (IOException e) {
            log.warn("Error during stopping the thread", (Throwable)e);
        }
    }

    protected ServerSocket createServerSocket(int port) throws IOException {
        ServerSocketFactory socketFactory = this.tls ? SSLServerSocketFactory.getDefault() : ServerSocketFactory.getDefault();
        return socketFactory.createServerSocket(port);
    }

    class AcceptedSocket {
        Socket socket;
        AcceptorThread origin;

        public AcceptedSocket(Socket socket) {
            if (socket == null) {
                throw new IllegalArgumentException("Socket must not be null");
            }
            this.socket = socket;
            this.origin = AcceptorThread.this;
        }
    }
}

