/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.parser.Parser;

class ConnectionData {
    private String host;
    private int port;
    private int port2;
    private boolean tls;
    private Parser parser;
    private LowerLayerProtocol protocol;

    public ConnectionData(String host, int port, Parser parser, LowerLayerProtocol protocol) {
        this(host, port, parser, protocol, false);
    }

    public ConnectionData(String host, int port, Parser parser, LowerLayerProtocol protocol, boolean tls) {
        this(host, port, 0, parser, protocol, false);
    }

    public ConnectionData(String host, int outboundPort, int inboundPort, Parser parser, LowerLayerProtocol protocol, boolean tls) {
        this.host = host;
        this.port = outboundPort;
        this.port2 = inboundPort;
        this.parser = parser;
        this.protocol = protocol;
        this.tls = tls;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getPort2() {
        return this.port2;
    }

    public boolean isTls() {
        return this.tls;
    }

    public Parser getParser() {
        return this.parser;
    }

    public LowerLayerProtocol getProtocol() {
        return this.protocol;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.parser == null ? 0 : this.parser.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + this.port2;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionData other = (ConnectionData)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.parser == null) {
            if (other.parser != null) {
                return false;
            }
        } else {
            if (other.parser == null) {
                return false;
            }
            if (!this.parser.getClass().equals(other.parser.getClass())) {
                return false;
            }
        }
        if (this.port != other.port) {
            return false;
        }
        return this.port2 == other.port2;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getHost()).append(":").append(this.getPort());
        if (this.port2 > 0) {
            buf.append(",").append(this.port2);
        }
        if (this.isTls()) {
            buf.append("(s)");
        }
        return buf.toString();
    }
}

