/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.app.Connection;
import ca.uhn.hl7v2.app.ConnectionData;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

class ConnectionFactory {
    ConnectionFactory() {
    }

    public static Connection open(ConnectionData connectionData, ExecutorService executorService) throws Exception {
        Connection connection = null;
        if (connectionData.getPort2() == 0) {
            connection = new Connection(connectionData.getParser(), connectionData.getProtocol(), ConnectionFactory.createSocket(connectionData.getHost(), connectionData.getPort(), false), executorService);
        } else {
            Socket outbound = ConnectionFactory.createSocket(connectionData.getHost(), connectionData.getPort(), connectionData.isTls());
            Socket inbound = ConnectionFactory.createSocket(connectionData.getHost(), connectionData.getPort2(), connectionData.isTls());
            connection = new Connection(connectionData.getParser(), connectionData.getProtocol(), inbound, outbound, executorService);
        }
        connection.activate();
        return connection;
    }

    private static Socket createSocket(String host, int port, boolean ssl) throws UnknownHostException, IOException {
        SocketFactory sf = ssl ? SSLSocketFactory.getDefault() : SocketFactory.getDefault();
        Socket socket = sf.createSocket(host, port);
        socket.setKeepAlive(true);
        return socket;
    }
}

