/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.net.Socket;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HL7ServerTestHelper {
    private static final Logger ourLog = LoggerFactory.getLogger(HL7ServerTestHelper.class);
    private static final String HL7_START_OF_MESSAGE = "\u000b";
    private static final String HL7_END_OF_MESSGAE = "\u001c";
    private String host = null;
    private int port = 0;
    private Socket socket = null;
    private OutputStream os = null;
    private InputStream is = null;

    public HL7ServerTestHelper(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void openSocket() throws IOException {
        this.socket = new Socket(this.host, this.port);
        this.socket.setSoLinger(true, 1000);
        this.os = this.socket.getOutputStream();
        this.is = this.socket.getInputStream();
    }

    public void closeSocket() {
        try {
            Socket sckt = this.socket;
            this.socket = null;
            if (sckt != null) {
                sckt.close();
            }
        }
        catch (Exception e) {
            ourLog.error(e.getMessage(), (Throwable)e);
        }
    }

    public int process(InputStream theMsgInputStream) throws FileNotFoundException, IOException {
        BufferedReader in = new BufferedReader(new CommentFilterReader(new InputStreamReader(theMsgInputStream)));
        StringBuffer rawMsgBuffer = new StringBuffer();
        int c = 0;
        while ((c = in.read()) >= 0) {
            rawMsgBuffer.append((char)c);
        }
        String[] messages = HL7ServerTestHelper.getHL7Messages(rawMsgBuffer.toString());
        int retVal = 0;
        long startTime = new GregorianCalendar().getTimeInMillis();
        for (int i = 0; i < messages.length; ++i) {
            this.sendMessage(messages[i]);
            this.readAck();
            ++retVal;
        }
        long endTime = new GregorianCalendar().getTimeInMillis();
        long elapsedTime = (endTime - startTime) / 1000L;
        ourLog.info("{} messages sent.", (Object)retVal);
        ourLog.info("Elapsed Time in seconds: {} ", (Object)elapsedTime);
        return retVal;
    }

    private String readAck() throws IOException {
        StringBuffer stringbuffer = new StringBuffer();
        int i = 0;
        do {
            if ((i = this.is.read()) == -1) {
                return null;
            }
            stringbuffer.append((char)i);
        } while (i != 28);
        return stringbuffer.toString();
    }

    public static String[] getHL7Messages(String theSource) {
        ArrayList<String> messages = new ArrayList<String>(20);
        Pattern startPattern = Pattern.compile("^MSH", 8);
        Matcher startMatcher = startPattern.matcher(theSource);
        while (startMatcher.find()) {
            String messageExtent = HL7ServerTestHelper.getMessageExtent(theSource.substring(startMatcher.start()), startPattern);
            char fieldDelim = messageExtent.charAt(3);
            Pattern segmentPattern = Pattern.compile("^[A-Z\\d]{3}\\" + fieldDelim + ".*$", 8);
            Matcher segmentMatcher = segmentPattern.matcher(messageExtent);
            StringBuffer msg = new StringBuffer();
            while (segmentMatcher.find()) {
                msg.append(segmentMatcher.group().trim());
                msg.append('\r');
            }
            messages.add(msg.toString());
        }
        return messages.toArray(new String[0]);
    }

    private static String getMessageExtent(String theSource, Pattern theStartPattern) {
        Matcher startMatcher = theStartPattern.matcher(theSource);
        if (!startMatcher.find()) {
            throw new IllegalArgumentException(theSource + "does not contain message start pattern" + theStartPattern.toString());
        }
        int start = startMatcher.start();
        int end = theSource.length();
        if (startMatcher.find()) {
            end = startMatcher.start();
        }
        return theSource.substring(start, end).trim();
    }

    private void sendMessage(String theMessage) throws IOException {
        this.os.write(HL7_START_OF_MESSAGE.getBytes());
        this.os.write(theMessage.getBytes());
        this.os.write(HL7_END_OF_MESSGAE.getBytes());
        this.os.write(13);
        this.os.flush();
        ourLog.info("Sent: " + theMessage);
    }

    public static void main(String[] theArgs) {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("h", "host", true, "IP of host to send to");
        options.addOption("p", "port", true, "port to send to");
        options.addOption("f", "file", true, "file to read HL7 messages from");
        CommandLine cmdLine = null;
        try {
            cmdLine = parser.parse(options, theArgs);
        }
        catch (ParseException e) {
            ourLog.error(e.getMessage(), (Throwable)e);
            return;
        }
        String portString = cmdLine.getOptionValue("p");
        int port = 0;
        String host = cmdLine.getOptionValue("h");
        String file = cmdLine.getOptionValue("f");
        if (portString == null || host == null || file == null) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("serverTest", options);
            return;
        }
        port = Integer.parseInt(portString);
        HL7ServerTestHelper serverTest = new HL7ServerTestHelper(host, port);
        InputStream msgInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
        try {
            serverTest.openSocket();
            serverTest.process(msgInputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("serverTest", options);
            System.exit(-1);
        }
        serverTest.closeSocket();
    }

    public static class CommentFilterReader
    extends PushbackReader {
        private final char[] startCPPComment = new char[]{'/', '*'};
        private final char[] endCPPComment = new char[]{'*', '/'};
        private final char[] startCComment = new char[]{'/', '/'};
        private final char[] endCComment = new char[]{'\n'};
        private final char[] protocolDelim = new char[]{':', '/', '/'};

        public CommentFilterReader(Reader in) {
            super(in, 5);
        }

        public int read() throws IOException {
            int ret;
            if (!this.atSequence(this.protocolDelim)) {
                int i;
                if (this.atSequence(this.startCPPComment)) {
                    while (!this.atSequence(this.endCPPComment)) {
                        super.read();
                    }
                    for (i = 0; i < this.endCPPComment.length; ++i) {
                        super.read();
                    }
                } else if (this.atSequence(this.startCComment)) {
                    while (!this.atSequence(this.endCComment)) {
                        super.read();
                    }
                    for (i = 0; i < this.endCComment.length; ++i) {
                        super.read();
                    }
                }
            }
            if ((ret = super.read()) == 65535) {
                ret = -1;
            }
            return ret;
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            int i = -1;
            boolean done = false;
            while (++i < len) {
                int next = this.read();
                if (next == 65535 || next == -1) {
                    done = true;
                    break;
                }
                cbuf[off + i] = (char)next;
            }
            if (i == 0 && done) {
                i = -1;
            }
            return i;
        }

        private boolean atSequence(char[] sequence) throws IOException {
            boolean result = true;
            int i = -1;
            int[] data = new int[sequence.length];
            while (++i < sequence.length && result) {
                data[i] = super.read();
                if ((char)data[i] == sequence[i]) continue;
                result = false;
            }
            for (int j = i - 1; j >= 0; --j) {
                this.unread(data[j]);
            }
            return result;
        }
    }
}

