/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.Connection;
import ca.uhn.hl7v2.app.ConnectionData;
import ca.uhn.hl7v2.app.ConnectionDialog;
import ca.uhn.hl7v2.app.ConnectionHub;
import ca.uhn.hl7v2.app.ConnectionListener;
import ca.uhn.hl7v2.app.HL7Service;
import ca.uhn.hl7v2.app.MessageTypeRouter;
import ca.uhn.hl7v2.app.SimpleServer;
import ca.uhn.hl7v2.app.TwoPortService;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.llp.MinLowerLayerProtocol;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.validation.impl.ValidationContextFactory;
import ca.uhn.hl7v2.view.TreePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPanel
extends JPanel
implements ConnectionListener {
    private static final Logger log = LoggerFactory.getLogger(TestPanel.class);
    private static HL7Service service;
    private GenericParser parser = new GenericParser();
    private JTextArea outboundText;
    private TreePanel outboundTree;
    private JTextArea inboundText;
    private TreePanel inboundTree;
    private JSplitPane messages;
    private JList connList = null;
    private MessageTypeRouter router;
    private JCheckBox xmlCheckBox;
    private JFileChooser fc;
    private JLabel connectionListening;
    private JTextArea events;
    private SwingLogAppender appender;
    private boolean started;
    private ConnectionHub connectionHub;

    public TestPanel() throws HL7Exception {
        this.parser.setValidationContext(ValidationContextFactory.noValidation());
        this.connectionHub = ConnectionHub.getInstance();
        this.router = new MessageTypeRouter();
        this.initUI();
        BasicConfigurator.configure((Appender)this.appender);
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.outboundText = new JTextArea(10, 10);
        JScrollPane outTextScroll = new JScrollPane(this.outboundText);
        this.outboundTree = new TreePanel();
        JScrollPane outTreeScroll = new JScrollPane(this.outboundTree);
        this.inboundText = new JTextArea(10, 10);
        JScrollPane inTextScroll = new JScrollPane(this.inboundText);
        this.inboundTree = new TreePanel();
        JScrollPane inTreeScroll = new JScrollPane(this.inboundTree);
        JSplitPane outbound = new JSplitPane(1, true, TestPanel.addTitle(outTextScroll, " Outbound Message Text "), TestPanel.addTitle(outTreeScroll, " Outbound Message Tree "));
        JSplitPane inbound = new JSplitPane(1, true, TestPanel.addTitle(inTextScroll, " Inbound Message Text "), TestPanel.addTitle(inTreeScroll, " Inbound Message Tree "));
        this.messages = new JSplitPane(0, true, outbound, inbound);
        this.events = new JTextArea(10, 10);
        JScrollPane eventsScroll = new JScrollPane(this.events);
        this.appender = new SwingLogAppender(this.events);
        JSplitPane messagesAndLog = new JSplitPane(0, true, this.messages, eventsScroll);
        this.add((Component)messagesAndLog, "Center");
        JPanel controlPanel = new JPanel(new FlowLayout(1));
        final JComboBox<String> charsetChooser = new JComboBox<String>(Charset.availableCharsets().keySet().toArray(new String[0]));
        charsetChooser.setSelectedItem(Charset.defaultCharset().displayName());
        charsetChooser.setMaximumRowCount(15);
        JButton loadButton = new JButton(" Load ");
        JButton clearButton = new JButton(" Clear ");
        JButton parseButton = new JButton(" Parse ");
        JButton sendButton = new JButton(" Send ");
        JButton encodeButton = new JButton(" Encode Inbound ");
        JButton encodeOriginalButton = new JButton(" Encode Outbound ");
        this.xmlCheckBox = new JCheckBox("Use XML", false);
        JButton connectButton = new JButton(" Connect ");
        JButton disconnectButton = new JButton(" Disconnect ");
        controlPanel.add(charsetChooser);
        controlPanel.add(loadButton);
        controlPanel.add(clearButton);
        controlPanel.add(parseButton);
        controlPanel.add(encodeButton);
        controlPanel.add(encodeOriginalButton);
        controlPanel.add(this.xmlCheckBox);
        controlPanel.add(connectButton);
        controlPanel.add(sendButton);
        controlPanel.add(disconnectButton);
        this.add((Component)controlPanel, "North");
        this.connList = new JList();
        this.connList.setPrototypeCellValue("xxxxxxxxxxxxxxxxxxxxxxxxxxx");
        this.connList.setSelectionMode(0);
        JPanel connPanel = new JPanel(new BorderLayout());
        connPanel.add((Component)new JScrollPane(this.connList), "Center");
        this.connectionListening = new JLabel(" Connections ");
        connPanel.add((Component)this.connectionListening, "North");
        this.add((Component)connPanel, "East");
        this.fc = new JFileChooser();
        loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    int returnVal = TestPanel.this.fc.showOpenDialog(TestPanel.this.getThis());
                    if (returnVal == 0) {
                        File file = TestPanel.this.fc.getSelectedFile();
                        String input = TestPanel.this.readFile(file, Charset.forName((String)charsetChooser.getSelectedItem()));
                        TestPanel.this.outboundText.setText(input);
                        TestPanel.this.outboundText.setCaretPosition(0);
                    }
                }
                catch (Exception e) {
                    TestPanel.this.showException(e);
                }
            }
        });
        clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    TestPanel.this.outboundText.setText("");
                    TestPanel.this.inboundText.setText("");
                    TestPanel.this.inboundTree.setMessage(null);
                    TestPanel.this.outboundTree.setMessage(null);
                    TestPanel.this.events.setText("");
                }
                catch (Exception e) {
                    TestPanel.this.showException(e);
                }
            }
        });
        parseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    TestPanel.this.parseOutbound();
                }
                catch (Exception e) {
                    TestPanel.this.showException(e);
                }
            }
        });
        connectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    new ConnectionDialog(TestPanel.this.getThis());
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    TestPanel.this.showException(e);
                }
            }
        });
        sendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    TestPanel.this.sendAndRecieve();
                }
                catch (Exception e) {
                    TestPanel.this.showException(e);
                }
            }
        });
        encodeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    TestPanel.this.encodeInbound();
                }
                catch (Exception e) {
                    TestPanel.this.showException(e);
                }
            }
        });
        encodeOriginalButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    TestPanel.this.encodeOutbound();
                }
                catch (Exception e) {
                    TestPanel.this.showException(e);
                }
            }
        });
        this.xmlCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (TestPanel.this.xmlCheckBox.isSelected()) {
                    TestPanel.this.parser.setXMLParserAsPrimary();
                } else {
                    TestPanel.this.parser.setPipeParserAsPrimary();
                }
            }
        });
        disconnectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    TestPanel.this.disconnect(TestPanel.this.getCurrentConnection());
                }
                catch (Exception e) {
                    TestPanel.this.showException(e);
                }
            }
        });
    }

    private String readFile(File file, Charset charset) throws IOException {
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            int len = ((InputStream)in).read(buffer);
            while (len >= 0) {
                baos.write(buffer, 0, len);
                len = ((InputStream)in).read(buffer);
            }
            String string = new String(baos.toString(charset.name()));
            return string;
        }
        catch (IOException e) {
            log.error("Failed reading file {}", (Object)file.getAbsolutePath(), (Object)e);
            throw e;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {}
            }
        }
    }

    private TestPanel getThis() {
        return this;
    }

    protected Parser getParser() {
        return this.parser;
    }

    private static JPanel addTitle(Component toBeTitled, String title) {
        JPanel newPanel = new JPanel(new BorderLayout());
        newPanel.add(toBeTitled, "Center");
        newPanel.add((Component)new JLabel(title), "North");
        return newPanel;
    }

    public void showException(Exception e) {
        JOptionPane.showMessageDialog(this, e.getMessage(), e.getClass().getName(), 0);
        log.error("showException: ", (Throwable)e);
    }

    public void parseOutbound() throws HL7Exception, EncodingNotSupportedException {
        String messageString = this.outboundText.getText().replace('\n', '\r');
        Message out = this.parser.parse(messageString);
        this.outboundTree.setMessage(out);
        if (this.messages.getDividerLocation() < 0) {
            this.messages.setDividerLocation(0.5);
        }
        this.validate();
    }

    private ConnectionData getCurrentConnection() throws Exception {
        ConnectionData ce = null;
        Object o = this.connList.getSelectedValue();
        if (o != null && !this.connectionHub.isOpen(ce = (ConnectionData)o)) {
            this.disconnect(ce);
            this.connect(ce);
        }
        return ce;
    }

    public void connect(String host, int port) throws Exception {
        this.connect(host, port, false);
    }

    public void connect(String host, int port, boolean tls) throws Exception {
        Connection c = this.connectionHub.attach(host, port, (Parser)this.parser, MinLowerLayerProtocol.class, tls);
        c.getResponder().registerApplication(this.router);
        this.connList.setListData(this.connectionHub.allConnections().toArray(new ConnectionData[0]));
    }

    public void connect(String host, int inboundPort, int outboundPort) throws Exception {
        this.connect(host, inboundPort, outboundPort, false);
    }

    public void connect(String host, int inboundPort, int outboundPort, boolean tls) throws Exception {
        Connection c = this.connectionHub.attach(host, outboundPort, inboundPort, (Parser)this.parser, MinLowerLayerProtocol.class, tls);
        c.getResponder().registerApplication(this.router);
        this.connList.setListData(this.connectionHub.allConnections().toArray(new ConnectionData[0]));
    }

    public void connect(ConnectionData cf) throws Exception {
        Connection c = this.connectionHub.attach(cf);
        c.getResponder().registerApplication(this.router);
        this.connList.setListData(this.connectionHub.allConnections().toArray(new ConnectionData[0]));
    }

    public void connectionReceived(Connection connection) {
        connection.getResponder().registerApplication(this.router);
    }

    public void connectionDiscarded(Connection connection) {
    }

    private void disconnect(ConnectionData c) {
        if (c != null) {
            this.connectionHub.detach(this.connectionHub.getKnownConnection(c));
            this.connList.setListData(this.connectionHub.allConnections().toArray(new ConnectionData[0]));
        }
    }

    public MessageTypeRouter getRouter() {
        return this.router;
    }

    public void sendAndRecieve() throws Exception {
        Message inbound;
        Message outbound = this.outboundTree.getMessage();
        try {
            inbound = this.connectionHub.getKnownConnection(this.getCurrentConnection()).getInitiator().sendAndReceive(outbound);
        }
        catch (NullPointerException e) {
            throw new IOException("Please select a Connection.");
        }
        this.inboundTree.setMessage(inbound);
        this.validate();
    }

    public void encodeInbound() throws HL7Exception {
        String inbound = this.parser.encode(this.inboundTree.getMessage());
        inbound = inbound.replace('\r', '\n');
        this.inboundText.setText(inbound);
    }

    public void encodeOutbound() throws HL7Exception {
        String outbound = this.parser.encode(this.outboundTree.getMessage());
        outbound = outbound.replace('\r', '\n');
        TestPanel.openTextWindow("Outbound Message", outbound);
    }

    public static void openTextWindow(String title, String text) {
        JFrame frame = new JFrame(title);
        try {
            frame.getContentPane().setLayout(new BorderLayout());
            JTextArea textArea = new JTextArea(text);
            JScrollPane scroll = new JScrollPane(textArea);
            frame.getContentPane().add((Component)scroll, "Center");
            frame.pack();
            frame.setVisible(true);
        }
        catch (Exception e) {
            System.err.println("Can't display text in new window: " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        if (args.length > 3) {
            System.out.println("Usage: ca.uhn.hl7v2.app.TestPanel [tls] [inbound_port [outbound_port] ]");
            System.out.println("    If port numbers are provided, an HL7Server will be started, to listen for incoming connections.");
            System.out.println("    If outbound port is not provided, inbound and outbound messages will use the same port.");
            System.out.println("    If tls is provided, inbound and outbound messages will be received/sent over TLS.");
            System.exit(1);
        }
        JFrame frame = new JFrame("Message Tester");
        try {
            TestPanel panel = new TestPanel();
            boolean tls = false;
            int i = 0;
            try {
                if (args.length > 0) {
                    LowerLayerProtocol llp = LowerLayerProtocol.makeLLP();
                    if ("tls".equals(args[i]) || "ssl".equals(args[i])) {
                        tls = true;
                    }
                    int n = ++i;
                    int inPort = Integer.parseInt(args[n]);
                    if (args.length > ++i) {
                        int outPort = Integer.parseInt(args[i]);
                        service = new TwoPortService(panel.getParser(), llp, inPort, outPort, tls);
                    } else {
                        service = new SimpleServer(inPort, llp, panel.getParser(), tls);
                    }
                    service.registerConnectionListener(panel);
                    service.start();
                }
            }
            catch (NumberFormatException nfe) {
                System.out.println("The given port number(s) are not valid integers");
                System.exit(1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            frame.getContentPane().add((Component)panel, "Center");
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.pack();
            frame.setVisible(true);
            panel.started = true;
            panel.appender.display();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class SwingLogAppender
    extends WriterAppender {
        private final JTextArea area;
        private ConcurrentLinkedQueue<String> buf;

        public SwingLogAppender(JTextArea area) {
            this.area = area;
            this.buf = new ConcurrentLinkedQueue();
            this.setLayout((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n"));
        }

        public void append(LoggingEvent event) {
            String[] exception;
            this.buf.offer(this.getLayout().format(event));
            if (this.getLayout().ignoresThrowable() && (exception = event.getThrowableStrRep()) != null) {
                for (String line : exception) {
                    this.buf.offer(line);
                    this.buf.offer(Layout.LINE_SEP);
                }
            }
            this.display();
        }

        void display() {
            if (TestPanel.this.started && !this.buf.isEmpty()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        while (!SwingLogAppender.this.buf.isEmpty()) {
                            SwingLogAppender.this.area.append((String)SwingLogAppender.this.buf.poll());
                        }
                        SwingLogAppender.this.buf.clear();
                    }
                });
            }
        }
    }
}

