/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.llp;

import ca.uhn.hl7v2.llp.HL7Reader;
import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.llp.MinLLPWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinLLPReader
implements HL7Reader {
    public static final String CHARSET_KEY = "ca.uhn.hl7v2.llp.charset";
    private static final Logger log = LoggerFactory.getLogger(MinLLPReader.class);
    private BufferedReader myReader;
    private Charset charset;
    public static final char END_MESSAGE = '\u001c';
    public static final char START_MESSAGE = '\u000b';
    public static final char LAST_CHARACTER = '\r';

    public MinLLPReader() {
    }

    public MinLLPReader(InputStream in) throws IOException {
        this.setInputStream(in);
    }

    public MinLLPReader(InputStream in, Charset theCharset) throws IOException {
        this.charset = theCharset;
        this.setInputStream(in);
    }

    public synchronized void setInputStream(InputStream in) throws IOException {
        String charsetString;
        this.myReader = this.charset != null ? new BufferedReader(new InputStreamReader(in, this.charset)) : ((charsetString = System.getProperty(CHARSET_KEY, "US-ASCII")).equals("default") ? new BufferedReader(new InputStreamReader(in)) : new BufferedReader(new InputStreamReader(in, charsetString)));
    }

    public synchronized String getMessage() throws LLPException, IOException {
        StringBuffer s_buffer = new StringBuffer();
        boolean end_of_message = false;
        int c = 0;
        try {
            c = this.myReader.read();
        }
        catch (SocketTimeoutException e) {
            log.debug("SocketTimeoutException on read() attempt.");
            return null;
        }
        catch (SocketException e) {
            log.info("SocketException on read() attempt.  Socket appears to have been closed: " + e.getMessage());
            throw e;
        }
        if (c == -1) {
            log.info("End of input stream reached.");
            throw new SocketException("End of input stream reached.");
        }
        LowerLayerProtocol.logCharacterReceived(c);
        if (c != 11) {
            throw new LLPException("Message violates the minimal lower layer protocol: no start of message indicator received. Received: " + c);
        }
        while (!end_of_message) {
            c = this.myReader.read();
            if (c == -1) {
                throw new LLPException("Message violates the minimal lower protocol: message terminated without a terminating character.");
            }
            LowerLayerProtocol.logCharacterReceived(c);
            if (c == 28) {
                c = this.myReader.read();
                if (c >= 0) {
                    LowerLayerProtocol.logCharacterReceived(c);
                }
                if (c != 13) {
                    throw new LLPException("Message violates the minimal lower layer protocol: message terminator not followed by a return character.");
                }
                end_of_message = true;
                continue;
            }
            s_buffer.append((char)c);
        }
        return s_buffer.toString();
    }

    public static void main(String[] args) {
        try {
            Socket s = new Socket("142.224.51.2", 7);
            MinLLPReader in = new MinLLPReader(s.getInputStream());
            MinLLPWriter out = new MinLLPWriter(s.getOutputStream());
            out.writeMessage("Some message.");
            System.out.println("wrote");
            String str = in.getMessage();
            System.out.println("read");
            System.out.println(str);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public synchronized void close() throws IOException {
        this.myReader.close();
    }
}

