/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.DefaultApplication;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.primitive.CommonTS;
import ca.uhn.hl7v2.model.primitive.ID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.MessageIDGenerator;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.hl7v2.validation.ValidationContext;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractMessage
extends AbstractGroup
implements Message {
    private ValidationContext myContext;
    private static final Pattern ourVersionPattern = Pattern.compile("\\.(v2[0-9][0-9]?)\\.");
    private String myVersion;
    private transient Parser myParser;

    public AbstractMessage(ModelClassFactory theFactory) {
        super(null, theFactory);
    }

    public Message getMessage() {
        return this;
    }

    public Group getParent() {
        return this;
    }

    public String getVersion() {
        String verFolder;
        if (this.myVersion != null) {
            return this.myVersion;
        }
        String version = null;
        Pattern p = ourVersionPattern;
        Matcher m = p.matcher(this.getClass().getName());
        if (m.find() && (verFolder = m.group(1)).length() > 0) {
            char[] chars = verFolder.toCharArray();
            StringBuffer buf = new StringBuffer();
            for (int i = 1; i < chars.length; ++i) {
                buf.append(chars[i]);
                if (i >= chars.length - 1) continue;
                buf.append('.');
            }
            version = buf.toString();
        }
        if (version == null) {
            version = "2.4";
        }
        this.myVersion = version;
        return version;
    }

    public ValidationContext getValidationContext() {
        return this.myContext;
    }

    public void setValidationContext(ValidationContext theContext) {
        this.myContext = theContext;
    }

    public Character getFieldSeparatorValue() throws HL7Exception {
        Segment firstSegment = (Segment)this.get(this.getNames()[0]);
        Primitive value = (Primitive)firstSegment.getField(1, 0);
        String valueString = value.getValue();
        if (valueString == null || valueString.length() == 0) {
            return null;
        }
        return Character.valueOf(valueString.charAt(0));
    }

    public String getEncodingCharactersValue() throws HL7Exception {
        Segment firstSegment = (Segment)this.get(this.getNames()[0]);
        Primitive value = (Primitive)firstSegment.getField(2, 0);
        return value.getValue();
    }

    public void setParser(Parser parser) {
        if (parser == null) {
            throw new NullPointerException("Value may not be null");
        }
        this.myParser = parser;
    }

    public Parser getParser() {
        if (this.myParser == null) {
            this.myParser = new PipeParser();
        }
        return this.myParser;
    }

    public void parse(String string) throws HL7Exception {
        this.clear();
        this.getParser().parse(this, string);
    }

    public String encode() throws HL7Exception {
        return this.getParser().encode(this);
    }

    public Message generateACK() throws HL7Exception, IOException {
        return this.generateACK(null, null);
    }

    public Message generateACK(String theAcknowledgementCode, HL7Exception theException) throws HL7Exception, IOException {
        Message retVal = DefaultApplication.makeACK(this);
        if (theAcknowledgementCode == null) {
            theAcknowledgementCode = "AA";
        }
        Segment msa = (Segment)retVal.get("MSA");
        ID ackCode = (ID)msa.getField(1, 0);
        ackCode.setValue(theAcknowledgementCode);
        if (theException != null) {
            Segment err = (Segment)retVal.get("ERR");
            theException.populate(err, null);
        }
        return retVal;
    }

    public String toString() {
        try {
            return this.encode();
        }
        catch (HL7Exception e) {
            return this.getClass().getName() + " - Failed to create toString(): " + e.getMessage();
        }
    }

    public String printStructure() throws HL7Exception {
        StringBuilder builder = new StringBuilder();
        this.appendStructureDescription(builder, 0, false, false, true, true);
        return builder.toString();
    }

    public void initQuickstart(String messageCode, String messageTriggerEvent, String processingId) throws HL7Exception, IOException {
        Segment msh = (Segment)this.get("MSH");
        Terser.set(msh, 1, 0, 1, 1, "|");
        Terser.set(msh, 2, 0, 1, 1, "^~\\&");
        GregorianCalendar now = new GregorianCalendar();
        Terser.set(msh, 7, 0, 1, 1, CommonTS.toHl7TSFormat(now));
        Terser.set(msh, 9, 0, 1, 1, messageCode);
        Terser.set(msh, 9, 0, 2, 1, messageTriggerEvent);
        Terser.set(msh, 10, 0, 1, 1, MessageIDGenerator.getInstance().getNewID());
        Terser.set(msh, 11, 0, 1, 1, processingId);
        Terser.set(msh, 12, 0, 1, 1, this.getVersion());
        if (this.getVersion().compareTo("2.4") >= 0) {
            String className = this.getClass().getName();
            int lastIndexOf = className.lastIndexOf(46);
            if ((className = className.substring(lastIndexOf + 1)).matches("[A-Z]{3}_[A-Z0-9]{3}")) {
                Terser.set(msh, 9, 0, 3, 1, className);
            }
        }
    }
}

