/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.parser.XMLParser;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultXMLParser
extends XMLParser {
    private static final Logger log = LoggerFactory.getLogger(DefaultXMLParser.class);
    private static final Set<String> ourForceGroupNames = new HashSet<String>();

    public DefaultXMLParser() {
    }

    public DefaultXMLParser(ModelClassFactory theFactory) {
        super(theFactory);
    }

    @Override
    public Document encodeDocument(Message source) throws HL7Exception {
        String messageClassName = source.getClass().getName();
        String messageName = messageClassName.substring(messageClassName.lastIndexOf(46) + 1);
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement(messageName);
            doc.appendChild(root);
        }
        catch (Exception e) {
            throw new HL7Exception("Can't create XML document - " + e.getClass().getName(), 207, e);
        }
        this.encode((Group)source, doc.getDocumentElement());
        return doc;
    }

    private void encode(Group groupObject, Element groupElement) throws HL7Exception {
        String[] childNames = groupObject.getNames();
        String messageName = groupObject.getMessage().getName();
        try {
            for (int i = 0; i < childNames.length; ++i) {
                Structure[] reps = groupObject.getAll(childNames[i]);
                for (int j = 0; j < reps.length; ++j) {
                    Element childElement;
                    String elementName = DefaultXMLParser.makeGroupElementName(messageName, childNames[i]);
                    try {
                        childElement = groupElement.getOwnerDocument().createElement(elementName);
                    }
                    catch (DOMException e) {
                        throw new HL7Exception("Can't encode element " + elementName + " in group " + groupObject.getClass().getName(), 207, e);
                    }
                    groupElement.appendChild(childElement);
                    if (reps[j] instanceof Group) {
                        this.encode((Group)reps[j], childElement);
                        continue;
                    }
                    if (!(reps[j] instanceof Segment)) continue;
                    this.encode((Segment)reps[j], childElement);
                }
            }
        }
        catch (DOMException e) {
            throw new HL7Exception("Can't encode group " + groupObject.getClass().getName(), 207, e);
        }
    }

    @Override
    public Message parseDocument(Document XMLMessage, String version) throws HL7Exception {
        String messageName = XMLMessage.getDocumentElement().getTagName();
        Message message = this.instantiateMessage(messageName, version, true);
        this.parse((Group)message, XMLMessage.getDocumentElement());
        return message;
    }

    private void parse(Group groupObject, Element groupElement) throws HL7Exception {
        int i;
        String[] childNames = groupObject.getNames();
        String messageName = groupObject.getMessage().getName();
        NodeList allChildNodes = groupElement.getChildNodes();
        ArrayList<String> unparsedElementList = new ArrayList<String>();
        for (i = 0; i < allChildNodes.getLength(); ++i) {
            Node node = allChildNodes.item(i);
            String name = node.getNodeName();
            if (node.getNodeType() != 1 || unparsedElementList.contains(name)) continue;
            unparsedElementList.add(name);
        }
        for (i = 0; i < childNames.length; ++i) {
            unparsedElementList.remove(childNames[i]);
            if (childNames[i].length() != 4) {
                this.parseReps(groupElement, groupObject, messageName, childNames[i], childNames[i]);
                continue;
            }
            log.debug("Skipping rep segment: {}", (Object)childNames[i]);
        }
        for (i = 0; i < unparsedElementList.size(); ++i) {
            String segName = (String)unparsedElementList.get(i);
            String segIndexName = groupObject.addNonstandardSegment(segName);
            this.parseReps(groupElement, groupObject, messageName, segName, segIndexName);
        }
    }

    private void parseReps(Element groupElement, Group groupObject, String messageName, String childName, String childIndexName) throws HL7Exception {
        block7: {
            List<Element> reps;
            block6: {
                reps = this.getChildElementsByTagName(groupElement, DefaultXMLParser.makeGroupElementName(messageName, childName));
                log.debug("# of elements matching {}: {}", (Object)DefaultXMLParser.makeGroupElementName(messageName, childName), (Object)reps.size());
                if (!groupObject.isRepeating(childIndexName)) break block6;
                for (int i = 0; i < reps.size(); ++i) {
                    this.parseRep(reps.get(i), groupObject.get(childIndexName, i));
                }
                break block7;
            }
            if (reps.size() > 0) {
                this.parseRep(reps.get(0), groupObject.get(childIndexName, 0));
            }
            if (reps.size() <= 1) break block7;
            String newIndexName = "";
            int i = 1;
            try {
                for (i = 1; i < reps.size(); ++i) {
                    newIndexName = childName + (i + 1);
                    Structure st = groupObject.get(newIndexName);
                    this.parseRep(reps.get(i), st);
                }
            }
            catch (Throwable t) {
                log.info("Issue Parsing: " + t);
                newIndexName = groupObject.addNonstandardSegment(childName);
                for (int j = i; j < reps.size(); ++j) {
                    this.parseRep(reps.get(j), groupObject.get(newIndexName, j - i));
                }
            }
        }
    }

    private void parseRep(Element theElem, Structure theObj) throws HL7Exception {
        if (theObj instanceof Group) {
            this.parse((Group)theObj, theElem);
        } else if (theObj instanceof Segment) {
            this.parse((Segment)theObj, theElem);
        }
        log.debug("Parsed element: {}", (Object)theElem.getNodeName());
    }

    private List<Element> getChildElementsByTagName(Element theElement, String theName) {
        ArrayList<Element> result = new ArrayList<Element>(10);
        NodeList children = theElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals(theName)) continue;
            result.add((Element)child);
        }
        return result;
    }

    protected static String makeGroupElementName(String messageName, String className) {
        String ret = null;
        if (className.length() > 4 || ourForceGroupNames.contains(className)) {
            StringBuilder elementName = new StringBuilder();
            elementName.append(messageName);
            elementName.append('.');
            elementName.append(className);
            ret = elementName.toString();
        } else {
            ret = className.length() == 4 ? className.substring(0, 3) : className;
        }
        return ret;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: DefaultXMLParser pipe_encoded_file");
            System.exit(1);
        }
        try {
            File messageFile = new File(args[0]);
            long fileLength = messageFile.length();
            FileReader r = new FileReader(messageFile);
            char[] cbuf = new char[(int)fileLength];
            System.out.println("Reading message file ... " + r.read(cbuf) + " of " + fileLength + " chars");
            r.close();
            String messString = String.valueOf(cbuf);
            Parser inParser = null;
            Parser outParser = null;
            PipeParser pp = new PipeParser();
            DefaultXMLParser xp = new DefaultXMLParser();
            System.out.println("Encoding: " + pp.getEncoding(messString));
            if (pp.getEncoding(messString) != null) {
                inParser = pp;
                outParser = xp;
            } else if (xp.getEncoding(messString) != null) {
                inParser = xp;
                outParser = pp;
            }
            Message mess = ((Parser)inParser).parse(messString);
            System.out.println("Got message of type " + mess.getClass().getName());
            String otherEncoding = outParser.encode(mess);
            System.out.println(otherEncoding);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void parse(Message theMessage, String theString) throws HL7Exception {
        Document doc = this.parseStringIntoDocument(theString);
        this.parse((Group)theMessage, doc.getDocumentElement());
    }

    static {
        ourForceGroupNames.add("DIET");
    }
}

