/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.Terser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastParser
extends Parser {
    private static final Logger ourLog = LoggerFactory.getLogger(FastParser.class);
    private static char ourSegmentSeparator = (char)13;
    private Map<Object, StructRef> myEventGuideMap;
    private PipeParser myPipeParser;

    public FastParser(Map<Object, StructRef> theEventGuideMap) {
        this(null, theEventGuideMap);
    }

    public FastParser(ModelClassFactory theFactory, Map<Object, StructRef> theEventGuideMap) {
        super(theFactory);
        this.myEventGuideMap = theEventGuideMap;
        this.myPipeParser = new PipeParser();
    }

    public static Map<Object, StructRef> loadEventGuideMap(URL theMapURL) throws HL7Exception {
        HashMap<Object, StructRef> result = new HashMap<Object, StructRef>();
        try {
            URLConnection conn = theMapURL.openConnection();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String eventName = null;
            StringBuffer spec = new StringBuffer();
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.length() == 0) {
                    FastParser.finish(eventName, spec, result);
                    eventName = null;
                    spec = new StringBuffer();
                    continue;
                }
                if (eventName == null) {
                    eventName = line;
                    continue;
                }
                spec.append(line + "\r");
            }
            reader.close();
            FastParser.finish(eventName, spec, result);
        }
        catch (IOException e) {
            throw new HL7Exception(e);
        }
        return result;
    }

    private static void finish(String theEventName, StringBuffer theSpec, Map<Object, StructRef> theMap) {
        if (theEventName != null) {
            RootRef root = FastParser.parseGuide(theSpec.toString());
            theMap.put(theEventName, root);
        }
    }

    private static RootRef parseGuide(String theSpec) {
        StringTokenizer lines = new StringTokenizer(theSpec, "\r", false);
        RootRef result = new RootRef();
        Stack<StructRef> ancestry = new Stack<StructRef>();
        ancestry.push(result);
        HashMap<Object, StructRef> successors = new HashMap<Object, StructRef>();
        StructRef previous = result;
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken();
            StringTokenizer parts = new StringTokenizer(line, "\t ", false);
            String segName = parts.nextToken();
            String path = parts.hasMoreTokens() ? parts.nextToken() : "";
            parts = new StringTokenizer(path, ":", false);
            path = parts.hasMoreTokens() ? parts.nextToken() : null;
            int[] fields = FastParser.getFieldList(parts.hasMoreTokens() ? parts.nextToken() : "");
            if (segName.equals("}")) {
                StructRef parent = (StructRef)ancestry.pop();
                if (parent.getChildName() == null || parent.getRelativePath().indexOf(42) < 0) continue;
                previous.setSuccessor(parent.getChildName(), parent);
                continue;
            }
            boolean isSegment = !segName.equals("{");
            StructRef ref = new StructRef((StructRef)ancestry.peek(), path, isSegment, fields);
            if (isSegment) {
                previous.setSuccessor(segName, ref);
                if (path.indexOf(42) >= 0) {
                    ref.setSuccessor(segName, ref);
                }
                FastParser.setGroupSuccessors(successors, segName);
            } else {
                successors.put(previous, ref);
            }
            if (!isSegment) {
                ancestry.push(ref);
            }
            previous = ref;
        }
        return result;
    }

    private static void setGroupSuccessors(Map<Object, StructRef> theSuccessors, String theSegName) {
        for (StructRef structRef : theSuccessors.keySet()) {
            StructRef to = theSuccessors.get(structRef);
            structRef.setSuccessor(theSegName, to);
        }
        theSuccessors.clear();
    }

    private static int[] getFieldList(String theSpec) {
        StringTokenizer tok = new StringTokenizer(theSpec, ",", false);
        ArrayList<Integer> fieldList = new ArrayList<Integer>(30);
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            int index = token.indexOf(45);
            if (index >= 0) {
                int start = Integer.parseInt(token.substring(0, index));
                int end = Integer.parseInt(token.substring(index + 1));
                for (int i = start; i <= end; ++i) {
                    fieldList.add(new Integer(i));
                }
                continue;
            }
            fieldList.add(Integer.valueOf(token));
        }
        int[] result = new int[fieldList.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)fieldList.get(i);
        }
        return result;
    }

    @Override
    public String getEncoding(String message) {
        return this.myPipeParser.getEncoding(message);
    }

    @Override
    public boolean supportsEncoding(String encoding) {
        return this.myPipeParser.supportsEncoding(encoding);
    }

    @Override
    public String getDefaultEncoding() {
        return "VB";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Message doParse(String message, String version) throws HL7Exception, EncodingNotSupportedException {
        Message result = null;
        char fieldSep = message.charAt(3);
        EncodingCharacters ec = new EncodingCharacters(fieldSep, message.substring(4, 8));
        StringTokenizer tok = new StringTokenizer(message.substring(4), String.valueOf(new char[]{fieldSep, ourSegmentSeparator}), true);
        String[] mshFields = this.getMSHFields(tok, fieldSep);
        Object[] structure = this.getStructure(mshFields[8], ec.getComponentSeparator());
        StructRef root = this.myEventGuideMap.get(structure[0]);
        if (root == null) {
            ourLog.debug("FastParser delegating to PipeParser because no metadata available for event {}", structure[0]);
            result = this.myPipeParser.parse(message);
        } else {
            result = this.instantiateMessage((String)structure[1], version, (Boolean)structure[2]);
            StructRef mshRef = null;
            StructRef structRef = root;
            synchronized (structRef) {
                mshRef = root.getSuccessor("MSH");
                root.reset();
            }
            Segment msh = (Segment)result.get("MSH");
            for (int i = 0; i < mshRef.getFields().length; ++i) {
                int fieldNum = mshRef.getFields()[i];
                this.parse(mshFields[fieldNum - 1], msh, fieldNum, ec);
            }
            this.parse(tok, result, root, ec);
        }
        return result;
    }

    private String[] getMSHFields(StringTokenizer tok, char fieldSep) {
        String[] result = new String[21];
        result[0] = String.valueOf(fieldSep);
        String token = null;
        int field = 1;
        while (tok.hasMoreTokens() && (token = tok.nextToken()).charAt(0) != ourSegmentSeparator) {
            if (token.charAt(0) == fieldSep) {
                ++field;
                continue;
            }
            result[field] = token;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(StringTokenizer tok, Message message, StructRef root, EncodingCharacters ec) throws HL7Exception {
        Terser t = new Terser(message);
        StructRef structRef = root;
        synchronized (structRef) {
            StructRef ref = root.getSuccessor("MSH");
            int field = 0;
            Segment segment = null;
            int[] fields = new int[]{};
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                if (token.charAt(0) == ec.getFieldSeparator()) {
                    ++field;
                    continue;
                }
                if (token.charAt(0) == ourSegmentSeparator) {
                    field = 0;
                    continue;
                }
                if (field == 0) {
                    StructRef newref = this.drill(ref, token);
                    if (newref == null) {
                        segment = null;
                        fields = new int[]{};
                        continue;
                    }
                    ref = newref;
                    ourLog.debug("Parsing into segment {}", (Object)ref.getFullPath());
                    segment = t.getSegment(ref.getFullPath());
                    fields = ref.getFields();
                    continue;
                }
                if (segment == null || Arrays.binarySearch(fields, field) < 0) continue;
                this.parse(token, segment, field, ec);
            }
            root.reset();
        }
    }

    private StructRef drill(StructRef ref, String name) {
        for (ref = ref.getSuccessor(name); ref != null && !ref.isSegment(); ref = ref.getSuccessor(name)) {
        }
        return ref;
    }

    private void parse(String field, Segment segment, int num, EncodingCharacters ec) throws HL7Exception {
        if (field != null) {
            int rep = 0;
            int component = 1;
            int subcomponent = 1;
            Type type = segment.getField(num, rep);
            String delim = String.valueOf(new char[]{ec.getRepetitionSeparator(), ec.getComponentSeparator(), ec.getSubcomponentSeparator()});
            StringTokenizer tok = new StringTokenizer(field, delim, true);
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                char c = token.charAt(0);
                if (c == ec.getRepetitionSeparator()) {
                    component = 1;
                    subcomponent = 1;
                    type = segment.getField(num, ++rep);
                    continue;
                }
                if (c == ec.getComponentSeparator()) {
                    ++component;
                    subcomponent = 1;
                    continue;
                }
                if (c == ec.getSubcomponentSeparator()) {
                    ++subcomponent;
                    continue;
                }
                Primitive p = Terser.getPrimitive(type, component, subcomponent);
                p.setValue(token);
            }
        }
    }

    private Object[] getStructure(String msh9, char compSep) throws HL7Exception {
        boolean explicitlyDefined;
        String structure = null;
        String event = null;
        String[] components = new String[3];
        StringTokenizer tok = new StringTokenizer(msh9, String.valueOf(compSep), true);
        int i = 0;
        while (tok.hasMoreTokens() && i < components.length) {
            String token = tok.nextToken();
            if (token.charAt(0) == compSep) {
                ++i;
                continue;
            }
            components[i] = token;
        }
        boolean bl = explicitlyDefined = components[2] != null;
        if (explicitlyDefined) {
            structure = components[2];
        } else if (components[0] != null && components[0].equals("ACK")) {
            structure = "ACK";
        } else if (components[0] != null && components[1] != null) {
            structure = components[0] + "_" + components[1];
        } else {
            throw new HL7Exception("Can't determine message structure from MSH-9: " + msh9, 200);
        }
        event = components[1] == null ? components[0] : components[0] + "^" + components[1];
        return new Object[]{event, structure, explicitlyDefined};
    }

    @Override
    protected String doEncode(Message source, String encoding) throws HL7Exception, EncodingNotSupportedException {
        return this.myPipeParser.doEncode(source, encoding);
    }

    @Override
    protected String doEncode(Message source) throws HL7Exception {
        return this.myPipeParser.doEncode(source);
    }

    @Override
    public Segment getCriticalResponseData(String message) throws HL7Exception {
        return this.myPipeParser.getCriticalResponseData(message);
    }

    @Override
    public String getAckID(String message) {
        return this.myPipeParser.getAckID(message);
    }

    @Override
    public String getVersion(String message) throws HL7Exception {
        return this.myPipeParser.getVersion(message);
    }

    @Override
    public String doEncode(Segment structure, EncodingCharacters encodingCharacters) throws HL7Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String doEncode(Type type, EncodingCharacters encodingCharacters) throws HL7Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void parse(Type type, String string, EncodingCharacters encodingCharacters) throws HL7Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void parse(Segment segment, String string, EncodingCharacters encodingCharacters) throws HL7Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void parse(Message message, String string) throws HL7Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected Message doParseForSpecificPackage(String theMessage, String theVersion, String thePackageName) throws HL7Exception, EncodingNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static class RootRef
    extends StructRef {
        public RootRef() {
            super(null, "", false, null);
        }

        public String getFullPath() {
            return "";
        }
    }

    public static class StructRef {
        private StructRef myParent;
        private String myRelativePath;
        private Map<Object, StructRef> mySuccessors;
        private int myRep;
        private boolean mySegmentFlag;
        private int[] myFields;
        private List<StructRef> myChildren;

        public StructRef(StructRef theParent, String theRelativePath, boolean isSegment, int[] theFields) {
            this.myParent = theParent;
            this.myChildren = new ArrayList<StructRef>();
            if (this.myParent != null) {
                this.myParent.addChild(this);
            }
            this.myRelativePath = theRelativePath;
            if (!this.myRelativePath.startsWith("/")) {
                this.myRelativePath = "/" + this.myRelativePath;
            }
            this.mySegmentFlag = isSegment;
            this.mySuccessors = new HashMap<Object, StructRef>();
            this.myRep = -1;
            if (this.mySegmentFlag) {
                this.myFields = theFields;
                Arrays.sort(this.myFields);
            } else {
                this.myFields = new int[0];
            }
        }

        public void setSuccessor(String theName, StructRef theSuccessor) {
            this.mySuccessors.put(theName, theSuccessor);
        }

        public String getFullPath() {
            return this.myParent.getFullPath() + this.myRelativePath.replaceAll("\\*", String.valueOf(this.myRep));
        }

        public String getRelativePath() {
            return this.myRelativePath;
        }

        public StructRef getSuccessor(String theName) {
            StructRef ref = this.mySuccessors.get(theName);
            if (ref != null) {
                ref.next();
            }
            return ref;
        }

        public String getChildName() {
            String result = null;
            if (!this.mySegmentFlag && !this.mySuccessors.isEmpty()) {
                result = (String)this.mySuccessors.keySet().iterator().next();
            }
            return result;
        }

        public boolean isSegment() {
            return this.mySegmentFlag;
        }

        private void next() {
            ++this.myRep;
            this.resetChildren();
        }

        private void addChild(StructRef theChild) {
            if (!this.isSegment()) {
                this.myChildren.add(theChild);
            }
        }

        public void reset() {
            this.myRep = -1;
            this.resetChildren();
        }

        private void resetChildren() {
            for (int i = 0; i < this.myChildren.size(); ++i) {
                StructRef child = this.myChildren.get(i);
                child.reset();
            }
        }

        public int[] getFields() {
            return this.myFields;
        }
    }
}

