/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.VersionLogger;
import ca.uhn.hl7v2.model.GenericMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.ParserConfiguration;
import ca.uhn.hl7v2.validation.MessageValidator;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.impl.ValidationContextFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Parser {
    private static final Logger log = LoggerFactory.getLogger(Parser.class);
    private static Map<String, Properties> messageStructures = null;
    private ModelClassFactory myFactory;
    private ValidationContext myContext;
    private MessageValidator myValidator;
    private ParserConfiguration myParserConfiguration = new ParserConfiguration();

    public Parser() {
        this(null);
    }

    public Parser(ModelClassFactory theFactory) {
        ValidationContext validationContext;
        if (theFactory == null) {
            theFactory = new DefaultModelClassFactory();
        }
        this.myFactory = theFactory;
        try {
            validationContext = ValidationContextFactory.getContext();
        }
        catch (ValidationException e) {
            log.warn("Failed to get a validation context from the ValidationContextFactory", (Throwable)e);
            validationContext = ValidationContextFactory.defaultValidation();
        }
        this.setValidationContext(validationContext);
    }

    public ModelClassFactory getFactory() {
        return this.myFactory;
    }

    public ValidationContext getValidationContext() {
        return this.myContext;
    }

    public void setValidationContext(ValidationContext theContext) {
        this.myContext = theContext;
        this.myValidator = new MessageValidator(theContext, true);
    }

    public ParserConfiguration getParserConfiguration() {
        return this.myParserConfiguration;
    }

    public void setParserConfiguration(ParserConfiguration theParserConfiguration) {
        if (theParserConfiguration == null) {
            throw new NullPointerException("theParserConfiguration may not be null");
        }
        this.myParserConfiguration = theParserConfiguration;
    }

    public abstract String getEncoding(String var1);

    public abstract boolean supportsEncoding(String var1);

    public abstract String getDefaultEncoding();

    public Message parse(String message) throws HL7Exception, EncodingNotSupportedException {
        String encoding = this.getEncoding(message);
        if (!this.supportsEncoding(encoding)) {
            throw new EncodingNotSupportedException("Can't parse message beginning " + message.substring(0, Math.min(message.length(), 50)));
        }
        String version = this.getVersion(message);
        if (!Parser.validVersion(version)) {
            throw new HL7Exception("Can't process message of version '" + version + "' - version not recognized", 203);
        }
        this.myValidator.validate(message, encoding.equals("XML"), version);
        Message result = this.doParse(message, version);
        this.myValidator.validate(result);
        result.setParser(this);
        return result;
    }

    protected abstract Message doParse(String var1, String var2) throws HL7Exception, EncodingNotSupportedException;

    public String encode(Message source, String encoding) throws HL7Exception, EncodingNotSupportedException {
        this.myValidator.validate(source);
        String result = this.doEncode(source, encoding);
        this.myValidator.validate(result, encoding.equals("XML"), source.getVersion());
        return result;
    }

    protected abstract String doEncode(Message var1, String var2) throws HL7Exception, EncodingNotSupportedException;

    public String encode(Message source) throws HL7Exception {
        String encoding = this.getDefaultEncoding();
        this.myValidator.validate(source);
        String result = this.doEncode(source);
        this.myValidator.validate(result, encoding.equals("XML"), source.getVersion());
        return result;
    }

    protected abstract String doEncode(Message var1) throws HL7Exception;

    public abstract Segment getCriticalResponseData(String var1) throws HL7Exception;

    public abstract String getAckID(String var1);

    public abstract String getVersion(String var1) throws HL7Exception;

    public abstract String doEncode(Segment var1, EncodingCharacters var2) throws HL7Exception;

    public abstract String doEncode(Type var1, EncodingCharacters var2) throws HL7Exception;

    public abstract void parse(Type var1, String var2, EncodingCharacters var3) throws HL7Exception;

    public Message parseForSpecificPackage(String message, String packageName) throws HL7Exception, EncodingNotSupportedException {
        String encoding = this.getEncoding(message);
        if (!this.supportsEncoding(encoding)) {
            throw new EncodingNotSupportedException("Can't parse message beginning " + message.substring(0, Math.min(message.length(), 50)));
        }
        String version = this.getVersion(message);
        if (!Parser.validVersion(version)) {
            throw new HL7Exception("Can't process message of version '" + version + "' - version not recognized", 203);
        }
        this.myValidator.validate(message, encoding.equals("XML"), version);
        Message result = this.doParseForSpecificPackage(message, version, packageName);
        this.myValidator.validate(result);
        result.setParser(this);
        return result;
    }

    protected abstract Message doParseForSpecificPackage(String var1, String var2, String var3) throws HL7Exception, EncodingNotSupportedException;

    protected Message instantiateMessageInASpecificPackage(String theName, String theVersion, boolean isExplicit, String packageName) throws HL7Exception {
        Message result = null;
        try {
            Class<? extends Message> messageClass = this.myFactory.getMessageClassInASpecificPackage(theName, theVersion, isExplicit, packageName);
            if (messageClass == null) {
                throw new ClassNotFoundException("Can't find message class in current package list: " + theName);
            }
            log.debug("Instantiating msg of class {}", (Object)messageClass.getName());
            Constructor<? extends Message> constructor = messageClass.getConstructor(ModelClassFactory.class);
            result = constructor.newInstance(this.myFactory);
        }
        catch (Exception e) {
            throw new HL7Exception("Couldn't create Message object of type " + theName, 200, e);
        }
        result.setValidationContext(this.myContext);
        return result;
    }

    public abstract void parse(Segment var1, String var2, EncodingCharacters var3) throws HL7Exception;

    public abstract void parse(Message var1, String var2) throws HL7Exception;

    public static Segment makeControlMSH(String version, ModelClassFactory factory) throws HL7Exception {
        Segment msh = null;
        try {
            Message dummy = GenericMessage.getGenericMessageClass(version).getConstructor(ModelClassFactory.class).newInstance(factory);
            Class[] constructorParamTypes = new Class[]{Group.class, ModelClassFactory.class};
            Object[] constructorParamArgs = new Object[]{dummy, factory};
            Class<? extends Segment> c = factory.getSegmentClass("MSH", version);
            Constructor<? extends Segment> constructor = c.getConstructor(constructorParamTypes);
            msh = constructor.newInstance(constructorParamArgs);
        }
        catch (Exception e) {
            throw new HL7Exception("Couldn't create MSH for version " + version + " (does your classpath include this version?) ... ", 207, e);
        }
        return msh;
    }

    public static boolean validVersion(String version) {
        return Version.supportsVersion(version);
    }

    public static String getMessageStructureForEvent(String name, String version) throws HL7Exception {
        String structure = null;
        if (!Parser.validVersion(version)) {
            throw new HL7Exception("The version " + version + " is unknown");
        }
        Properties p = null;
        try {
            p = Parser.getMessageStructures().get(version);
            if (p == null) {
                throw new HL7Exception("No map found for version " + version + ". Only the following are available: " + Parser.getMessageStructures().keySet());
            }
        }
        catch (IOException ioe) {
            throw new HL7Exception(ioe);
        }
        structure = p.getProperty(name);
        if (structure == null) {
            structure = name;
        }
        return structure;
    }

    public static Properties getMessageStructures(String version) throws IOException {
        Map<String, Properties> msgStructures = Parser.getMessageStructures();
        if (!msgStructures.containsKey(version)) {
            return null;
        }
        return (Properties)msgStructures.get(version).clone();
    }

    private static synchronized Map<String, Properties> getMessageStructures() throws IOException {
        if (messageStructures == null) {
            messageStructures = Parser.loadMessageStructures();
        }
        return messageStructures;
    }

    private static Map<String, Properties> loadMessageStructures() throws IOException {
        HashMap<String, Properties> map = new HashMap<String, Properties>();
        for (Version v : Version.values()) {
            String resource = "ca/uhn/hl7v2/parser/eventmap/" + v.getVersion() + ".properties";
            InputStream in = Parser.class.getClassLoader().getResourceAsStream(resource);
            Properties structures = null;
            if (in == null) continue;
            structures = new Properties();
            structures.load(in);
            map.put(v.getVersion(), structures);
        }
        return map;
    }

    protected Message instantiateMessage(String theName, String theVersion, boolean isExplicit) throws HL7Exception {
        Message result = null;
        try {
            Class<? extends Message> messageClass = this.myFactory.getMessageClass(theName, theVersion, isExplicit);
            if (messageClass == null) {
                throw new ClassNotFoundException("Can't find message class in current package list: " + theName);
            }
            log.debug("Instantiating msg of class {}", (Object)messageClass.getName());
            Constructor<? extends Message> constructor = messageClass.getConstructor(ModelClassFactory.class);
            result = constructor.newInstance(this.myFactory);
        }
        catch (Exception e) {
            throw new HL7Exception("Couldn't create Message object of type " + theName, 200, e);
        }
        result.setValidationContext(this.myContext);
        return result;
    }

    static {
        VersionLogger.init();
    }
}

