/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.protocol.impl;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.DefaultApplication;
import ca.uhn.hl7v2.app.Responder;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.protocol.ApplicationRouter;
import ca.uhn.hl7v2.protocol.ReceivingApplication;
import ca.uhn.hl7v2.protocol.Transportable;
import ca.uhn.hl7v2.protocol.impl.AppRoutingDataImpl;
import ca.uhn.hl7v2.protocol.impl.AppWrapper;
import ca.uhn.hl7v2.protocol.impl.ParseChecker;
import ca.uhn.hl7v2.protocol.impl.TransportableImpl;
import ca.uhn.hl7v2.util.Terser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationRouterImpl
implements ApplicationRouter {
    private static final Logger log = LoggerFactory.getLogger(ApplicationRouterImpl.class);
    public static String RAW_MESSAGE_KEY = "raw-message";
    private List<Binding> myBindings;
    private Parser myParser;

    public ApplicationRouterImpl() {
        this.init(new GenericParser());
    }

    public ApplicationRouterImpl(Parser theParser) {
        this.init(theParser);
    }

    private void init(Parser theParser) {
        this.myBindings = new ArrayList<Binding>(20);
        this.myParser = theParser;
    }

    @Override
    public Transportable processMessage(Transportable theMessage) throws HL7Exception {
        String[] result = this.processMessage(theMessage.getMessage(), theMessage.getMetadata());
        TransportableImpl response = new TransportableImpl(result[0]);
        if (result[1] != null) {
            response.getMetadata().put("MSH-18", result[1]);
        }
        return response;
    }

    private String[] processMessage(String incomingMessageString, Map<String, Object> theMetadata) throws HL7Exception {
        Logger rawOutbound = LoggerFactory.getLogger((String)"ca.uhn.hl7v2.raw.outbound");
        Logger rawInbound = LoggerFactory.getLogger((String)"ca.uhn.hl7v2.raw.inbound");
        log.info("ApplicationRouterImpl got message: {}", (Object)incomingMessageString);
        rawInbound.info(incomingMessageString);
        Message incomingMessageObject = null;
        String outgoingMessageString = null;
        String outgoingMessageCharset = null;
        try {
            incomingMessageObject = this.myParser.parse(incomingMessageString);
        }
        catch (HL7Exception e) {
            outgoingMessageString = Responder.logAndMakeErrorMessage(e, this.myParser.getCriticalResponseData(incomingMessageString), this.myParser, this.myParser.getEncoding(incomingMessageString));
        }
        if (outgoingMessageString == null) {
            try {
                String check = System.getProperty("ca.uhn.hl7v2.protocol.impl.check_parse");
                if (check != null && check.equals("TRUE")) {
                    ParseChecker.checkParse(incomingMessageString, incomingMessageObject, this.myParser);
                }
                ReceivingApplication app = this.findApplication(incomingMessageObject);
                theMetadata.put(RAW_MESSAGE_KEY, incomingMessageString);
                log.debug("Sending message to application: {}", (Object)app.toString());
                Message response = app.processMessage(incomingMessageObject, theMetadata);
                outgoingMessageString = this.myParser.encode(response, this.myParser.getEncoding(incomingMessageString));
                Terser t = new Terser(response);
                outgoingMessageCharset = t.get("MSH-18");
            }
            catch (Exception e) {
                outgoingMessageString = Responder.logAndMakeErrorMessage(e, (Segment)incomingMessageObject.get("MSH"), this.myParser, this.myParser.getEncoding(incomingMessageString));
            }
        }
        log.info("ApplicationRouterImpl sending message: {}", outgoingMessageString);
        rawOutbound.info(outgoingMessageString);
        return new String[]{outgoingMessageString, outgoingMessageCharset};
    }

    @Override
    public boolean hasActiveBinding(ApplicationRouter.AppRoutingData theRoutingData) {
        boolean result = false;
        ReceivingApplication app = this.findDestination(theRoutingData);
        if (app != null) {
            result = true;
        }
        return result;
    }

    private ReceivingApplication findDestination(ApplicationRouter.AppRoutingData theRoutingData) {
        ReceivingApplication result = null;
        for (int i = 0; i < this.myBindings.size() && result == null; ++i) {
            Binding binding = this.myBindings.get(i);
            if (!ApplicationRouterImpl.matches(theRoutingData, binding.routingData) || !binding.active) continue;
            result = binding.application;
        }
        return result;
    }

    private Binding findBinding(ApplicationRouter.AppRoutingData theRoutingData) {
        Binding result = null;
        for (int i = 0; i < this.myBindings.size() && result == null; ++i) {
            Binding binding = this.myBindings.get(i);
            if (!theRoutingData.equals(binding.routingData)) continue;
            result = binding;
        }
        return result;
    }

    @Override
    public void bindApplication(ApplicationRouter.AppRoutingData theRoutingData, ReceivingApplication theApplication) {
        Binding binding = new Binding(theRoutingData, true, theApplication);
        this.myBindings.add(binding);
    }

    @Override
    public void disableBinding(ApplicationRouter.AppRoutingData theRoutingData) {
        Binding b = this.findBinding(theRoutingData);
        if (b != null) {
            b.active = false;
        }
    }

    @Override
    public void enableBinding(ApplicationRouter.AppRoutingData theRoutingData) {
        Binding b = this.findBinding(theRoutingData);
        if (b != null) {
            b.active = true;
        }
    }

    @Override
    public Parser getParser() {
        return this.myParser;
    }

    public static boolean matches(ApplicationRouter.AppRoutingData theMessageData, ApplicationRouter.AppRoutingData theReferenceData) {
        boolean result = false;
        ApplicationRouter.AppRoutingData ref = theReferenceData;
        ApplicationRouter.AppRoutingData msg = theMessageData;
        if (ApplicationRouterImpl.matches(msg.getMessageType(), ref.getMessageType()) && ApplicationRouterImpl.matches(msg.getTriggerEvent(), ref.getTriggerEvent()) && ApplicationRouterImpl.matches(msg.getProcessingId(), ref.getProcessingId()) && ApplicationRouterImpl.matches(msg.getVersion(), ref.getVersion())) {
            result = true;
        }
        return result;
    }

    private static boolean matches(String theMessageData, String theReferenceData) {
        boolean result = false;
        if (theMessageData.equals(theReferenceData) || theReferenceData.equals("*") || Pattern.matches(theReferenceData, theMessageData)) {
            result = true;
        }
        return result;
    }

    private ReceivingApplication findApplication(Message theMessage) throws HL7Exception {
        Terser t = new Terser(theMessage);
        AppRoutingDataImpl msgData = new AppRoutingDataImpl(t.get("/MSH-9-1"), t.get("/MSH-9-2"), t.get("/MSH-11-1"), t.get("/MSH-12"));
        ReceivingApplication app = this.findDestination(msgData);
        if (app == null) {
            app = new AppWrapper(new DefaultApplication());
        }
        return app;
    }

    private static class Binding {
        public ApplicationRouter.AppRoutingData routingData;
        public boolean active;
        public ReceivingApplication application;

        public Binding(ApplicationRouter.AppRoutingData theRoutingData, boolean isActive, ReceivingApplication theApplication) {
            this.routingData = theRoutingData;
            this.active = isActive;
            this.application = theApplication;
        }
    }
}

