/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.Hl7InputStreamMessageStringIterator;
import ca.uhn.hl7v2.validation.impl.ValidationContextImpl;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hl7InputStreamMessageIterator
implements Iterator<Message> {
    private PipeParser myParser;
    private Hl7InputStreamMessageStringIterator myWrapped;

    public Hl7InputStreamMessageIterator(InputStream theInputStream) {
        this.myWrapped = new Hl7InputStreamMessageStringIterator(theInputStream);
        this.init();
    }

    public Hl7InputStreamMessageIterator(Reader theReader) {
        this.myWrapped = new Hl7InputStreamMessageStringIterator(theReader);
        this.init();
    }

    @Override
    public boolean hasNext() {
        return this.myWrapped.hasNext();
    }

    private void init() {
        this.myParser = new PipeParser();
        this.myParser.setValidationContext(new ValidationContextImpl());
    }

    @Override
    public Message next() {
        Message retVal;
        String nextString = this.myWrapped.next();
        try {
            retVal = this.myParser.parse(nextString);
        }
        catch (EncodingNotSupportedException e) {
            throw new Hl7InputStreamMessageStringIterator.ParseFailureError("Failed to parse message", e);
        }
        catch (HL7Exception e) {
            throw new Hl7InputStreamMessageStringIterator.ParseFailureError("Failed to parse message", e);
        }
        return retVal;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void setIgnoreComments(boolean theIgnoreComments) {
        this.myWrapped.setIgnoreComments(theIgnoreComments);
    }
}

