/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hl7InputStreamReader {
    private static final Logger ourLog = LoggerFactory.getLogger(Hl7InputStreamReader.class);

    public static String[] read(InputStream theMsgInputStream) throws FileNotFoundException, IOException {
        BufferedReader in = new BufferedReader(new CommentFilterReader(new InputStreamReader(theMsgInputStream)));
        StringBuffer rawMsgBuffer = new StringBuffer();
        int c = 0;
        while ((c = in.read()) >= 0) {
            rawMsgBuffer.append((char)c);
        }
        String[] messages = Hl7InputStreamReader.getHL7Messages(rawMsgBuffer.toString());
        ourLog.info(messages.length + " messages sent.");
        return messages;
    }

    private static String[] getHL7Messages(String theSource) {
        ArrayList<String> messages = new ArrayList<String>(20);
        Pattern startPattern = Pattern.compile("^MSH", 8);
        Matcher startMatcher = startPattern.matcher(theSource);
        while (startMatcher.find()) {
            String messageExtent = Hl7InputStreamReader.getMessageExtent(theSource.substring(startMatcher.start()), startPattern);
            char fieldDelim = messageExtent.charAt(3);
            Pattern segmentPattern = Pattern.compile("^[A-Z]{3}\\" + fieldDelim + ".*$", 8);
            Matcher segmentMatcher = segmentPattern.matcher(messageExtent);
            StringBuffer msg = new StringBuffer();
            while (segmentMatcher.find()) {
                msg.append(segmentMatcher.group().trim());
                msg.append('\r');
            }
            messages.add(msg.toString());
        }
        return messages.toArray(new String[0]);
    }

    private static String getMessageExtent(String theSource, Pattern theStartPattern) {
        Matcher startMatcher = theStartPattern.matcher(theSource);
        if (!startMatcher.find()) {
            throw new IllegalArgumentException(theSource + "does not contain message start pattern" + theStartPattern.toString());
        }
        int start = startMatcher.start();
        int end = theSource.length();
        if (startMatcher.find()) {
            end = startMatcher.start();
        }
        return theSource.substring(start, end).trim();
    }

    private static class CommentFilterReader
    extends PushbackReader {
        private final char[] startCPPComment = new char[]{'/', '*'};
        private final char[] endCPPComment = new char[]{'*', '/'};
        private final char[] startCComment = new char[]{'/', '/'};
        private final char[] endCComment = new char[]{'\n'};
        private final char[] protocolDelim = new char[]{':', '/', '/'};

        public CommentFilterReader(Reader in) {
            super(in, 5);
        }

        public int read() throws IOException {
            int ret;
            if (!this.atSequence(this.protocolDelim)) {
                int i;
                if (this.atSequence(this.startCPPComment)) {
                    while (!this.atSequence(this.endCPPComment)) {
                        super.read();
                    }
                    for (i = 0; i < this.endCPPComment.length; ++i) {
                        super.read();
                    }
                } else if (this.atSequence(this.startCComment)) {
                    while (!this.atSequence(this.endCComment)) {
                        super.read();
                    }
                    for (i = 0; i < this.endCComment.length; ++i) {
                        super.read();
                    }
                }
            }
            if ((ret = super.read()) == 65535) {
                ret = -1;
            }
            return ret;
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            int i = -1;
            boolean done = false;
            while (++i < len) {
                int next = this.read();
                if (next == 65535 || next == -1) {
                    done = true;
                    break;
                }
                cbuf[off + i] = (char)next;
            }
            if (i == 0 && done) {
                i = -1;
            }
            return i;
        }

        private boolean atSequence(char[] sequence) throws IOException {
            boolean result = true;
            int i = -1;
            int[] data = new int[sequence.length];
            while (++i < sequence.length && result) {
                data[i] = super.read();
                if ((char)data[i] == sequence[i]) continue;
                result = false;
            }
            for (int j = i - 1; j >= 0; --j) {
                this.unread(data[j]);
            }
            return result;
        }
    }
}

