/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.FilterIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyMessageIterator
implements Iterator<Structure> {
    private List<Structure> myRemaining = new ArrayList<Structure>(40);

    public ReadOnlyMessageIterator(Group theRoot) {
        this.addChildren(theRoot);
    }

    public static Iterator<Structure> createPopulatedSegmentIterator(Group theRoot) {
        ReadOnlyMessageIterator allIterator = new ReadOnlyMessageIterator(theRoot);
        FilterIterator.Predicate<Structure> segmentsOnly = new FilterIterator.Predicate<Structure>(){

            @Override
            public boolean evaluate(Structure obj) {
                return Segment.class.isAssignableFrom(obj.getClass());
            }
        };
        FilterIterator<Structure> segmentIterator = new FilterIterator<Structure>(allIterator, segmentsOnly);
        final EncodingCharacters ec = new EncodingCharacters('|', "^~\\&");
        FilterIterator.Predicate<Structure> populatedOnly = new FilterIterator.Predicate<Structure>(){

            @Override
            public boolean evaluate(Structure obj) {
                String encoded = PipeParser.encode((Segment)obj, ec);
                return encoded.length() > 3;
            }
        };
        return new FilterIterator<Structure>(segmentIterator, populatedOnly);
    }

    private void addChildren(Group theParent) {
        String[] names = theParent.getNames();
        for (int i = names.length - 1; i >= 0; --i) {
            try {
                Structure[] reps = theParent.getAll(names[i]);
                for (int j = reps.length - 1; j >= 0; --j) {
                    this.myRemaining.add(reps[j]);
                }
                continue;
            }
            catch (HL7Exception e) {
                throw new Error("Internal error: an invalid child name was obtained from its parent.");
            }
        }
    }

    @Override
    public boolean hasNext() {
        return !this.myRemaining.isEmpty();
    }

    @Override
    public Structure next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more nodes in message");
        }
        Structure next = this.myRemaining.remove(this.myRemaining.size() - 1);
        if (next instanceof Group) {
            this.addChildren((Group)next);
        }
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can't remove a node from a message");
    }
}

