/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.impl;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.conf.ProfileException;
import ca.uhn.hl7v2.conf.check.DefaultValidator;
import ca.uhn.hl7v2.conf.parser.ProfileParser;
import ca.uhn.hl7v2.conf.spec.RuntimeProfile;
import ca.uhn.hl7v2.conf.store.ProfileStoreFactory;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.hl7v2.validation.MessageRule;
import ca.uhn.hl7v2.validation.ValidationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConformanceProfileRule
implements MessageRule {
    private static final Logger log = LoggerFactory.getLogger(ConformanceProfileRule.class);
    private String myProfileID;

    public ConformanceProfileRule() {
    }

    public ConformanceProfileRule(String theProfileID) {
        this.myProfileID = theProfileID;
    }

    public ValidationException[] test(Message msg) {
        ArrayList<ValidationException> problems = new ArrayList<ValidationException>(20);
        String[] ids = new String[]{this.myProfileID};
        try {
            if (this.myProfileID == null) {
                ids = this.getDeclaredProfileIDs(msg);
            }
            for (int i = 0; i < ids.length; ++i) {
                log.debug("Testing message against profile: {}", (Object)ids[i]);
                try {
                    ValidationException[] shortList = this.testAgainstProfile(msg, ids[i]);
                    log.debug("{} non-conformances", (Object)shortList.length);
                    problems.addAll(Arrays.asList(shortList));
                    continue;
                }
                catch (ProfileException e) {
                    problems.add(new ValidationException("Can't validate", e));
                }
            }
        }
        catch (HL7Exception e) {
            problems.add(new ValidationException("Can't validate", e));
        }
        return problems.toArray(new ValidationException[0]);
    }

    private String[] getDeclaredProfileIDs(Message theMessage) throws HL7Exception {
        Terser t = new Terser(theMessage);
        boolean noMore = false;
        int c = 0;
        ArrayList<String> declaredProfiles = new ArrayList<String>(8);
        while (!noMore) {
            String path = "MSH-21(" + c++ + ")";
            String idRep = t.get(path);
            if (idRep == null || idRep.equals("")) {
                noMore = true;
                continue;
            }
            declaredProfiles.add(idRep);
        }
        return declaredProfiles.toArray(new String[0]);
    }

    private ValidationException[] testAgainstProfile(Message message, String id) throws ProfileException, HL7Exception {
        HL7Exception[] exceptions = null;
        DefaultValidator val = new DefaultValidator();
        try {
            String profileString = ProfileStoreFactory.getProfileStore().getProfile(id);
            if (profileString == null) {
                throw new ProfileException("Unable to find the profile " + id);
            }
            ProfileParser profParser = new ProfileParser(true);
            RuntimeProfile profile = profParser.parse(profileString);
            exceptions = val.validate(message, profile.getMessage());
        }
        catch (IOException e) {
            throw new ProfileException("Error retreiving profile " + id, e);
        }
        ValidationException[] result = new ValidationException[exceptions.length];
        for (int i = 0; i < exceptions.length; ++i) {
            result[i] = new ValidationException(exceptions[i].getMessage(), exceptions[i]);
        }
        return result;
    }

    public String getDescription() {
        return "Checks conformance to declared or predefined message profiles";
    }

    public String getSectionReference() {
        return "HL7 2.5 section 2.12";
    }
}

