/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.impl;

import ca.uhn.hl7v2.validation.impl.RegexPrimitiveRule;
import ca.uhn.hl7v2.validation.impl.RuleBinding;
import ca.uhn.hl7v2.validation.impl.SizeRule;
import ca.uhn.hl7v2.validation.impl.TrimLeadingWhitespace;
import ca.uhn.hl7v2.validation.impl.ValidationContextImpl;
import ca.uhn.hl7v2.validation.impl.WithdrawnDatatypeRule;

public class DefaultValidationWithoutTN
extends ValidationContextImpl {
    public DefaultValidationWithoutTN() {
        TrimLeadingWhitespace trim = new TrimLeadingWhitespace();
        this.getPrimitiveRuleBindings().add(new RuleBinding<TrimLeadingWhitespace>("*", "FT", trim));
        this.getPrimitiveRuleBindings().add(new RuleBinding<TrimLeadingWhitespace>("*", "ST", trim));
        this.getPrimitiveRuleBindings().add(new RuleBinding<TrimLeadingWhitespace>("*", "TX", trim));
        SizeRule size200 = new SizeRule(200);
        SizeRule size32000 = new SizeRule(32000);
        this.getPrimitiveRuleBindings().add(new RuleBinding<SizeRule>("*", "FT", size32000));
        this.getPrimitiveRuleBindings().add(new RuleBinding<SizeRule>("*", "ID", size200));
        this.getPrimitiveRuleBindings().add(new RuleBinding<SizeRule>("*", "IS", size200));
        RegexPrimitiveRule nonNegativeInteger = new RegexPrimitiveRule("\\d*", "");
        this.getPrimitiveRuleBindings().add(new RuleBinding<RegexPrimitiveRule>("*", "SI", nonNegativeInteger));
        RegexPrimitiveRule number = new RegexPrimitiveRule("(\\+|\\-)?\\d*\\.?\\d*", "");
        this.getPrimitiveRuleBindings().add(new RuleBinding<RegexPrimitiveRule>("*", "NM", number));
        String datePattern = "(\\d{4}([01]\\d(\\d{2})?)?)?";
        RegexPrimitiveRule date = new RegexPrimitiveRule(datePattern, "Version 2.5 Section 2.A.21");
        this.getPrimitiveRuleBindings().add(new RuleBinding<RegexPrimitiveRule>("*", "DT", date));
        String timePattern = "([012]\\d([0-5]\\d([0-5]\\d(\\.\\d(\\d(\\d(\\d)?)?)?)?)?)?)?([\\+\\-]\\d{4})?";
        RegexPrimitiveRule time = new RegexPrimitiveRule(timePattern, "Version 2.5 Section 2.A.75");
        this.getPrimitiveRuleBindings().add(new RuleBinding<RegexPrimitiveRule>("*", "TM", time));
        String datetimePattern = "(\\d{4}([01]\\d(\\d{2}([012]\\d[0-5]\\d([0-5]\\d(\\.\\d(\\d(\\d(\\d)?)?)?)?)?)?)?)?)?([\\+\\-]\\d{4})?";
        RegexPrimitiveRule datetime = new RegexPrimitiveRule(datetimePattern, "Version 2.4 Section 2.9.47");
        this.getPrimitiveRuleBindings().add(new RuleBinding<RegexPrimitiveRule>("2.2", "TSComponentOne", datetime));
        this.getPrimitiveRuleBindings().add(new RuleBinding<RegexPrimitiveRule>("2.3", "TSComponentOne", datetime));
        this.getPrimitiveRuleBindings().add(new RuleBinding<RegexPrimitiveRule>("2.3.1", "TSComponentOne", datetime));
        this.getPrimitiveRuleBindings().add(new RuleBinding<RegexPrimitiveRule>("2.4", "TSComponentOne", datetime));
        String datetimePattern25 = "(\\d{4}([01]\\d(\\d{2}([012]\\d([0-5]\\d([0-5]\\d(\\.\\d(\\d(\\d(\\d)?)?)?)?)?)?)?)?)?)?([\\+\\-]\\d{4})?";
        RegexPrimitiveRule datetime25 = new RegexPrimitiveRule(datetimePattern25, "Version 2.5 Section 2.A.22");
        this.getPrimitiveRuleBindings().add(new RuleBinding<RegexPrimitiveRule>("2.5", "TSComponentOne", datetime25));
        this.getPrimitiveRuleBindings().add(new RuleBinding<RegexPrimitiveRule>("2.5", "DTM", datetime25));
        this.getPrimitiveRuleBindings().add(new RuleBinding<RegexPrimitiveRule>("2.5.1", "TSComponentOne", datetime25));
        this.getPrimitiveRuleBindings().add(new RuleBinding<RegexPrimitiveRule>("2.5.1", "DTM", datetime25));
        this.getPrimitiveRuleBindings().add(new RuleBinding<RegexPrimitiveRule>("2.6", "TSComponentOne", datetime25));
        this.getPrimitiveRuleBindings().add(new RuleBinding<RegexPrimitiveRule>("2.6", "DTM", datetime25));
        this.getPrimitiveRuleBindings().add(new RuleBinding<WithdrawnDatatypeRule>("*", "NULLDT", new WithdrawnDatatypeRule()));
    }
}

