/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.impl;

import ca.uhn.hl7v2.validation.PrimitiveTypeRule;
import java.util.regex.Pattern;

public class TrimLeadingWhitespace
implements PrimitiveTypeRule {
    private static final Pattern LEADING_WHITESPACE = Pattern.compile("^\\s+");

    public String correct(String value) {
        return value != null ? LEADING_WHITESPACE.matcher(value).replaceAll("") : null;
    }

    public boolean test(String value) {
        return true;
    }

    public String getDescription() {
        return "Leading whitespace removed";
    }

    public String getSectionReference() {
        return null;
    }
}

