/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.impl;

import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.impl.DefaultValidation;
import ca.uhn.hl7v2.validation.impl.NoValidation;

public class ValidationContextFactory {
    private static ValidationContext ourContext;
    public static final String CONTEXT_PROPERTY = "ca.uhn.hl7v2.validation.context_class";
    private static final ValidationContext NO_VALIDATION;
    private static final ValidationContext DEFAULT_VALIDATION;

    public static synchronized ValidationContext getContext() throws ValidationException {
        if (ourContext == null) {
            String contextClassName = System.getProperty(CONTEXT_PROPERTY);
            ourContext = contextClassName == null ? ValidationContextFactory.defaultValidation() : ValidationContextFactory.customValidation(contextClassName);
        }
        return ourContext;
    }

    public static ValidationContext noValidation() {
        return NO_VALIDATION;
    }

    public static ValidationContext defaultValidation() {
        return DEFAULT_VALIDATION;
    }

    public static ValidationContext customValidation(String contextClassName) throws ValidationException {
        try {
            Class<?> c = Class.forName(contextClassName);
            return (ValidationContext)c.newInstance();
        }
        catch (Exception e) {
            throw new ValidationException(e);
        }
    }

    static {
        NO_VALIDATION = new NoValidation();
        DEFAULT_VALIDATION = new DefaultValidation();
    }
}

