/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.impl;

import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.validation.EncodingRule;
import ca.uhn.hl7v2.validation.MessageRule;
import ca.uhn.hl7v2.validation.PrimitiveTypeRule;
import ca.uhn.hl7v2.validation.Rule;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.impl.RuleBinding;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationContextImpl
implements ValidationContext,
Serializable {
    private List<RuleBinding<PrimitiveTypeRule>> myPrimitiveRuleBindings = new ArrayList<RuleBinding<PrimitiveTypeRule>>();
    private List<RuleBinding<MessageRule>> myMessageRuleBindings = new ArrayList<RuleBinding<MessageRule>>();
    private List<RuleBinding<EncodingRule>> myEncodingRuleBindings = new ArrayList<RuleBinding<EncodingRule>>();

    @Override
    public PrimitiveTypeRule[] getPrimitiveRules(String theVersion, String theTypeName, Primitive theType) {
        return (PrimitiveTypeRule[])this.getRules(this.myPrimitiveRuleBindings, theVersion, theTypeName, PrimitiveTypeRule.class);
    }

    public List<RuleBinding<PrimitiveTypeRule>> getPrimitiveRuleBindings() {
        return this.myPrimitiveRuleBindings;
    }

    @Override
    public MessageRule[] getMessageRules(String theVersion, String theMessageType, String theTriggerEvent) {
        return (MessageRule[])this.getRules(this.myMessageRuleBindings, theVersion, theMessageType + "^" + theTriggerEvent, MessageRule.class);
    }

    public List<RuleBinding<MessageRule>> getMessageRuleBindings() {
        return this.myMessageRuleBindings;
    }

    @Override
    public EncodingRule[] getEncodingRules(String theVersion, String theEncoding) {
        return (EncodingRule[])this.getRules(this.myEncodingRuleBindings, theVersion, theEncoding, EncodingRule.class);
    }

    public List<RuleBinding<EncodingRule>> getEncodingRuleBindings() {
        return this.myEncodingRuleBindings;
    }

    private <T extends Rule> T[] getRules(List<RuleBinding<T>> bindings, String version, String scope, Class<T> ruleClass) {
        ArrayList<T> active = new ArrayList<T>(bindings.size());
        for (RuleBinding<T> binding : bindings) {
            if (!this.applies(binding, version, scope)) continue;
            active.add(binding.getRule());
        }
        return (Rule[])this.toArray(active, ruleClass);
    }

    private boolean applies(RuleBinding<?> binding, String version, String scope) {
        return binding.getActive() && binding.appliesToVersion(version) && binding.appliesToScope(scope);
    }

    private <T> T[] toArray(List<T> list, Class<T> c) {
        return list.toArray((Object[])Array.newInstance(c, list.size()));
    }
}

