/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.llp;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.llp.CharSetUtil;
import ca.uhn.hl7v2.llp.HL7Writer;
import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.preparser.PreParser;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedMinLLPWriter
implements HL7Writer {
    private static final Logger ourLog = LoggerFactory.getLogger(ExtendedMinLLPWriter.class);
    private OutputStream myOutputStream;

    public ExtendedMinLLPWriter(OutputStream theOut) {
        this.myOutputStream = theOut;
    }

    public synchronized void writeMessage(String theMessage) throws LLPException, IOException {
        Charset javaCs;
        try {
            String[] fields = PreParser.getFields(theMessage, "MSH-18(0)");
            String charset = fields[0];
            try {
                javaCs = CharSetUtil.convertHL7CharacterEncodingToCharSetvalue(charset);
            }
            catch (EncodingNotSupportedException e) {
                ourLog.warn("Nonvalid charset \"" + charset + "\"- defaulting to US-ASCII", (Throwable)e);
                javaCs = Charset.forName("US-ASCII");
            }
        }
        catch (HL7Exception e1) {
            ourLog.warn("Could not detect charset - defaulting to US-ASCII", (Throwable)e1);
            javaCs = Charset.forName("US-ASCII");
        }
        OutputStreamWriter writer = new OutputStreamWriter(this.myOutputStream, javaCs);
        this.myOutputStream.write(11);
        this.myOutputStream.flush();
        writer.append(theMessage);
        writer.flush();
        this.myOutputStream.write(28);
        this.myOutputStream.write(13);
        this.myOutputStream.flush();
    }

    public synchronized void setOutputStream(OutputStream theOut) throws IOException {
        this.myOutputStream = theOut;
    }

    public synchronized void close() throws IOException {
        this.myOutputStream.close();
    }
}

