/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.protocol.impl;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.Application;
import ca.uhn.hl7v2.protocol.ApplicationRouter;
import ca.uhn.hl7v2.protocol.ReceivingApplication;
import ca.uhn.hl7v2.protocol.impl.AppRoutingDataImpl;
import ca.uhn.hl7v2.protocol.impl.AppWrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class ApplicationLoader {
    public static void loadApplications(ApplicationRouter theRouter, URL theSource) throws IOException, HL7Exception, ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (theSource == null) {
            throw new HL7Exception("Can't load application bindings: the given URL is null");
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(theSource.openStream()));
        String line = null;
        while ((line = in.readLine()) != null) {
            StringTokenizer tok = new StringTokenizer(line, "\t", false);
            String type = null;
            String event = null;
            String procId = null;
            String verId = null;
            String className = null;
            if (!tok.hasMoreTokens()) continue;
            try {
                type = tok.nextToken();
                event = tok.nextToken();
                procId = tok.nextToken();
                verId = tok.nextToken();
                className = tok.nextToken();
            }
            catch (NoSuchElementException ne) {
                throw new HL7Exception("Can't register applications from " + theSource.toExternalForm() + ". The line '" + line + "' is not of the form: message_type [tab] trigger_event " + "[tab] processing ID [tab] version ID [tab] application_class. " + "*** NOTE TWO NEW FIELDS AS OF HAPI 0.5 ****. ");
            }
            Class<?> appClass = Class.forName(className);
            Object appObject = appClass.newInstance();
            ReceivingApplication app = null;
            if (appObject instanceof ReceivingApplication) {
                app = (ReceivingApplication)appObject;
            } else if (appObject instanceof Application) {
                app = new AppWrapper((Application)appObject);
            } else {
                throw new HL7Exception("The specified class, " + appClass.getName() + ", doesn't implement Application or ReceivingApplication.");
            }
            AppRoutingDataImpl rd = new AppRoutingDataImpl(type, event, procId, verId);
            theRouter.bindApplication(rd, app);
        }
    }
}

