/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyLoader {
    private static final Logger log = LoggerFactory.getLogger(PropertyLoader.class);
    private static Set<String> files = new HashSet<String>();

    private PropertyLoader() {
    }

    public static void loadOnce(String propertyFileName) throws IOException {
        if (!files.contains(propertyFileName)) {
            PropertyLoader.loadProperties(propertyFileName);
            files.add(propertyFileName);
        }
    }

    public static void loadProperties(String propertyFileName) throws IOException {
        String line;
        BufferedReader in = null;
        in = new BufferedReader(new FileReader(propertyFileName));
        String delim = "\t";
        while ((line = in.readLine()) != null) {
            if (line.startsWith("%")) continue;
            String key = null;
            String value = null;
            StringTokenizer tok = new StringTokenizer(line, delim, false);
            if (tok.hasMoreTokens()) {
                key = tok.nextToken();
            }
            if (tok.hasMoreTokens()) {
                value = tok.nextToken();
            }
            if (key == null || value == null) continue;
            System.setProperty(key, value);
            log.debug("Setting system property {} to {}", (Object)key, (Object)value);
        }
        in.close();
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: PropertyLoader file");
            System.exit(1);
        }
        try {
            System.setProperty("ca.uhn.hl7v2.util.status.level", "VERBOSE");
            System.out.println("Loading properties in file " + args[0]);
            PropertyLoader.loadOnce(args[0]);
            System.out.println("Loading properties in file " + args[0] + " again");
            PropertyLoader.loadOnce(args[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Properties p = System.getProperties();
        Enumeration<?> en = p.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            System.out.println("Property: " + key + " Value: " + System.getProperty(key));
        }
    }
}

