/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v21.segment;

// import ca.uhn.hl7v2.model.v21.group.*;
import ca.uhn.hl7v2.model.v21.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 BLG message segment (BILLING). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>BLG-1: WHEN TO CHARGE (CM) <b>optional </b>
     * <li>BLG-2: CHARGE TYPE (ID) <b>optional </b>
     * <li>BLG-3: ACCOUNT ID (CM) <b>optional </b>
 * </ul>
 */
public class BLG extends AbstractSegment {

    /** 
     * Creates a new BLG segment
     */
    public BLG(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(CM.class, false, 1, 15, new Object[]{ getMessage(), new Integer(100) }, "WHEN TO CHARGE");
                                  this.add(ID.class, false, 1, 50, new Object[]{ getMessage() }, "CHARGE TYPE");
                                  this.add(CM.class, false, 1, 100, new Object[]{ getMessage(), new Integer(0) }, "ACCOUNT ID");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating BLG - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * BLG-1: "WHEN TO CHARGE" - creates it if necessary
     */
    public CM getWHENTOCHARGE() { 
        CM ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BLG-1: "WHEN TO CHARGE" - creates it if necessary
     */
    public CM getBlg1_WHENTOCHARGE() { 
        CM ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BLG-2: "CHARGE TYPE" - creates it if necessary
     */
    public ID getCHARGETYPE() { 
        ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BLG-2: "CHARGE TYPE" - creates it if necessary
     */
    public ID getBlg2_CHARGETYPE() { 
        ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BLG-3: "ACCOUNT ID" - creates it if necessary
     */
    public CM getACCOUNTID() { 
        CM ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BLG-3: "ACCOUNT ID" - creates it if necessary
     */
    public CM getBlg3_ACCOUNTID() { 
        CM ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new CM(getMessage());
          case 1: return new ID(getMessage(), new Integer( 122 ));
          case 2: return new CM(getMessage());
          default: return null;
       }
   }


}

