/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v21.segment;

// import ca.uhn.hl7v2.model.v21.group.*;
import ca.uhn.hl7v2.model.v21.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 ERR message segment (ERROR). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>ERR-1: ERROR CODE AND LOCATION (ID) <b> repeating</b>
 * </ul>
 */
public class ERR extends AbstractSegment {

    /** 
     * Creates a new ERR segment
     */
    public ERR(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(ID.class, true, 0, 80, new Object[]{ getMessage() }, "ERROR CODE AND LOCATION");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ERR - this is probably a bug in the source code generator.", e);
       }
    }


    /**
     * Returns all repetitions of ERROR CODE AND LOCATION (ERR-1).
     */
    public ID[] getERRORCODEANDLOCATION() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(1);  
            ret = new ID[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ID)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * ERR-1: "ERROR CODE AND LOCATION" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getERRORCODEANDLOCATION(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * ERR-1: "ERROR CODE AND LOCATION" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getErr1_ERRORCODEANDLOCATION(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * ERR-1: "ERROR CODE AND LOCATION" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertERRORCODEANDLOCATION(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(1, rep);
    }



    /**
     * Inserts a repetition of
     * ERR-1: "ERROR CODE AND LOCATION" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertErr1_ERRORCODEANDLOCATION(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(1, rep);
    }


    /**
     * Removes a repetition of
     * ERR-1: "ERROR CODE AND LOCATION" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removeERRORCODEANDLOCATION(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(1, rep);
    }


    /**
     * Removes a repetition of
     * ERR-1: "ERROR CODE AND LOCATION" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removeErr1_ERRORCODEANDLOCATION(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(1, rep);
    }






    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new ID(getMessage(), new Integer( 60 ));
          default: return null;
       }
   }


}

