/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v21.segment;

// import ca.uhn.hl7v2.model.v21.group.*;
import ca.uhn.hl7v2.model.v21.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 GT1 message segment (GUARANTOR). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>GT1-1: SET ID - GUARANTOR (SI) <b> </b>
     * <li>GT1-2: GUARANTOR NUMBER (ID) <b>optional </b>
     * <li>GT1-3: GUARANTOR NAME (PN) <b> </b>
     * <li>GT1-4: GUARANTOR SPOUSE NAME (PN) <b>optional </b>
     * <li>GT1-5: GUARANTOR ADDRESS (AD) <b>optional </b>
     * <li>GT1-6: GUARANTOR PH. NUM.- HOME (TN) <b>optional </b>
     * <li>GT1-7: GUARANTOR PH. NUM-BUSINESS (TN) <b>optional </b>
     * <li>GT1-8: GUARANTOR DATE OF BIRTH (DT) <b>optional </b>
     * <li>GT1-9: GUARANTOR SEX (ID) <b>optional </b>
     * <li>GT1-10: GUARANTOR TYPE (ID) <b>optional </b>
     * <li>GT1-11: GUARANTOR RELATIONSHIP (ID) <b>optional </b>
     * <li>GT1-12: GUARANTOR SSN (ST) <b>optional </b>
     * <li>GT1-13: GUARANTOR DATE - BEGIN (DT) <b>optional </b>
     * <li>GT1-14: GUARANTOR DATE - END (DT) <b>optional </b>
     * <li>GT1-15: GUARANTOR PRIORITY (NM) <b>optional </b>
     * <li>GT1-16: GUARANTOR EMPLOYER NAME (ST) <b>optional </b>
     * <li>GT1-17: GUARANTOR EMPLOYER ADDRESS (AD) <b>optional </b>
     * <li>GT1-18: GUARANTOR EMPLOY PHONE # (TN) <b>optional </b>
     * <li>GT1-19: GUARANTOR EMPLOYEE ID NUM (ST) <b>optional </b>
     * <li>GT1-20: GUARANTOR EMPLOYMENT STATUS (ID) <b>optional </b>
 * </ul>
 */
public class GT1 extends AbstractSegment {

    /** 
     * Creates a new GT1 segment
     */
    public GT1(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, true, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "SET ID - GUARANTOR");
                                  this.add(ID.class, false, 1, 20, new Object[]{ getMessage() }, "GUARANTOR NUMBER");
                                  this.add(PN.class, true, 1, 48, new Object[]{ getMessage(), new Integer(0) }, "GUARANTOR NAME");
                                  this.add(PN.class, false, 1, 48, new Object[]{ getMessage(), new Integer(0) }, "GUARANTOR SPOUSE NAME");
                                  this.add(AD.class, false, 1, 106, new Object[]{ getMessage(), new Integer(0) }, "GUARANTOR ADDRESS");
                                  this.add(TN.class, false, 1, 40, new Object[]{ getMessage(), new Integer(0) }, "GUARANTOR PH. NUM.- HOME");
                                  this.add(TN.class, false, 1, 40, new Object[]{ getMessage(), new Integer(0) }, "GUARANTOR PH. NUM-BUSINESS");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "GUARANTOR DATE OF BIRTH");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "GUARANTOR SEX");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "GUARANTOR TYPE");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "GUARANTOR RELATIONSHIP");
                                  this.add(ST.class, false, 1, 11, new Object[]{ getMessage(), new Integer(0) }, "GUARANTOR SSN");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "GUARANTOR DATE - BEGIN");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "GUARANTOR DATE - END");
                                  this.add(NM.class, false, 1, 2, new Object[]{ getMessage(), new Integer(0) }, "GUARANTOR PRIORITY");
                                  this.add(ST.class, false, 1, 45, new Object[]{ getMessage(), new Integer(0) }, "GUARANTOR EMPLOYER NAME");
                                  this.add(AD.class, false, 1, 106, new Object[]{ getMessage(), new Integer(0) }, "GUARANTOR EMPLOYER ADDRESS");
                                  this.add(TN.class, false, 1, 40, new Object[]{ getMessage(), new Integer(0) }, "GUARANTOR EMPLOY PHONE #");
                                  this.add(ST.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "GUARANTOR EMPLOYEE ID NUM");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "GUARANTOR EMPLOYMENT STATUS");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating GT1 - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * GT1-1: "SET ID - GUARANTOR" - creates it if necessary
     */
    public SI getSETIDGUARANTOR() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-1: "SET ID - GUARANTOR" - creates it if necessary
     */
    public SI getGt11_SETIDGUARANTOR() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-2: "GUARANTOR NUMBER" - creates it if necessary
     */
    public ID getGUARANTORNUMBER() { 
        ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-2: "GUARANTOR NUMBER" - creates it if necessary
     */
    public ID getGt12_GUARANTORNUMBER() { 
        ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-3: "GUARANTOR NAME" - creates it if necessary
     */
    public PN getGUARANTORNAME() { 
        PN ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (PN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-3: "GUARANTOR NAME" - creates it if necessary
     */
    public PN getGt13_GUARANTORNAME() { 
        PN ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (PN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-4: "GUARANTOR SPOUSE NAME" - creates it if necessary
     */
    public PN getGUARANTORSPOUSENAME() { 
        PN ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (PN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-4: "GUARANTOR SPOUSE NAME" - creates it if necessary
     */
    public PN getGt14_GUARANTORSPOUSENAME() { 
        PN ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (PN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-5: "GUARANTOR ADDRESS" - creates it if necessary
     */
    public AD getGUARANTORADDRESS() { 
        AD ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (AD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-5: "GUARANTOR ADDRESS" - creates it if necessary
     */
    public AD getGt15_GUARANTORADDRESS() { 
        AD ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (AD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-6: "GUARANTOR PH. NUM.- HOME" - creates it if necessary
     */
    public TN getGUARANTORPHNUMHOME() { 
        TN ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (TN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-6: "GUARANTOR PH. NUM.- HOME" - creates it if necessary
     */
    public TN getGt16_GUARANTORPHNUMHOME() { 
        TN ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (TN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-7: "GUARANTOR PH. NUM-BUSINESS" - creates it if necessary
     */
    public TN getGUARANTORPHNUMBUSINESS() { 
        TN ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (TN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-7: "GUARANTOR PH. NUM-BUSINESS" - creates it if necessary
     */
    public TN getGt17_GUARANTORPHNUMBUSINESS() { 
        TN ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (TN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-8: "GUARANTOR DATE OF BIRTH" - creates it if necessary
     */
    public DT getGUARANTORDATEOFBIRTH() { 
        DT ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-8: "GUARANTOR DATE OF BIRTH" - creates it if necessary
     */
    public DT getGt18_GUARANTORDATEOFBIRTH() { 
        DT ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-9: "GUARANTOR SEX" - creates it if necessary
     */
    public ID getGUARANTORSEX() { 
        ID ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-9: "GUARANTOR SEX" - creates it if necessary
     */
    public ID getGt19_GUARANTORSEX() { 
        ID ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-10: "GUARANTOR TYPE" - creates it if necessary
     */
    public ID getGUARANTORTYPE() { 
        ID ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-10: "GUARANTOR TYPE" - creates it if necessary
     */
    public ID getGt110_GUARANTORTYPE() { 
        ID ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-11: "GUARANTOR RELATIONSHIP" - creates it if necessary
     */
    public ID getGUARANTORRELATIONSHIP() { 
        ID ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-11: "GUARANTOR RELATIONSHIP" - creates it if necessary
     */
    public ID getGt111_GUARANTORRELATIONSHIP() { 
        ID ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-12: "GUARANTOR SSN" - creates it if necessary
     */
    public ST getGUARANTORSSN() { 
        ST ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-12: "GUARANTOR SSN" - creates it if necessary
     */
    public ST getGt112_GUARANTORSSN() { 
        ST ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-13: "GUARANTOR DATE - BEGIN" - creates it if necessary
     */
    public DT getGUARANTORDATEBEGIN() { 
        DT ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-13: "GUARANTOR DATE - BEGIN" - creates it if necessary
     */
    public DT getGt113_GUARANTORDATEBEGIN() { 
        DT ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-14: "GUARANTOR DATE - END" - creates it if necessary
     */
    public DT getGUARANTORDATEEND() { 
        DT ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-14: "GUARANTOR DATE - END" - creates it if necessary
     */
    public DT getGt114_GUARANTORDATEEND() { 
        DT ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-15: "GUARANTOR PRIORITY" - creates it if necessary
     */
    public NM getGUARANTORPRIORITY() { 
        NM ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-15: "GUARANTOR PRIORITY" - creates it if necessary
     */
    public NM getGt115_GUARANTORPRIORITY() { 
        NM ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-16: "GUARANTOR EMPLOYER NAME" - creates it if necessary
     */
    public ST getGUARANTOREMPLOYERNAME() { 
        ST ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-16: "GUARANTOR EMPLOYER NAME" - creates it if necessary
     */
    public ST getGt116_GUARANTOREMPLOYERNAME() { 
        ST ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-17: "GUARANTOR EMPLOYER ADDRESS" - creates it if necessary
     */
    public AD getGUARANTOREMPLOYERADDRESS() { 
        AD ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (AD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-17: "GUARANTOR EMPLOYER ADDRESS" - creates it if necessary
     */
    public AD getGt117_GUARANTOREMPLOYERADDRESS() { 
        AD ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (AD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-18: "GUARANTOR EMPLOY PHONE #" - creates it if necessary
     */
    public TN getGUARANTOREMPLOYPHONE() { 
        TN ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (TN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-18: "GUARANTOR EMPLOY PHONE #" - creates it if necessary
     */
    public TN getGt118_GUARANTOREMPLOYPHONE() { 
        TN ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (TN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-19: "GUARANTOR EMPLOYEE ID NUM" - creates it if necessary
     */
    public ST getGUARANTOREMPLOYEEIDNUM() { 
        ST ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-19: "GUARANTOR EMPLOYEE ID NUM" - creates it if necessary
     */
    public ST getGt119_GUARANTOREMPLOYEEIDNUM() { 
        ST ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-20: "GUARANTOR EMPLOYMENT STATUS" - creates it if necessary
     */
    public ID getGUARANTOREMPLOYMENTSTATUS() { 
        ID ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-20: "GUARANTOR EMPLOYMENT STATUS" - creates it if necessary
     */
    public ID getGt120_GUARANTOREMPLOYMENTSTATUS() { 
        ID ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new ID(getMessage(), new Integer( 0 ));
          case 2: return new PN(getMessage());
          case 3: return new PN(getMessage());
          case 4: return new AD(getMessage());
          case 5: return new TN(getMessage());
          case 6: return new TN(getMessage());
          case 7: return new DT(getMessage());
          case 8: return new ID(getMessage(), new Integer( 1 ));
          case 9: return new ID(getMessage(), new Integer( 68 ));
          case 10: return new ID(getMessage(), new Integer( 63 ));
          case 11: return new ST(getMessage());
          case 12: return new DT(getMessage());
          case 13: return new DT(getMessage());
          case 14: return new NM(getMessage());
          case 15: return new ST(getMessage());
          case 16: return new AD(getMessage());
          case 17: return new TN(getMessage());
          case 18: return new ST(getMessage());
          case 19: return new ID(getMessage(), new Integer( 66 ));
          default: return null;
       }
   }


}

