/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v21.segment;

// import ca.uhn.hl7v2.model.v21.group.*;
import ca.uhn.hl7v2.model.v21.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 MRG message segment (MERGE PATIENT INFORMATION). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>MRG-1: PRIOR PATIENT ID - INTERNAL (CK) <b> </b>
     * <li>MRG-2: PRIOR ALTERNATE PATIENT ID (CK) <b>optional </b>
     * <li>MRG-3: PRIOR PATIENT ACCOUNT NUMBER (CK) <b>optional </b>
 * </ul>
 */
public class MRG extends AbstractSegment {

    /** 
     * Creates a new MRG segment
     */
    public MRG(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(CK.class, true, 1, 16, new Object[]{ getMessage(), new Integer(61) }, "PRIOR PATIENT ID - INTERNAL");
                                  this.add(CK.class, false, 1, 16, new Object[]{ getMessage(), new Integer(61) }, "PRIOR ALTERNATE PATIENT ID");
                                  this.add(CK.class, false, 1, 20, new Object[]{ getMessage(), new Integer(61) }, "PRIOR PATIENT ACCOUNT NUMBER");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating MRG - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * MRG-1: "PRIOR PATIENT ID - INTERNAL" - creates it if necessary
     */
    public CK getPRIORPATIENTIDINTERNAL() { 
        CK ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CK)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MRG-1: "PRIOR PATIENT ID - INTERNAL" - creates it if necessary
     */
    public CK getMrg1_PRIORPATIENTIDINTERNAL() { 
        CK ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CK)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MRG-2: "PRIOR ALTERNATE PATIENT ID" - creates it if necessary
     */
    public CK getPRIORALTERNATEPATIENTID() { 
        CK ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CK)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MRG-2: "PRIOR ALTERNATE PATIENT ID" - creates it if necessary
     */
    public CK getMrg2_PRIORALTERNATEPATIENTID() { 
        CK ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CK)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MRG-3: "PRIOR PATIENT ACCOUNT NUMBER" - creates it if necessary
     */
    public CK getPRIORPATIENTACCOUNTNUMBER() { 
        CK ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CK)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MRG-3: "PRIOR PATIENT ACCOUNT NUMBER" - creates it if necessary
     */
    public CK getMrg3_PRIORPATIENTACCOUNTNUMBER() { 
        CK ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CK)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new CK(getMessage());
          case 1: return new CK(getMessage());
          case 2: return new CK(getMessage());
          default: return null;
       }
   }


}

