/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v21.segment;

// import ca.uhn.hl7v2.model.v21.group.*;
import ca.uhn.hl7v2.model.v21.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 OBR message segment (OBSERVATION REQUEST). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>OBR-1: SET ID - OBSERVATION REQUEST (SI) <b>optional </b>
     * <li>OBR-2: PLACER ORDER # (CM) <b>optional </b>
     * <li>OBR-3: FILLER ORDER # (CM) <b>optional </b>
     * <li>OBR-4: UNIVERSAL SERVICE IDENT. (CE) <b> </b>
     * <li>OBR-5: PRIORITY (ST) <b>optional </b>
     * <li>OBR-6: REQUESTED DATE-TIME (TS) <b>optional </b>
     * <li>OBR-7: OBSERVATION DATE/TIME (TS) <b> </b>
     * <li>OBR-8: OBSERVATION END DATE/TIME (TS) <b> </b>
     * <li>OBR-9: COLLECTION VOLUME (CQ) <b> </b>
     * <li>OBR-10: COLLECTOR IDENTIFIER (CN) <b>optional repeating</b>
     * <li>OBR-11: SPECIMEN ACTION CODE (ST) <b>optional </b>
     * <li>OBR-12: DANGER CODE (CM) <b>optional </b>
     * <li>OBR-13: RELEVANT CLINICAL INFO. (ST) <b>optional </b>
     * <li>OBR-14: SPECIMEN RECEIVED DATE/TIME (TS) <b> </b>
     * <li>OBR-15: SPECIMEN SOURCE (CM) <b>optional </b>
     * <li>OBR-16: ORDERING PROVIDER (CN) <b>optional repeating</b>
     * <li>OBR-17: ORDER CALL-BACK PHONE NUM (TN) <b>optional repeating</b>
     * <li>OBR-18: PLACERS FIELD #1 (ST) <b>optional </b>
     * <li>OBR-19: PLACERS FIELD #2 (ST) <b>optional </b>
     * <li>OBR-20: FILLERS FIELD #1 (ST) <b>optional </b>
     * <li>OBR-21: FILLERS FIELD #2 (ST) <b>optional </b>
     * <li>OBR-22: RESULTS RPT/STATUS CHNG - DATE/T (TS) <b> </b>
     * <li>OBR-23: CHARGE TO PRACTICE (CM) <b>optional </b>
     * <li>OBR-24: DIAGNOSTIC SERV SECT ID (ID) <b>optional </b>
     * <li>OBR-25: RESULT STATUS (ID) <b>optional </b>
     * <li>OBR-26: LINKED RESULTS (CE) <b>optional </b>
     * <li>OBR-27: QUANTITY/TIMING (CM) <b>optional repeating</b>
     * <li>OBR-28: RESULT COPIES TO (CN) <b>optional repeating</b>
     * <li>OBR-29: PARENT ACCESSION # (CM) <b>optional </b>
     * <li>OBR-30: TRANSPORTATION MODE (ID) <b>optional </b>
     * <li>OBR-31: REASON FOR STUDY (CE) <b>optional repeating</b>
     * <li>OBR-32: PRINCIPAL RESULT INTERPRETER (CN) <b>optional </b>
     * <li>OBR-33: ASSISTANT RESULT INTERPRETER (CN) <b>optional </b>
     * <li>OBR-34: TECHNICIAN (CN) <b>optional </b>
     * <li>OBR-35: TRANSCRIPTIONIST (CN) <b>optional </b>
     * <li>OBR-36: SCHEDULED - DATE/TIME (TS) <b>optional </b>
 * </ul>
 */
public class OBR extends AbstractSegment {

    /** 
     * Creates a new OBR segment
     */
    public OBR(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "SET ID - OBSERVATION REQUEST");
                                  this.add(CM.class, false, 1, 75, new Object[]{ getMessage(), new Integer(0) }, "PLACER ORDER #");
                                  this.add(CM.class, false, 1, 75, new Object[]{ getMessage(), new Integer(0) }, "FILLER ORDER #");
                                  this.add(CE.class, true, 1, 200, new Object[]{ getMessage(), new Integer(0) }, "UNIVERSAL SERVICE IDENT.");
                                  this.add(ST.class, false, 1, 2, new Object[]{ getMessage(), new Integer(0) }, "PRIORITY");
                                  this.add(TS.class, false, 1, 19, new Object[]{ getMessage(), new Integer(0) }, "REQUESTED DATE-TIME");
                                  this.add(TS.class, true, 1, 19, new Object[]{ getMessage(), new Integer(0) }, "OBSERVATION DATE/TIME");
                                  this.add(TS.class, true, 1, 19, new Object[]{ getMessage(), new Integer(0) }, "OBSERVATION END DATE/TIME");
                                  this.add(CQ.class, true, 1, 20, new Object[]{ getMessage(), new Integer(36) }, "COLLECTION VOLUME");
                                  this.add(CN.class, false, 0, 60, new Object[]{ getMessage(), new Integer(0) }, "COLLECTOR IDENTIFIER");
                                  this.add(ST.class, false, 1, 1, new Object[]{ getMessage(), new Integer(65) }, "SPECIMEN ACTION CODE");
                                  this.add(CM.class, false, 1, 60, new Object[]{ getMessage(), new Integer(47) }, "DANGER CODE");
                                  this.add(ST.class, false, 1, 300, new Object[]{ getMessage(), new Integer(0) }, "RELEVANT CLINICAL INFO.");
                                  this.add(TS.class, true, 1, 19, new Object[]{ getMessage(), new Integer(0) }, "SPECIMEN RECEIVED DATE/TIME");
                                  this.add(CM.class, false, 1, 300, new Object[]{ getMessage(), new Integer(70) }, "SPECIMEN SOURCE");
                                  this.add(CN.class, false, 0, 60, new Object[]{ getMessage(), new Integer(10) }, "ORDERING PROVIDER");
                                  this.add(TN.class, false, 2, 40, new Object[]{ getMessage(), new Integer(0) }, "ORDER CALL-BACK PHONE NUM");
                                  this.add(ST.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "PLACERS FIELD #1");
                                  this.add(ST.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "PLACERS FIELD #2");
                                  this.add(ST.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "FILLERS FIELD #1");
                                  this.add(ST.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "FILLERS FIELD #2");
                                  this.add(TS.class, true, 1, 19, new Object[]{ getMessage(), new Integer(0) }, "RESULTS RPT/STATUS CHNG - DATE/T");
                                  this.add(CM.class, false, 1, 40, new Object[]{ getMessage(), new Integer(0) }, "CHARGE TO PRACTICE");
                                  this.add(ID.class, false, 1, 10, new Object[]{ getMessage() }, "DIAGNOSTIC SERV SECT ID");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "RESULT STATUS");
                                  this.add(CE.class, false, 1, 200, new Object[]{ getMessage(), new Integer(0) }, "LINKED RESULTS");
                                  this.add(CM.class, false, 0, 200, new Object[]{ getMessage(), new Integer(0) }, "QUANTITY/TIMING");
                                  this.add(CN.class, false, 5, 80, new Object[]{ getMessage(), new Integer(0) }, "RESULT COPIES TO");
                                  this.add(CM.class, false, 1, 150, new Object[]{ getMessage(), new Integer(0) }, "PARENT ACCESSION #");
                                  this.add(ID.class, false, 1, 20, new Object[]{ getMessage() }, "TRANSPORTATION MODE");
                                  this.add(CE.class, false, 0, 300, new Object[]{ getMessage(), new Integer(0) }, "REASON FOR STUDY");
                                  this.add(CN.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "PRINCIPAL RESULT INTERPRETER");
                                  this.add(CN.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "ASSISTANT RESULT INTERPRETER");
                                  this.add(CN.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "TECHNICIAN");
                                  this.add(CN.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "TRANSCRIPTIONIST");
                                  this.add(TS.class, false, 1, 19, new Object[]{ getMessage(), new Integer(0) }, "SCHEDULED - DATE/TIME");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating OBR - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * OBR-1: "SET ID - OBSERVATION REQUEST" - creates it if necessary
     */
    public SI getSETIDOBSERVATIONREQUEST() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-1: "SET ID - OBSERVATION REQUEST" - creates it if necessary
     */
    public SI getObr1_SETIDOBSERVATIONREQUEST() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OBR-2: "PLACER ORDER #" - creates it if necessary
     */
    public CM getPLACERORDER() { 
        CM ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-2: "PLACER ORDER #" - creates it if necessary
     */
    public CM getObr2_PLACERORDER() { 
        CM ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OBR-3: "FILLER ORDER #" - creates it if necessary
     */
    public CM getFILLERORDER() { 
        CM ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-3: "FILLER ORDER #" - creates it if necessary
     */
    public CM getObr3_FILLERORDER() { 
        CM ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OBR-4: "UNIVERSAL SERVICE IDENT." - creates it if necessary
     */
    public CE getUNIVERSALSERVICEIDENT() { 
        CE ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-4: "UNIVERSAL SERVICE IDENT." - creates it if necessary
     */
    public CE getObr4_UNIVERSALSERVICEIDENT() { 
        CE ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OBR-5: "PRIORITY" - creates it if necessary
     */
    public ST getPRIORITY() { 
        ST ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-5: "PRIORITY" - creates it if necessary
     */
    public ST getObr5_PRIORITY() { 
        ST ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OBR-6: "REQUESTED DATE-TIME" - creates it if necessary
     */
    public TS getREQUESTEDDATETIME() { 
        TS ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-6: "REQUESTED DATE-TIME" - creates it if necessary
     */
    public TS getObr6_REQUESTEDDATETIME() { 
        TS ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OBR-7: "OBSERVATION DATE/TIME" - creates it if necessary
     */
    public TS getOBSERVATIONDATETIME() { 
        TS ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-7: "OBSERVATION DATE/TIME" - creates it if necessary
     */
    public TS getObr7_OBSERVATIONDATETIME() { 
        TS ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OBR-8: "OBSERVATION END DATE/TIME" - creates it if necessary
     */
    public TS getOBSERVATIONENDDATETIME() { 
        TS ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-8: "OBSERVATION END DATE/TIME" - creates it if necessary
     */
    public TS getObr8_OBSERVATIONENDDATETIME() { 
        TS ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OBR-9: "COLLECTION VOLUME" - creates it if necessary
     */
    public CQ getCOLLECTIONVOLUME() { 
        CQ ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-9: "COLLECTION VOLUME" - creates it if necessary
     */
    public CQ getObr9_COLLECTIONVOLUME() { 
        CQ ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of COLLECTOR IDENTIFIER (OBR-10).
     */
    public CN[] getCOLLECTORIDENTIFIER() {
        CN[] ret = null;
        try {
            Type[] t = this.getField(10);  
            ret = new CN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OBR-10: "COLLECTOR IDENTIFIER" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CN getCOLLECTORIDENTIFIER(int rep) { 
        CN ret = null;
        try {
            Type t = this.getField(10, rep);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OBR-10: "COLLECTOR IDENTIFIER" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CN getObr10_COLLECTORIDENTIFIER(int rep) { 
        CN ret = null;
        try {
            Type t = this.getField(10, rep);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * OBR-10: "COLLECTOR IDENTIFIER" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CN insertCOLLECTORIDENTIFIER(int rep) throws HL7Exception { 
        return (CN) super.insertRepetition(10, rep);
    }



    /**
     * Inserts a repetition of
     * OBR-10: "COLLECTOR IDENTIFIER" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CN insertObr10_COLLECTORIDENTIFIER(int rep) throws HL7Exception { 
        return (CN) super.insertRepetition(10, rep);
    }


    /**
     * Removes a repetition of
     * OBR-10: "COLLECTOR IDENTIFIER" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CN removeCOLLECTORIDENTIFIER(int rep) throws HL7Exception { 
        return (CN) super.removeRepetition(10, rep);
    }


    /**
     * Removes a repetition of
     * OBR-10: "COLLECTOR IDENTIFIER" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CN removeObr10_COLLECTORIDENTIFIER(int rep) throws HL7Exception { 
        return (CN) super.removeRepetition(10, rep);
    }




    /**
     * Returns
     * OBR-11: "SPECIMEN ACTION CODE" - creates it if necessary
     */
    public ST getSPECIMENACTIONCODE() { 
        ST ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-11: "SPECIMEN ACTION CODE" - creates it if necessary
     */
    public ST getObr11_SPECIMENACTIONCODE() { 
        ST ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OBR-12: "DANGER CODE" - creates it if necessary
     */
    public CM getDANGERCODE() { 
        CM ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-12: "DANGER CODE" - creates it if necessary
     */
    public CM getObr12_DANGERCODE() { 
        CM ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OBR-13: "RELEVANT CLINICAL INFO." - creates it if necessary
     */
    public ST getRELEVANTCLINICALINFO() { 
        ST ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-13: "RELEVANT CLINICAL INFO." - creates it if necessary
     */
    public ST getObr13_RELEVANTCLINICALINFO() { 
        ST ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OBR-14: "SPECIMEN RECEIVED DATE/TIME" - creates it if necessary
     */
    public TS getSPECIMENRECEIVEDDATETIME() { 
        TS ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-14: "SPECIMEN RECEIVED DATE/TIME" - creates it if necessary
     */
    public TS getObr14_SPECIMENRECEIVEDDATETIME() { 
        TS ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OBR-15: "SPECIMEN SOURCE" - creates it if necessary
     */
    public CM getSPECIMENSOURCE() { 
        CM ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-15: "SPECIMEN SOURCE" - creates it if necessary
     */
    public CM getObr15_SPECIMENSOURCE() { 
        CM ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of ORDERING PROVIDER (OBR-16).
     */
    public CN[] getORDERINGPROVIDER() {
        CN[] ret = null;
        try {
            Type[] t = this.getField(16);  
            ret = new CN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OBR-16: "ORDERING PROVIDER" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CN getORDERINGPROVIDER(int rep) { 
        CN ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OBR-16: "ORDERING PROVIDER" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CN getObr16_ORDERINGPROVIDER(int rep) { 
        CN ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * OBR-16: "ORDERING PROVIDER" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CN insertORDERINGPROVIDER(int rep) throws HL7Exception { 
        return (CN) super.insertRepetition(16, rep);
    }



    /**
     * Inserts a repetition of
     * OBR-16: "ORDERING PROVIDER" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CN insertObr16_ORDERINGPROVIDER(int rep) throws HL7Exception { 
        return (CN) super.insertRepetition(16, rep);
    }


    /**
     * Removes a repetition of
     * OBR-16: "ORDERING PROVIDER" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CN removeORDERINGPROVIDER(int rep) throws HL7Exception { 
        return (CN) super.removeRepetition(16, rep);
    }


    /**
     * Removes a repetition of
     * OBR-16: "ORDERING PROVIDER" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CN removeObr16_ORDERINGPROVIDER(int rep) throws HL7Exception { 
        return (CN) super.removeRepetition(16, rep);
    }



    /**
     * Returns all repetitions of ORDER CALL-BACK PHONE NUM (OBR-17).
     */
    public TN[] getORDERCALLBACKPHONENUM() {
        TN[] ret = null;
        try {
            Type[] t = this.getField(17);  
            ret = new TN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (TN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OBR-17: "ORDER CALL-BACK PHONE NUM" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public TN getORDERCALLBACKPHONENUM(int rep) { 
        TN ret = null;
        try {
            Type t = this.getField(17, rep);
            ret = (TN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OBR-17: "ORDER CALL-BACK PHONE NUM" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public TN getObr17_ORDERCALLBACKPHONENUM(int rep) { 
        TN ret = null;
        try {
            Type t = this.getField(17, rep);
            ret = (TN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * OBR-17: "ORDER CALL-BACK PHONE NUM" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN insertORDERCALLBACKPHONENUM(int rep) throws HL7Exception { 
        return (TN) super.insertRepetition(17, rep);
    }



    /**
     * Inserts a repetition of
     * OBR-17: "ORDER CALL-BACK PHONE NUM" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN insertObr17_ORDERCALLBACKPHONENUM(int rep) throws HL7Exception { 
        return (TN) super.insertRepetition(17, rep);
    }


    /**
     * Removes a repetition of
     * OBR-17: "ORDER CALL-BACK PHONE NUM" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN removeORDERCALLBACKPHONENUM(int rep) throws HL7Exception { 
        return (TN) super.removeRepetition(17, rep);
    }


    /**
     * Removes a repetition of
     * OBR-17: "ORDER CALL-BACK PHONE NUM" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN removeObr17_ORDERCALLBACKPHONENUM(int rep) throws HL7Exception { 
        return (TN) super.removeRepetition(17, rep);
    }




    /**
     * Returns
     * OBR-18: "PLACERS FIELD #1" - creates it if necessary
     */
    public ST getPLACERSFIELD1() { 
        ST ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-18: "PLACERS FIELD #1" - creates it if necessary
     */
    public ST getObr18_PLACERSFIELD1() { 
        ST ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OBR-19: "PLACERS FIELD #2" - creates it if necessary
     */
    public ST getPLACERSFIELD2() { 
        ST ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-19: "PLACERS FIELD #2" - creates it if necessary
     */
    public ST getObr19_PLACERSFIELD2() { 
        ST ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OBR-20: "FILLERS FIELD #1" - creates it if necessary
     */
    public ST getFILLERSFIELD1() { 
        ST ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-20: "FILLERS FIELD #1" - creates it if necessary
     */
    public ST getObr20_FILLERSFIELD1() { 
        ST ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OBR-21: "FILLERS FIELD #2" - creates it if necessary
     */
    public ST getFILLERSFIELD2() { 
        ST ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-21: "FILLERS FIELD #2" - creates it if necessary
     */
    public ST getObr21_FILLERSFIELD2() { 
        ST ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OBR-22: "RESULTS RPT/STATUS CHNG - DATE/T" - creates it if necessary
     */
    public TS getRESULTSRPTSTATUSCHNGDATET() { 
        TS ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-22: "RESULTS RPT/STATUS CHNG - DATE/T" - creates it if necessary
     */
    public TS getObr22_RESULTSRPTSTATUSCHNGDATET() { 
        TS ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OBR-23: "CHARGE TO PRACTICE" - creates it if necessary
     */
    public CM getCHARGETOPRACTICE() { 
        CM ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-23: "CHARGE TO PRACTICE" - creates it if necessary
     */
    public CM getObr23_CHARGETOPRACTICE() { 
        CM ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OBR-24: "DIAGNOSTIC SERV SECT ID" - creates it if necessary
     */
    public ID getDIAGNOSTICSERVSECTID() { 
        ID ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-24: "DIAGNOSTIC SERV SECT ID" - creates it if necessary
     */
    public ID getObr24_DIAGNOSTICSERVSECTID() { 
        ID ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OBR-25: "RESULT STATUS" - creates it if necessary
     */
    public ID getRESULTSTATUS() { 
        ID ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-25: "RESULT STATUS" - creates it if necessary
     */
    public ID getObr25_RESULTSTATUS() { 
        ID ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OBR-26: "LINKED RESULTS" - creates it if necessary
     */
    public CE getLINKEDRESULTS() { 
        CE ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-26: "LINKED RESULTS" - creates it if necessary
     */
    public CE getObr26_LINKEDRESULTS() { 
        CE ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of QUANTITY/TIMING (OBR-27).
     */
    public CM[] getQUANTITYTIMING() {
        CM[] ret = null;
        try {
            Type[] t = this.getField(27);  
            ret = new CM[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CM)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OBR-27: "QUANTITY/TIMING" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CM getQUANTITYTIMING(int rep) { 
        CM ret = null;
        try {
            Type t = this.getField(27, rep);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OBR-27: "QUANTITY/TIMING" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CM getObr27_QUANTITYTIMING(int rep) { 
        CM ret = null;
        try {
            Type t = this.getField(27, rep);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * OBR-27: "QUANTITY/TIMING" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CM insertQUANTITYTIMING(int rep) throws HL7Exception { 
        return (CM) super.insertRepetition(27, rep);
    }



    /**
     * Inserts a repetition of
     * OBR-27: "QUANTITY/TIMING" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CM insertObr27_QUANTITYTIMING(int rep) throws HL7Exception { 
        return (CM) super.insertRepetition(27, rep);
    }


    /**
     * Removes a repetition of
     * OBR-27: "QUANTITY/TIMING" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CM removeQUANTITYTIMING(int rep) throws HL7Exception { 
        return (CM) super.removeRepetition(27, rep);
    }


    /**
     * Removes a repetition of
     * OBR-27: "QUANTITY/TIMING" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CM removeObr27_QUANTITYTIMING(int rep) throws HL7Exception { 
        return (CM) super.removeRepetition(27, rep);
    }



    /**
     * Returns all repetitions of RESULT COPIES TO (OBR-28).
     */
    public CN[] getRESULTCOPIESTO() {
        CN[] ret = null;
        try {
            Type[] t = this.getField(28);  
            ret = new CN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OBR-28: "RESULT COPIES TO" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CN getRESULTCOPIESTO(int rep) { 
        CN ret = null;
        try {
            Type t = this.getField(28, rep);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OBR-28: "RESULT COPIES TO" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CN getObr28_RESULTCOPIESTO(int rep) { 
        CN ret = null;
        try {
            Type t = this.getField(28, rep);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * OBR-28: "RESULT COPIES TO" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CN insertRESULTCOPIESTO(int rep) throws HL7Exception { 
        return (CN) super.insertRepetition(28, rep);
    }



    /**
     * Inserts a repetition of
     * OBR-28: "RESULT COPIES TO" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CN insertObr28_RESULTCOPIESTO(int rep) throws HL7Exception { 
        return (CN) super.insertRepetition(28, rep);
    }


    /**
     * Removes a repetition of
     * OBR-28: "RESULT COPIES TO" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CN removeRESULTCOPIESTO(int rep) throws HL7Exception { 
        return (CN) super.removeRepetition(28, rep);
    }


    /**
     * Removes a repetition of
     * OBR-28: "RESULT COPIES TO" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CN removeObr28_RESULTCOPIESTO(int rep) throws HL7Exception { 
        return (CN) super.removeRepetition(28, rep);
    }




    /**
     * Returns
     * OBR-29: "PARENT ACCESSION #" - creates it if necessary
     */
    public CM getPARENTACCESSION() { 
        CM ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-29: "PARENT ACCESSION #" - creates it if necessary
     */
    public CM getObr29_PARENTACCESSION() { 
        CM ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OBR-30: "TRANSPORTATION MODE" - creates it if necessary
     */
    public ID getTRANSPORTATIONMODE() { 
        ID ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-30: "TRANSPORTATION MODE" - creates it if necessary
     */
    public ID getObr30_TRANSPORTATIONMODE() { 
        ID ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of REASON FOR STUDY (OBR-31).
     */
    public CE[] getREASONFORSTUDY() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(31);  
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OBR-31: "REASON FOR STUDY" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getREASONFORSTUDY(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(31, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OBR-31: "REASON FOR STUDY" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getObr31_REASONFORSTUDY(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(31, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * OBR-31: "REASON FOR STUDY" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertREASONFORSTUDY(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(31, rep);
    }



    /**
     * Inserts a repetition of
     * OBR-31: "REASON FOR STUDY" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertObr31_REASONFORSTUDY(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(31, rep);
    }


    /**
     * Removes a repetition of
     * OBR-31: "REASON FOR STUDY" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeREASONFORSTUDY(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(31, rep);
    }


    /**
     * Removes a repetition of
     * OBR-31: "REASON FOR STUDY" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeObr31_REASONFORSTUDY(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(31, rep);
    }




    /**
     * Returns
     * OBR-32: "PRINCIPAL RESULT INTERPRETER" - creates it if necessary
     */
    public CN getPRINCIPALRESULTINTERPRETER() { 
        CN ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-32: "PRINCIPAL RESULT INTERPRETER" - creates it if necessary
     */
    public CN getObr32_PRINCIPALRESULTINTERPRETER() { 
        CN ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OBR-33: "ASSISTANT RESULT INTERPRETER" - creates it if necessary
     */
    public CN getASSISTANTRESULTINTERPRETER() { 
        CN ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-33: "ASSISTANT RESULT INTERPRETER" - creates it if necessary
     */
    public CN getObr33_ASSISTANTRESULTINTERPRETER() { 
        CN ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OBR-34: "TECHNICIAN" - creates it if necessary
     */
    public CN getTECHNICIAN() { 
        CN ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-34: "TECHNICIAN" - creates it if necessary
     */
    public CN getObr34_TECHNICIAN() { 
        CN ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OBR-35: "TRANSCRIPTIONIST" - creates it if necessary
     */
    public CN getTRANSCRIPTIONIST() { 
        CN ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-35: "TRANSCRIPTIONIST" - creates it if necessary
     */
    public CN getObr35_TRANSCRIPTIONIST() { 
        CN ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OBR-36: "SCHEDULED - DATE/TIME" - creates it if necessary
     */
    public TS getSCHEDULEDDATETIME() { 
        TS ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OBR-36: "SCHEDULED - DATE/TIME" - creates it if necessary
     */
    public TS getObr36_SCHEDULEDDATETIME() { 
        TS ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new CM(getMessage());
          case 2: return new CM(getMessage());
          case 3: return new CE(getMessage());
          case 4: return new ST(getMessage());
          case 5: return new TS(getMessage());
          case 6: return new TS(getMessage());
          case 7: return new TS(getMessage());
          case 8: return new CQ(getMessage());
          case 9: return new CN(getMessage());
          case 10: return new ST(getMessage());
          case 11: return new CM(getMessage());
          case 12: return new ST(getMessage());
          case 13: return new TS(getMessage());
          case 14: return new CM(getMessage());
          case 15: return new CN(getMessage());
          case 16: return new TN(getMessage());
          case 17: return new ST(getMessage());
          case 18: return new ST(getMessage());
          case 19: return new ST(getMessage());
          case 20: return new ST(getMessage());
          case 21: return new TS(getMessage());
          case 22: return new CM(getMessage());
          case 23: return new ID(getMessage(), new Integer( 74 ));
          case 24: return new ID(getMessage(), new Integer( 123 ));
          case 25: return new CE(getMessage());
          case 26: return new CM(getMessage());
          case 27: return new CN(getMessage());
          case 28: return new CM(getMessage());
          case 29: return new ID(getMessage(), new Integer( 124 ));
          case 30: return new CE(getMessage());
          case 31: return new CN(getMessage());
          case 32: return new CN(getMessage());
          case 33: return new CN(getMessage());
          case 34: return new CN(getMessage());
          case 35: return new TS(getMessage());
          default: return null;
       }
   }


}

