/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v21.segment;

// import ca.uhn.hl7v2.model.v21.group.*;
import ca.uhn.hl7v2.model.v21.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 PID message segment (PATIENT IDENTIFICATION). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>PID-1: SET ID - PATIENT ID (SI) <b>optional </b>
     * <li>PID-2: PATIENT ID EXTERNAL (EXTERNAL ID) (CK) <b>optional </b>
     * <li>PID-3: PATIENT ID INTERNAL (INTERNAL ID) (CK) <b> </b>
     * <li>PID-4: ALTERNATE PATIENT ID (ST) <b>optional </b>
     * <li>PID-5: PATIENT NAME (PN) <b> </b>
     * <li>PID-6: MOTHER'S MAIDEN NAME (ST) <b>optional </b>
     * <li>PID-7: DATE OF BIRTH (DT) <b>optional </b>
     * <li>PID-8: SEX (ID) <b>optional </b>
     * <li>PID-9: PATIENT ALIAS (PN) <b>optional repeating</b>
     * <li>PID-10: ETHNIC GROUP (ID) <b>optional </b>
     * <li>PID-11: PATIENT ADDRESS (AD) <b>optional </b>
     * <li>PID-12: COUNTY CODE (ID) <b>optional </b>
     * <li>PID-13: PHONE NUMBER - HOME (TN) <b>optional repeating</b>
     * <li>PID-14: PHONE NUMBER - BUSINESS (TN) <b>optional repeating</b>
     * <li>PID-15: LANGUAGE - PATIENT (ST) <b>optional </b>
     * <li>PID-16: MARITAL STATUS (ID) <b>optional </b>
     * <li>PID-17: RELIGION (ID) <b>optional </b>
     * <li>PID-18: PATIENT ACCOUNT NUMBER (CK) <b>optional </b>
     * <li>PID-19: SSN NUMBER - PATIENT (ST) <b>optional </b>
     * <li>PID-20: DRIVER'S LIC NUM - PATIENT (CM) <b>optional </b>
 * </ul>
 */
public class PID extends AbstractSegment {

    /** 
     * Creates a new PID segment
     */
    public PID(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "SET ID - PATIENT ID");
                                  this.add(CK.class, false, 1, 16, new Object[]{ getMessage(), new Integer(61) }, "PATIENT ID EXTERNAL (EXTERNAL ID)");
                                  this.add(CK.class, true, 1, 16, new Object[]{ getMessage(), new Integer(61) }, "PATIENT ID INTERNAL (INTERNAL ID)");
                                  this.add(ST.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "ALTERNATE PATIENT ID");
                                  this.add(PN.class, true, 1, 48, new Object[]{ getMessage(), new Integer(0) }, "PATIENT NAME");
                                  this.add(ST.class, false, 1, 30, new Object[]{ getMessage(), new Integer(0) }, "MOTHER'S MAIDEN NAME");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "DATE OF BIRTH");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "SEX");
                                  this.add(PN.class, false, 0, 48, new Object[]{ getMessage(), new Integer(0) }, "PATIENT ALIAS");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "ETHNIC GROUP");
                                  this.add(AD.class, false, 1, 106, new Object[]{ getMessage(), new Integer(0) }, "PATIENT ADDRESS");
                                  this.add(ID.class, false, 1, 4, new Object[]{ getMessage() }, "COUNTY CODE");
                                  this.add(TN.class, false, 3, 40, new Object[]{ getMessage(), new Integer(0) }, "PHONE NUMBER - HOME");
                                  this.add(TN.class, false, 3, 40, new Object[]{ getMessage(), new Integer(0) }, "PHONE NUMBER - BUSINESS");
                                  this.add(ST.class, false, 1, 25, new Object[]{ getMessage(), new Integer(0) }, "LANGUAGE - PATIENT");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "MARITAL STATUS");
                                  this.add(ID.class, false, 1, 3, new Object[]{ getMessage() }, "RELIGION");
                                  this.add(CK.class, false, 1, 20, new Object[]{ getMessage(), new Integer(61) }, "PATIENT ACCOUNT NUMBER");
                                  this.add(ST.class, false, 1, 16, new Object[]{ getMessage(), new Integer(0) }, "SSN NUMBER - PATIENT");
                                  this.add(CM.class, false, 1, 25, new Object[]{ getMessage(), new Integer(0) }, "DRIVER'S LIC NUM - PATIENT");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PID - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * PID-1: "SET ID - PATIENT ID" - creates it if necessary
     */
    public SI getSETIDPATIENTID() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-1: "SET ID - PATIENT ID" - creates it if necessary
     */
    public SI getPid1_SETIDPATIENTID() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-2: "PATIENT ID EXTERNAL (EXTERNAL ID)" - creates it if necessary
     */
    public CK getPATIENTIDEXTERNALEXTERNALID() { 
        CK ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CK)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-2: "PATIENT ID EXTERNAL (EXTERNAL ID)" - creates it if necessary
     */
    public CK getPid2_PATIENTIDEXTERNALEXTERNALID() { 
        CK ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CK)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-3: "PATIENT ID INTERNAL (INTERNAL ID)" - creates it if necessary
     */
    public CK getPATIENTIDINTERNALINTERNALID() { 
        CK ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CK)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-3: "PATIENT ID INTERNAL (INTERNAL ID)" - creates it if necessary
     */
    public CK getPid3_PATIENTIDINTERNALINTERNALID() { 
        CK ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CK)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-4: "ALTERNATE PATIENT ID" - creates it if necessary
     */
    public ST getALTERNATEPATIENTID() { 
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-4: "ALTERNATE PATIENT ID" - creates it if necessary
     */
    public ST getPid4_ALTERNATEPATIENTID() { 
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-5: "PATIENT NAME" - creates it if necessary
     */
    public PN getPATIENTNAME() { 
        PN ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (PN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-5: "PATIENT NAME" - creates it if necessary
     */
    public PN getPid5_PATIENTNAME() { 
        PN ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (PN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-6: "MOTHER'S MAIDEN NAME" - creates it if necessary
     */
    public ST getMOTHERSMAIDENNAME() { 
        ST ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-6: "MOTHER'S MAIDEN NAME" - creates it if necessary
     */
    public ST getPid6_MOTHERSMAIDENNAME() { 
        ST ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-7: "DATE OF BIRTH" - creates it if necessary
     */
    public DT getDATEOFBIRTH() { 
        DT ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-7: "DATE OF BIRTH" - creates it if necessary
     */
    public DT getPid7_DATEOFBIRTH() { 
        DT ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-8: "SEX" - creates it if necessary
     */
    public ID getSEX() { 
        ID ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-8: "SEX" - creates it if necessary
     */
    public ID getPid8_SEX() { 
        ID ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of PATIENT ALIAS (PID-9).
     */
    public PN[] getPATIENTALIAS() {
        PN[] ret = null;
        try {
            Type[] t = this.getField(9);  
            ret = new PN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (PN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-9: "PATIENT ALIAS" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public PN getPATIENTALIAS(int rep) { 
        PN ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (PN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-9: "PATIENT ALIAS" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public PN getPid9_PATIENTALIAS(int rep) { 
        PN ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (PN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PID-9: "PATIENT ALIAS" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public PN insertPATIENTALIAS(int rep) throws HL7Exception { 
        return (PN) super.insertRepetition(9, rep);
    }



    /**
     * Inserts a repetition of
     * PID-9: "PATIENT ALIAS" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public PN insertPid9_PATIENTALIAS(int rep) throws HL7Exception { 
        return (PN) super.insertRepetition(9, rep);
    }


    /**
     * Removes a repetition of
     * PID-9: "PATIENT ALIAS" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public PN removePATIENTALIAS(int rep) throws HL7Exception { 
        return (PN) super.removeRepetition(9, rep);
    }


    /**
     * Removes a repetition of
     * PID-9: "PATIENT ALIAS" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public PN removePid9_PATIENTALIAS(int rep) throws HL7Exception { 
        return (PN) super.removeRepetition(9, rep);
    }




    /**
     * Returns
     * PID-10: "ETHNIC GROUP" - creates it if necessary
     */
    public ID getETHNICGROUP() { 
        ID ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-10: "ETHNIC GROUP" - creates it if necessary
     */
    public ID getPid10_ETHNICGROUP() { 
        ID ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-11: "PATIENT ADDRESS" - creates it if necessary
     */
    public AD getPATIENTADDRESS() { 
        AD ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (AD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-11: "PATIENT ADDRESS" - creates it if necessary
     */
    public AD getPid11_PATIENTADDRESS() { 
        AD ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (AD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-12: "COUNTY CODE" - creates it if necessary
     */
    public ID getCOUNTYCODE() { 
        ID ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-12: "COUNTY CODE" - creates it if necessary
     */
    public ID getPid12_COUNTYCODE() { 
        ID ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of PHONE NUMBER - HOME (PID-13).
     */
    public TN[] getPHONENUMBERHOME() {
        TN[] ret = null;
        try {
            Type[] t = this.getField(13);  
            ret = new TN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (TN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-13: "PHONE NUMBER - HOME" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public TN getPHONENUMBERHOME(int rep) { 
        TN ret = null;
        try {
            Type t = this.getField(13, rep);
            ret = (TN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-13: "PHONE NUMBER - HOME" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public TN getPid13_PHONENUMBERHOME(int rep) { 
        TN ret = null;
        try {
            Type t = this.getField(13, rep);
            ret = (TN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PID-13: "PHONE NUMBER - HOME" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN insertPHONENUMBERHOME(int rep) throws HL7Exception { 
        return (TN) super.insertRepetition(13, rep);
    }



    /**
     * Inserts a repetition of
     * PID-13: "PHONE NUMBER - HOME" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN insertPid13_PHONENUMBERHOME(int rep) throws HL7Exception { 
        return (TN) super.insertRepetition(13, rep);
    }


    /**
     * Removes a repetition of
     * PID-13: "PHONE NUMBER - HOME" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN removePHONENUMBERHOME(int rep) throws HL7Exception { 
        return (TN) super.removeRepetition(13, rep);
    }


    /**
     * Removes a repetition of
     * PID-13: "PHONE NUMBER - HOME" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN removePid13_PHONENUMBERHOME(int rep) throws HL7Exception { 
        return (TN) super.removeRepetition(13, rep);
    }



    /**
     * Returns all repetitions of PHONE NUMBER - BUSINESS (PID-14).
     */
    public TN[] getPHONENUMBERBUSINESS() {
        TN[] ret = null;
        try {
            Type[] t = this.getField(14);  
            ret = new TN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (TN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-14: "PHONE NUMBER - BUSINESS" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public TN getPHONENUMBERBUSINESS(int rep) { 
        TN ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (TN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-14: "PHONE NUMBER - BUSINESS" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public TN getPid14_PHONENUMBERBUSINESS(int rep) { 
        TN ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (TN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PID-14: "PHONE NUMBER - BUSINESS" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN insertPHONENUMBERBUSINESS(int rep) throws HL7Exception { 
        return (TN) super.insertRepetition(14, rep);
    }



    /**
     * Inserts a repetition of
     * PID-14: "PHONE NUMBER - BUSINESS" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN insertPid14_PHONENUMBERBUSINESS(int rep) throws HL7Exception { 
        return (TN) super.insertRepetition(14, rep);
    }


    /**
     * Removes a repetition of
     * PID-14: "PHONE NUMBER - BUSINESS" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN removePHONENUMBERBUSINESS(int rep) throws HL7Exception { 
        return (TN) super.removeRepetition(14, rep);
    }


    /**
     * Removes a repetition of
     * PID-14: "PHONE NUMBER - BUSINESS" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN removePid14_PHONENUMBERBUSINESS(int rep) throws HL7Exception { 
        return (TN) super.removeRepetition(14, rep);
    }




    /**
     * Returns
     * PID-15: "LANGUAGE - PATIENT" - creates it if necessary
     */
    public ST getLANGUAGEPATIENT() { 
        ST ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-15: "LANGUAGE - PATIENT" - creates it if necessary
     */
    public ST getPid15_LANGUAGEPATIENT() { 
        ST ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-16: "MARITAL STATUS" - creates it if necessary
     */
    public ID getMARITALSTATUS() { 
        ID ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-16: "MARITAL STATUS" - creates it if necessary
     */
    public ID getPid16_MARITALSTATUS() { 
        ID ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-17: "RELIGION" - creates it if necessary
     */
    public ID getRELIGION() { 
        ID ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-17: "RELIGION" - creates it if necessary
     */
    public ID getPid17_RELIGION() { 
        ID ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-18: "PATIENT ACCOUNT NUMBER" - creates it if necessary
     */
    public CK getPATIENTACCOUNTNUMBER() { 
        CK ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (CK)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-18: "PATIENT ACCOUNT NUMBER" - creates it if necessary
     */
    public CK getPid18_PATIENTACCOUNTNUMBER() { 
        CK ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (CK)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-19: "SSN NUMBER - PATIENT" - creates it if necessary
     */
    public ST getSSNNUMBERPATIENT() { 
        ST ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-19: "SSN NUMBER - PATIENT" - creates it if necessary
     */
    public ST getPid19_SSNNUMBERPATIENT() { 
        ST ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-20: "DRIVER'S LIC NUM - PATIENT" - creates it if necessary
     */
    public CM getDRIVERSLICNUMPATIENT() { 
        CM ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-20: "DRIVER'S LIC NUM - PATIENT" - creates it if necessary
     */
    public CM getPid20_DRIVERSLICNUMPATIENT() { 
        CM ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new CK(getMessage());
          case 2: return new CK(getMessage());
          case 3: return new ST(getMessage());
          case 4: return new PN(getMessage());
          case 5: return new ST(getMessage());
          case 6: return new DT(getMessage());
          case 7: return new ID(getMessage(), new Integer( 1 ));
          case 8: return new PN(getMessage());
          case 9: return new ID(getMessage(), new Integer( 5 ));
          case 10: return new AD(getMessage());
          case 11: return new ID(getMessage(), new Integer( 0 ));
          case 12: return new TN(getMessage());
          case 13: return new TN(getMessage());
          case 14: return new ST(getMessage());
          case 15: return new ID(getMessage(), new Integer( 2 ));
          case 16: return new ID(getMessage(), new Integer( 6 ));
          case 17: return new CK(getMessage());
          case 18: return new ST(getMessage());
          case 19: return new CM(getMessage());
          default: return null;
       }
   }


}

